/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.ws.rs;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.BaseTest;
import org.gluu.oxauth.client.RegisterRequest;
import org.gluu.oxauth.client.TokenRequest;
import org.gluu.oxauth.model.common.AuthenticationMethod;
import org.gluu.oxauth.model.common.GrantType;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.crypto.OxAuthCryptoProvider;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.register.ApplicationType;
import org.gluu.oxauth.model.register.RegisterResponseParam;
import org.gluu.oxauth.model.util.StringUtils;
import org.gluu.oxauth.util.ServerUtil;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class TokenRestWebServiceWithRSAlgEmbeddedTest
extends BaseTest {
    @ArquillianResource
    private URI url;
    private static String clientId1;
    private static String clientSecret1;
    private static String clientId2;
    private static String clientSecret2;
    private static String clientId3;
    private static String clientSecret3;
    private static String clientId4;
    private static String clientSecret4;
    private static String clientId5;
    private static String clientSecret5;
    private static String clientId6;
    private static String clientSecret6;

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestAccessTokenWithClientSecretJwtRS256Step1(String registerPath, String redirectUris, String jwksUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setJwksUri(jwksUri);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        registerRequest.setGrantTypes(grantTypes);
        String registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        Response response = request.post(Entity.json((Object)registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        TokenRestWebServiceWithRSAlgEmbeddedTest.showResponse("requestAccessTokenWithClientSecretJwtRS256Step1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            clientId1 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
            clientSecret1 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"tokenPath", "userId", "userSecret", "audience", "RS256_keyId", "keyStoreFile", "keyStoreSecret"})
    @Test(dependsOnMethods={"requestAccessTokenWithClientSecretJwtRS256Step1"})
    public void requestAccessTokenWithClientSecretJwtRS256Step2(String tokenPath, String userId, String userSecret, String audience, String keyId, String keyStoreFile, String keyStoreSecret) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + tokenPath).request();
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, null);
        TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        tokenRequest.setUsername(userId);
        tokenRequest.setPassword(userSecret);
        tokenRequest.setScope("email read_stream manage_pages");
        tokenRequest.setAuthUsername(clientId1);
        tokenRequest.setAuthPassword(clientSecret1);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS256);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setAudience(audience);
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(tokenRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        TokenRestWebServiceWithRSAlgEmbeddedTest.showResponse("requestAccessTokenWithClientSecretJwtRS256Step2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
            Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
            Assert.assertTrue((boolean)jsonObj.has("scope"), (String)"Unexpected result: scope not found");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestAccessTokenWithClientSecretJwtRS384Step1(String registerPath, String redirectUris, String jwksUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setJwksUri(jwksUri);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        registerRequest.setGrantTypes(grantTypes);
        String registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        Response response = request.post(Entity.json((Object)registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        TokenRestWebServiceWithRSAlgEmbeddedTest.showResponse("requestAccessTokenWithClientSecretJwtRS384Step1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            clientId2 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
            clientSecret2 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"tokenPath", "userId", "userSecret", "audience", "RS384_keyId", "keyStoreFile", "keyStoreSecret"})
    @Test(dependsOnMethods={"requestAccessTokenWithClientSecretJwtRS384Step1"})
    public void requestAccessTokenWithClientSecretJwtRS384Step2(String tokenPath, String userId, String userSecret, String audience, String keyId, String keyStoreFile, String keyStoreSecret) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + tokenPath).request();
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, null);
        TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        tokenRequest.setUsername(userId);
        tokenRequest.setPassword(userSecret);
        tokenRequest.setScope("email read_stream manage_pages");
        tokenRequest.setAuthUsername(clientId2);
        tokenRequest.setAuthPassword(clientSecret2);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS384);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setAudience(audience);
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(tokenRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        TokenRestWebServiceWithRSAlgEmbeddedTest.showResponse("requestAccessTokenWithClientSecretJwtRS384Step2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
            Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
            Assert.assertTrue((boolean)jsonObj.has("scope"), (String)"Unexpected result: scope not found");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestAccessTokenWithClientSecretJwtRS512Step1(String registerPath, String redirectUris, String jwksUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setJwksUri(jwksUri);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        registerRequest.setGrantTypes(grantTypes);
        String registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        Response response = request.post(Entity.json((Object)registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        TokenRestWebServiceWithRSAlgEmbeddedTest.showResponse("requestAccessTokenWithClientSecretJwtRS512Step1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            clientId3 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
            clientSecret3 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"tokenPath", "userId", "userSecret", "audience", "RS512_keyId", "keyStoreFile", "keyStoreSecret"})
    @Test(dependsOnMethods={"requestAccessTokenWithClientSecretJwtRS512Step1"})
    public void requestAccessTokenWithClientSecretJwtRS512Step2(String tokenPath, String userId, String userSecret, String audience, String keyId, String keyStoreFile, String keyStoreSecret) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + tokenPath).request();
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, null);
        TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        tokenRequest.setUsername(userId);
        tokenRequest.setPassword(userSecret);
        tokenRequest.setScope("email read_stream manage_pages");
        tokenRequest.setAuthUsername(clientId3);
        tokenRequest.setAuthPassword(clientSecret3);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS512);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setAudience(audience);
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(tokenRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        TokenRestWebServiceWithRSAlgEmbeddedTest.showResponse("requestAccessTokenWithClientSecretJwtRS512Step2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
            Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
            Assert.assertTrue((boolean)jsonObj.has("scope"), (String)"Unexpected result: scope not found");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestAccessTokenWithClientSecretJwtRS256X509CertStep1(String registerPath, String redirectUris, String jwksUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setJwksUri(jwksUri);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        registerRequest.setGrantTypes(grantTypes);
        String registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        Response response = request.post(Entity.json((Object)registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        TokenRestWebServiceWithRSAlgEmbeddedTest.showResponse("requestAccessTokenWithClientSecretJwtRS256X509CertStep1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            clientId4 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
            clientSecret4 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"tokenPath", "userId", "userSecret", "audience", "RS256_keyId", "keyStoreFile", "keyStoreSecret"})
    @Test(dependsOnMethods={"requestAccessTokenWithClientSecretJwtRS256X509CertStep1"})
    public void requestAccessTokenWithClientSecretJwtRS256X509CertStep2(String tokenPath, String userId, String userSecret, String audience, String keyId, String keyStoreFile, String keyStoreSecret) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + tokenPath).request();
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, null);
        TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        tokenRequest.setUsername(userId);
        tokenRequest.setPassword(userSecret);
        tokenRequest.setScope("email read_stream manage_pages");
        tokenRequest.setAuthUsername(clientId4);
        tokenRequest.setAuthPassword(clientSecret4);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS256);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setAudience(audience);
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(tokenRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        TokenRestWebServiceWithRSAlgEmbeddedTest.showResponse("requestAccessTokenWithClientSecretJwtRS256X509CertStep2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
            Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
            Assert.assertTrue((boolean)jsonObj.has("scope"), (String)"Unexpected result: scope not found");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestAccessTokenWithClientSecretJwtRS384X509CertStep1(String registerPath, String redirectUris, String jwksUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setJwksUri(jwksUri);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        registerRequest.setGrantTypes(grantTypes);
        String registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        Response response = request.post(Entity.json((Object)registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        TokenRestWebServiceWithRSAlgEmbeddedTest.showResponse("requestAccessTokenWithClientSecretJwtRS384X509CertStep1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            clientId5 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
            clientSecret5 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"tokenPath", "userId", "userSecret", "audience", "RS384_keyId", "keyStoreFile", "keyStoreSecret"})
    @Test(dependsOnMethods={"requestAccessTokenWithClientSecretJwtRS384X509CertStep1"})
    public void requestAccessTokenWithClientSecretJwtRS384X509CertStep2(String tokenPath, String userId, String userSecret, String audience, String keyId, String keyStoreFile, String keyStoreSecret) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + tokenPath).request();
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, null);
        TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        tokenRequest.setUsername(userId);
        tokenRequest.setPassword(userSecret);
        tokenRequest.setScope("email read_stream manage_pages");
        tokenRequest.setAuthUsername(clientId5);
        tokenRequest.setAuthPassword(clientSecret5);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS384);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setAudience(audience);
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(tokenRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        TokenRestWebServiceWithRSAlgEmbeddedTest.showResponse("requestAccessTokenWithClientSecretJwtRS384X509CertStep2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
            Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
            Assert.assertTrue((boolean)jsonObj.has("scope"), (String)"Unexpected result: scope not found");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestAccessTokenWithClientSecretJwtRS512X509CertStep1(String registerPath, String redirectUris, String jwksUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setJwksUri(jwksUri);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        registerRequest.setGrantTypes(grantTypes);
        String registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        Response response = request.post(Entity.json((Object)registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        TokenRestWebServiceWithRSAlgEmbeddedTest.showResponse("requestAccessTokenWithClientSecretJwtRS512X509CertStep1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            clientId6 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
            clientSecret6 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"tokenPath", "userId", "userSecret", "audience", "RS512_keyId", "keyStoreFile", "keyStoreSecret"})
    @Test(dependsOnMethods={"requestAccessTokenWithClientSecretJwtRS512X509CertStep1"})
    public void requestAccessTokenWithClientSecretJwtRS512X509CertStep2(String tokenPath, String userId, String userSecret, String audience, String keyId, String keyStoreFile, String keyStoreSecret) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + tokenPath).request();
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, null);
        TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        tokenRequest.setUsername(userId);
        tokenRequest.setPassword(userSecret);
        tokenRequest.setScope("email read_stream manage_pages");
        tokenRequest.setAuthUsername(clientId6);
        tokenRequest.setAuthPassword(clientSecret6);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS512);
        tokenRequest.setKeyId(keyId);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setAudience(audience);
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(tokenRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        TokenRestWebServiceWithRSAlgEmbeddedTest.showResponse("requestAccessTokenWithClientSecretJwtRS512X509CertStep2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
            Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
            Assert.assertTrue((boolean)jsonObj.has("scope"), (String)"Unexpected result: scope not found");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }
}

