/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.ws.rs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.BaseTest;
import org.gluu.oxauth.client.AuthorizationRequest;
import org.gluu.oxauth.client.QueryStringDecoder;
import org.gluu.oxauth.client.RegisterRequest;
import org.gluu.oxauth.client.ResponseAsserter;
import org.gluu.oxauth.client.model.authorize.Claim;
import org.gluu.oxauth.client.model.authorize.ClaimValue;
import org.gluu.oxauth.client.model.authorize.JwtAuthorizationRequest;
import org.gluu.oxauth.model.common.Prompt;
import org.gluu.oxauth.model.common.ResponseType;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.crypto.OxAuthCryptoProvider;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.register.ApplicationType;
import org.gluu.oxauth.model.register.RegisterResponseParam;
import org.gluu.oxauth.model.util.StringUtils;
import org.gluu.oxauth.util.ServerUtil;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class OpenIDRequestObjectWithESAlgEmbeddedTest
extends BaseTest {
    public static final String ACR_VALUE = "basic";
    @ArquillianResource
    private URI url;
    private static String clientId1;
    private static String clientId2;
    private static String clientId3;
    private static String clientId4;
    private static String clientId5;
    private static String clientId6;

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestParameterMethodES256Step1(String registerPath, String redirectUris, String jwksUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        String registerRequestContent = null;
        try {
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setJwksUri(jwksUri);
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.ES256);
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (JSONException e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
        Response response = request.post(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        OpenIDRequestObjectWithESAlgEmbeddedTest.showResponse("requestParameterMethodES256Step1", response, entity);
        ResponseAsserter responseAsserter = ResponseAsserter.of((int)response.getStatus(), (String)entity);
        responseAsserter.assertRegisterResponse();
        clientId1 = responseAsserter.getJson().getJson().getString(RegisterResponseParam.CLIENT_ID.toString());
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri", "ES256_keyId", "dnName", "keyStoreFile", "keyStoreSecret"})
    @Test(dependsOnMethods={"requestParameterMethodES256Step1"})
    public void requestParameterMethodES256Step2(String authorizePath, String userId, String userSecret, String redirectUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret) throws Exception {
        Invocation.Builder request = null;
        try {
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
            List<String> scopes = Arrays.asList("openid");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId1, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            authorizationRequest.getPrompts().add(Prompt.NONE);
            authorizationRequest.setAuthUsername(userId);
            authorizationRequest.setAuthPassword(userSecret);
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.ES256, (AbstractCryptoProvider)cryptoProvider);
            jwtAuthorizationRequest.setKeyId(keyId);
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{ACR_VALUE})));
            String authJwt = jwtAuthorizationRequest.getEncodedJwt();
            authorizationRequest.setRequest(authJwt);
            System.out.println("Request JWT: " + authJwt);
            request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
            request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
            request.header("Accept", (Object)"text/plain");
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage(), (Throwable)ex);
        }
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        OpenIDRequestObjectWithESAlgEmbeddedTest.showResponse("requestParameterMethodES256Step2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        try {
            URI uri = new URI(response.getLocation().toString());
            Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
            Map params = QueryStringDecoder.decode((String)uri.getFragment());
            Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
            Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
            Assert.assertNotNull(params.get("state"), (String)"The state is null");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestParameterMethodES384Step1(String registerPath, String redirectUris, String jwksUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        String registerRequestContent = null;
        try {
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setJwksUri(jwksUri);
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.ES384);
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Response response = request.post(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        OpenIDRequestObjectWithESAlgEmbeddedTest.showResponse("requestParameterMethodES384Step1", response, entity);
        ResponseAsserter responseAsserter = ResponseAsserter.of((int)response.getStatus(), (String)entity);
        responseAsserter.assertRegisterResponse();
        clientId2 = responseAsserter.getJson().getJson().getString(RegisterResponseParam.CLIENT_ID.toString());
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri", "ES384_keyId", "dnName", "keyStoreFile", "keyStoreSecret"})
    @Test(dependsOnMethods={"requestParameterMethodES384Step1"})
    public void requestParameterMethodES384Step2(String authorizePath, String userId, String userSecret, String redirectUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret) throws Exception {
        Invocation.Builder request = null;
        try {
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
            List<String> scopes = Arrays.asList("openid");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId2, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            authorizationRequest.getPrompts().add(Prompt.NONE);
            authorizationRequest.setAuthUsername(userId);
            authorizationRequest.setAuthPassword(userSecret);
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.ES384, (AbstractCryptoProvider)cryptoProvider);
            jwtAuthorizationRequest.setKeyId(keyId);
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{ACR_VALUE})));
            String authJwt = jwtAuthorizationRequest.getEncodedJwt();
            authorizationRequest.setRequest(authJwt);
            System.out.println("Request JWT: " + authJwt);
            request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
            request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
            request.header("Accept", (Object)"text/plain");
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage(), (Throwable)ex);
        }
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        OpenIDRequestObjectWithESAlgEmbeddedTest.showResponse("requestParameterMethodES384Step2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        try {
            URI uri = new URI(response.getLocation().toString());
            Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
            Map params = QueryStringDecoder.decode((String)uri.getFragment());
            Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
            Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
            Assert.assertNotNull(params.get("state"), (String)"The state is null");
        }
        catch (URISyntaxException e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestParameterMethodES512Step1(String registerPath, String redirectUris, String jwksUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        String registerRequestContent = null;
        try {
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setJwksUri(jwksUri);
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.ES512);
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (JSONException e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
        Response response = request.post(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        OpenIDRequestObjectWithESAlgEmbeddedTest.showResponse("requestParameterMethodES512Step1", response, entity);
        ResponseAsserter responseAsserter = ResponseAsserter.of((int)response.getStatus(), (String)entity);
        responseAsserter.assertRegisterResponse();
        clientId3 = responseAsserter.getJson().getJson().getString(RegisterResponseParam.CLIENT_ID.toString());
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri", "ES512_keyId", "dnName", "keyStoreFile", "keyStoreSecret"})
    @Test(dependsOnMethods={"requestParameterMethodES512Step1"})
    public void requestParameterMethodES512Step2(String authorizePath, String userId, String userSecret, String redirectUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret) throws Exception {
        Invocation.Builder request = null;
        try {
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
            List<String> scopes = Arrays.asList("openid");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId3, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            authorizationRequest.getPrompts().add(Prompt.NONE);
            authorizationRequest.setAuthUsername(userId);
            authorizationRequest.setAuthPassword(userSecret);
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.ES512, (AbstractCryptoProvider)cryptoProvider);
            jwtAuthorizationRequest.setKeyId(keyId);
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{ACR_VALUE})));
            String authJwt = jwtAuthorizationRequest.getEncodedJwt();
            authorizationRequest.setRequest(authJwt);
            System.out.println("Request JWT: " + authJwt);
            request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
            request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
            request.header("Accept", (Object)"text/plain");
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage(), (Throwable)ex);
        }
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        OpenIDRequestObjectWithESAlgEmbeddedTest.showResponse("requestParameterMethodES512Step2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        try {
            URI uri = new URI(response.getLocation().toString());
            Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
            Map params = QueryStringDecoder.decode((String)uri.getFragment());
            Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
            Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
            Assert.assertNotNull(params.get("state"), (String)"The state is null");
        }
        catch (URISyntaxException e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestParameterMethodES256X509CertStep1(String registerPath, String redirectUris, String jwksUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        String registerRequestContent = null;
        try {
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setJwksUri(jwksUri);
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.ES256);
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (JSONException e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
        Response response = request.post(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        OpenIDRequestObjectWithESAlgEmbeddedTest.showResponse("requestParameterMethodES256X509CertStep1", response, entity);
        ResponseAsserter responseAsserter = ResponseAsserter.of((int)response.getStatus(), (String)entity);
        responseAsserter.assertRegisterResponse();
        clientId4 = responseAsserter.getJson().getJson().getString(RegisterResponseParam.CLIENT_ID.toString());
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri", "ES256_keyId", "dnName", "keyStoreFile", "keyStoreSecret"})
    @Test(dependsOnMethods={"requestParameterMethodES256X509CertStep1"})
    public void requestParameterMethodES256X509CertStep2(String authorizePath, String userId, String userSecret, String redirectUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret) throws Exception {
        Invocation.Builder request = null;
        try {
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
            List<String> scopes = Arrays.asList("openid");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId4, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            authorizationRequest.getPrompts().add(Prompt.NONE);
            authorizationRequest.setAuthUsername(userId);
            authorizationRequest.setAuthPassword(userSecret);
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.ES256, (AbstractCryptoProvider)cryptoProvider);
            jwtAuthorizationRequest.setKeyId(keyId);
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{ACR_VALUE})));
            String authJwt = jwtAuthorizationRequest.getEncodedJwt();
            authorizationRequest.setRequest(authJwt);
            System.out.println("Request JWT: " + authJwt);
            request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
            request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
            request.header("Accept", (Object)"text/plain");
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage(), (Throwable)ex);
        }
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        OpenIDRequestObjectWithESAlgEmbeddedTest.showResponse("requestParameterMethodES256X509CertStep2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        try {
            URI uri = new URI(response.getLocation().toString());
            Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
            Map params = QueryStringDecoder.decode((String)uri.getFragment());
            Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
            Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
            Assert.assertNotNull(params.get("state"), (String)"The state is null");
        }
        catch (URISyntaxException e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestParameterMethodES384X509CertStep1(String registerPath, String redirectUris, String jwksUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        String registerRequestContent = null;
        try {
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setJwksUri(jwksUri);
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.ES384);
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (JSONException e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
        Response response = request.post(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        OpenIDRequestObjectWithESAlgEmbeddedTest.showResponse("requestParameterMethodES384X509CertStep1", response, entity);
        ResponseAsserter responseAsserter = ResponseAsserter.of((int)response.getStatus(), (String)entity);
        responseAsserter.assertRegisterResponse();
        clientId5 = responseAsserter.getJson().getJson().getString(RegisterResponseParam.CLIENT_ID.toString());
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri", "ES384_keyId", "dnName", "keyStoreFile", "keyStoreSecret"})
    @Test(dependsOnMethods={"requestParameterMethodES384X509CertStep1"})
    public void requestParameterMethodES384X509CertStep2(String authorizePath, String userId, String userSecret, String redirectUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret) throws Exception {
        Invocation.Builder request = null;
        try {
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
            List<String> scopes = Arrays.asList("openid");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId5, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            authorizationRequest.getPrompts().add(Prompt.NONE);
            authorizationRequest.setAuthUsername(userId);
            authorizationRequest.setAuthPassword(userSecret);
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.ES384, (AbstractCryptoProvider)cryptoProvider);
            jwtAuthorizationRequest.setKeyId(keyId);
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{ACR_VALUE})));
            String authJwt = jwtAuthorizationRequest.getEncodedJwt();
            authorizationRequest.setRequest(authJwt);
            System.out.println("Request JWT: " + authJwt);
            request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
            request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
            request.header("Accept", (Object)"text/plain");
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage(), (Throwable)ex);
        }
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        OpenIDRequestObjectWithESAlgEmbeddedTest.showResponse("requestParameterMethodES384X509CertStep2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        try {
            URI uri = new URI(response.getLocation().toString());
            Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
            Map params = QueryStringDecoder.decode((String)uri.getFragment());
            Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
            Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
            Assert.assertNotNull(params.get("state"), (String)"The state is null");
        }
        catch (URISyntaxException e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestParameterMethodES512X509CertStep1(String registerPath, String redirectUris, String jwkUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        String registerRequestContent = null;
        try {
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setJwksUri(jwkUri);
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.ES512);
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (JSONException e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
        Response response = request.post(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        OpenIDRequestObjectWithESAlgEmbeddedTest.showResponse("requestParameterMethodES512X509CertStep1", response, entity);
        ResponseAsserter responseAsserter = ResponseAsserter.of((int)response.getStatus(), (String)entity);
        responseAsserter.assertRegisterResponse();
        clientId6 = responseAsserter.getJson().getJson().getString(RegisterResponseParam.CLIENT_ID.toString());
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri", "ES512_keyId", "dnName", "keyStoreFile", "keyStoreSecret"})
    @Test(dependsOnMethods={"requestParameterMethodES512X509CertStep1"})
    public void requestParameterMethodES512X509CertStep2(String authorizePath, String userId, String userSecret, String redirectUri, String keyId, String dnName, String keyStoreFile, String keyStoreSecret) throws Exception {
        Invocation.Builder request = null;
        try {
            OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider(keyStoreFile, keyStoreSecret, dnName);
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
            List<String> scopes = Arrays.asList("openid");
            String nonce = UUID.randomUUID().toString();
            String state = UUID.randomUUID().toString();
            AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId6, scopes, redirectUri, nonce);
            authorizationRequest.setState(state);
            authorizationRequest.getPrompts().add(Prompt.NONE);
            authorizationRequest.setAuthUsername(userId);
            authorizationRequest.setAuthPassword(userSecret);
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.ES512, (AbstractCryptoProvider)cryptoProvider);
            jwtAuthorizationRequest.setKeyId(keyId);
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{ACR_VALUE})));
            String authJwt = jwtAuthorizationRequest.getEncodedJwt();
            authorizationRequest.setRequest(authJwt);
            System.out.println("Request JWT: " + authJwt);
            request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
            request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
            request.header("Accept", (Object)"text/plain");
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage(), (Throwable)ex);
        }
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        OpenIDRequestObjectWithESAlgEmbeddedTest.showResponse("requestParameterMethodES512X509CertStep2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        try {
            URI uri = new URI(response.getLocation().toString());
            Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
            Map params = QueryStringDecoder.decode((String)uri.getFragment());
            Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
            Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
            Assert.assertNotNull(params.get("state"), (String)"The state is null");
        }
        catch (URISyntaxException e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }
}

