/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.ws.rs;

import java.net.URI;
import java.util.Arrays;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.BaseTest;
import org.gluu.oxauth.model.jwt.JwtClaims;
import org.gluu.oxauth.model.util.Base64Util;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.python.core.util.StringUtil;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class JwkRestWebServiceEmbeddedTest
extends BaseTest {
    @ArquillianResource
    private URI url;

    @Parameters(value={"jwksPath"})
    @Test
    public void requestJwks(String jwksPath) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + jwksPath).request();
        request.header("Accept", (Object)"application/json");
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        JwkRestWebServiceEmbeddedTest.showResponse("requestJwks", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("keys"), (String)"Unexpected result: keys not found");
            JSONArray keys = jsonObj.getJSONArray("keys");
            Assert.assertNotNull((Object)keys, (String)"Unexpected result: keys is null");
            Assert.assertTrue((keys.length() > 0 ? 1 : 0) != 0, (String)"Unexpected result: keys is empty");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void setClaimTestJsonObj() {
        try {
            String stringJson = StringUtil.fromBytes((byte[])Base64Util.base64urldecode((String)"eyJzYWx0IjoibWFjbmgiLCJwcm92aWRlciI6ImlkcDEifQ=="));
            JSONObject jobj = new JSONObject(stringJson);
            JwtClaims claims = new JwtClaims();
            claims.setClaim("test_claim", jobj);
            Assert.assertEquals((Object)jobj, (Object)claims.toJsonObject().get("test_claim"));
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void setClaimTestInt() {
        try {
            JwtClaims claims = new JwtClaims();
            claims.setClaim("test_claim", Integer.valueOf(123));
            Assert.assertEquals((String)"{\"test_claim\":123}", (String)claims.toJsonObject().toString());
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void setClaimTestIntList() {
        try {
            JwtClaims claims = new JwtClaims();
            claims.setClaim("test_claim", Arrays.asList(123, 456, 789));
            Assert.assertEquals((String)"{\"test_claim\":[123,456,789]}", (String)claims.toJsonObject().toString());
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void setClaimTestStringList() {
        try {
            JwtClaims claims = new JwtClaims();
            claims.setClaim("test_claim", Arrays.asList("qwe", "asd", "zxc"));
            Assert.assertEquals((String)"{\"test_claim\":[\"qwe\",\"asd\",\"zxc\"]}", (String)claims.toJsonObject().toString());
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
    }
}

