/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.ws.rs;

import java.net.URI;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.BaseTest;
import org.gluu.oxauth.model.common.IntrospectionResponse;
import org.gluu.oxauth.model.uma.TUma;
import org.gluu.oxauth.model.uma.UmaTestUtil;
import org.gluu.oxauth.model.uma.wrapper.Token;
import org.gluu.oxauth.util.ServerUtil;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class IntrospectionWebServiceEmbeddedTest
extends BaseTest {
    @ArquillianResource
    private URI url;
    private static Token authorization;
    private static Token tokenToIntrospect;

    @Test
    @Parameters(value={"authorizePath", "tokenPath", "umaUserId", "umaUserSecret", "umaPatClientId", "umaPatClientSecret", "umaRedirectUri"})
    public void requestAuthorization(String authorizePath, String tokenPath, String umaUserId, String umaUserSecret, String umaPatClientId, String umaPatClientSecret, String umaRedirectUri) {
        authorization = TUma.requestPat(this.url, authorizePath, tokenPath, umaUserId, umaUserSecret, umaPatClientId, umaPatClientSecret, umaRedirectUri);
        UmaTestUtil.assert_((Token)authorization);
    }

    @Test(dependsOnMethods={"requestAuthorization"})
    @Parameters(value={"authorizePath", "tokenPath", "umaUserId", "umaUserSecret", "umaPatClientId", "umaPatClientSecret", "umaRedirectUri"})
    public void requestTokenToIntrospect(String authorizePath, String tokenPath, String umaUserId, String umaUserSecret, String umaPatClientId, String umaPatClientSecret, String umaRedirectUri) {
        tokenToIntrospect = TUma.requestPat(this.url, authorizePath, tokenPath, umaUserId, umaUserSecret, umaPatClientId, umaPatClientSecret, umaRedirectUri);
        UmaTestUtil.assert_((Token)tokenToIntrospect);
    }

    @Test(dependsOnMethods={"requestTokenToIntrospect"})
    @Parameters(value={"introspectionPath"})
    public void introspection(String introspectionPath) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + introspectionPath).request();
        request.header("Accept", (Object)"application/json");
        request.header("Authorization", (Object)("Bearer " + authorization.getAccessToken()));
        Response response = request.post(Entity.form((Form)new Form("token", tokenToIntrospect.getAccessToken())));
        String entity = (String)response.readEntity(String.class);
        IntrospectionWebServiceEmbeddedTest.showResponse("introspection", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200);
        try {
            IntrospectionResponse t = (IntrospectionResponse)ServerUtil.createJsonMapper().readValue(entity, IntrospectionResponse.class);
            Assert.assertTrue((t != null && t.isActive() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

