/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.ws.rs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.BaseTest;
import org.gluu.oxauth.client.AuthorizationRequest;
import org.gluu.oxauth.client.ClientInfoRequest;
import org.gluu.oxauth.client.QueryStringDecoder;
import org.gluu.oxauth.client.RegisterRequest;
import org.gluu.oxauth.client.RegisterResponse;
import org.gluu.oxauth.client.TokenRequest;
import org.gluu.oxauth.model.common.AuthorizationMethod;
import org.gluu.oxauth.model.common.GrantType;
import org.gluu.oxauth.model.common.Prompt;
import org.gluu.oxauth.model.common.ResponseType;
import org.gluu.oxauth.model.register.ApplicationType;
import org.gluu.oxauth.model.util.StringUtils;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.oxauth.ws.rs.ClientTestUtil;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class ClientInfoRestWebServiceEmbeddedTest
extends BaseTest {
    @ArquillianResource
    private URI url;
    private static String clientId;
    private static String clientSecret;
    private static String accessToken1;
    private static String accessToken2;
    private static String accessToken3;

    @Parameters(value={"registerPath", "redirectUris"})
    @Test
    public void dynamicClientRegistration(String registerPath, String redirectUris) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        String registerRequestContent = null;
        try {
            List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setResponseTypes(responseTypes);
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
            registerRequest.setGrantTypes(grantTypes);
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Response response = request.post(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        ClientInfoRestWebServiceEmbeddedTest.showResponse("dynamicClientRegistration", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            RegisterResponse registerResponse = RegisterResponse.valueOf((String)entity);
            ClientTestUtil.assert_((RegisterResponse)registerResponse);
            clientId = registerResponse.getClientId();
            clientSecret = registerResponse.getClientSecret();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"dynamicClientRegistration"})
    public void requestClientInfoStep1ImplicitFlow(String authorizePath, String userId, String userSecret, String redirectUri) throws Exception {
        String state = UUID.randomUUID().toString();
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
        List<String> scopes = Arrays.asList("clientinfo");
        String nonce = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
        request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
        request.header("Accept", (Object)"text/plain");
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        ClientInfoRestWebServiceEmbeddedTest.showResponse("requestClientInfo step 1 Implicit Flow", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        if (response.getLocation() != null) {
            try {
                URI uri = new URI(response.getLocation().toString());
                Assert.assertNotNull((Object)uri.getFragment(), (String)"Fragment is null");
                Map params = QueryStringDecoder.decode((String)uri.getFragment());
                Assert.assertNotNull(params.get("access_token"), (String)"The access token is null");
                Assert.assertNotNull(params.get("state"), (String)"The state is null");
                Assert.assertNotNull(params.get("token_type"), (String)"The token type is null");
                Assert.assertNotNull(params.get("expires_in"), (String)"The expires in value is null");
                Assert.assertNotNull(params.get("scope"), (String)"The scope must be null");
                Assert.assertNull(params.get("refresh_token"), (String)"The refresh_token must be null");
                Assert.assertEquals((String)((String)params.get("state")), (String)state);
                accessToken1 = (String)params.get("access_token");
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                Assert.fail((String)"Response URI is not well formed");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"Unexpected error");
            }
        }
    }

    @Parameters(value={"clientInfoPath"})
    @Test(dependsOnMethods={"requestClientInfoStep1ImplicitFlow"})
    public void requestClientInfoStep2PostImplicitFlow(String clientInfoPath) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + clientInfoPath).request();
        request.header("Authorization", (Object)("Bearer " + accessToken1));
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        ClientInfoRequest clientInfoRequest = new ClientInfoRequest(null);
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(clientInfoRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        ClientInfoRestWebServiceEmbeddedTest.showResponse("requestClientInfo step 2 POST Implicit Flow", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store, private") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("displayName"), (String)"Unexpected result: displayName not found");
            Assert.assertTrue((boolean)jsonObj.has("inum"), (String)"Unexpected result: inum not found");
            Assert.assertTrue((boolean)jsonObj.has("oxAuthAppType"), (String)"Unexpected result: oxAuthAppType not found");
            Assert.assertTrue((boolean)jsonObj.has("oxAuthIdTokenSignedResponseAlg"), (String)"Unexpected result: oxAuthIdTokenSignedResponseAlg not found");
            Assert.assertTrue((boolean)jsonObj.has("oxAuthRedirectURI"), (String)"Unexpected result: oxAuthRedirectURI not found");
            Assert.assertTrue((boolean)jsonObj.has("oxAuthScope"), (String)"Unexpected result: oxAuthScope not found");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Parameters(value={"clientInfoPath"})
    @Test(dependsOnMethods={"requestClientInfoStep1ImplicitFlow"})
    public void requestClientInfoStep2GetImplicitFlow(String clientInfoPath) throws Exception {
        ClientInfoRequest clientInfoRequest = new ClientInfoRequest(null);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + clientInfoPath + "?" + clientInfoRequest.getQueryString()).request();
        request.header("Authorization", (Object)("Bearer " + accessToken1));
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        ClientInfoRestWebServiceEmbeddedTest.showResponse("requestClientInfo step 2 GET Implicit Flow", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store, private") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("displayName"), (String)"Unexpected result: displayName not found");
            Assert.assertTrue((boolean)jsonObj.has("inum"), (String)"Unexpected result: inum not found");
            Assert.assertTrue((boolean)jsonObj.has("oxAuthAppType"), (String)"Unexpected result: oxAuthAppType not found");
            Assert.assertTrue((boolean)jsonObj.has("oxAuthIdTokenSignedResponseAlg"), (String)"Unexpected result: oxAuthIdTokenSignedResponseAlg not found");
            Assert.assertTrue((boolean)jsonObj.has("oxAuthRedirectURI"), (String)"Unexpected result: oxAuthRedirectURI not found");
            Assert.assertTrue((boolean)jsonObj.has("oxAuthScope"), (String)"Unexpected result: oxAuthScope not found");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Parameters(value={"tokenPath", "userId", "userSecret"})
    @Test(dependsOnMethods={"dynamicClientRegistration"})
    public void requestClientInfoStep1PasswordFlow(String tokenPath, String userId, String userSecret) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + tokenPath).request();
        TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        tokenRequest.setUsername(userId);
        tokenRequest.setPassword(userSecret);
        tokenRequest.setScope("clientinfo");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        request.header("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(tokenRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        ClientInfoRestWebServiceEmbeddedTest.showResponse("requestClientInfoStep1PasswordFlow", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertTrue((!entity.equals(null) ? 1 : 0) != 0, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
            Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
            Assert.assertTrue((boolean)jsonObj.has("scope"), (String)"Unexpected result: scope not found");
            accessToken3 = jsonObj.getString("access_token");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"clientInfoPath"})
    @Test(dependsOnMethods={"requestClientInfoStep1PasswordFlow"})
    public void requestClientInfoStep2PasswordFlow(String clientInfoPath) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + clientInfoPath).request();
        request.header("Authorization", (Object)("Bearer " + accessToken3));
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        ClientInfoRequest clientInfoRequest = new ClientInfoRequest(null);
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(clientInfoRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        ClientInfoRestWebServiceEmbeddedTest.showResponse("requestUserInfoStep2PasswordFlow", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store, private") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("displayName"), (String)"Unexpected result: displayName not found");
            Assert.assertTrue((boolean)jsonObj.has("inum"), (String)"Unexpected result: inum not found");
            Assert.assertTrue((boolean)jsonObj.has("oxAuthAppType"), (String)"Unexpected result: oxAuthAppType not found");
            Assert.assertTrue((boolean)jsonObj.has("oxAuthIdTokenSignedResponseAlg"), (String)"Unexpected result: oxAuthIdTokenSignedResponseAlg not found");
            Assert.assertTrue((boolean)jsonObj.has("oxAuthRedirectURI"), (String)"Unexpected result: oxAuthRedirectURI not found");
            Assert.assertTrue((boolean)jsonObj.has("oxAuthScope"), (String)"Unexpected result: oxAuthScope not found");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Parameters(value={"clientInfoPath"})
    @Test
    public void requestClientInfoInvalidRequest(String clientInfoPath) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + clientInfoPath).request();
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        ClientInfoRequest clientInfoRequest = new ClientInfoRequest(null);
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(clientInfoRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        ClientInfoRestWebServiceEmbeddedTest.showResponse("requestClientInfoInvalidRequest", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)400, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("error"), (String)"The error type is null");
            Assert.assertTrue((boolean)jsonObj.has("error_description"), (String)"The error description is null");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"clientInfoPath"})
    @Test
    public void requestClientInfoInvalidToken(String clientInfoPath) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + clientInfoPath).request();
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        ClientInfoRequest clientInfoRequest = new ClientInfoRequest("INVALID-TOKEN");
        clientInfoRequest.setAuthorizationMethod(AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER);
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(clientInfoRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        ClientInfoRestWebServiceEmbeddedTest.showResponse("requestClientInfoInvalidToken", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)400, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("error"), (String)"The error type is null");
            Assert.assertTrue((boolean)jsonObj.has("error_description"), (String)"The error description is null");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }
}

