/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.uma.ws.rs;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.BaseTest;
import org.gluu.oxauth.model.uma.PermissionTicket;
import org.gluu.oxauth.model.uma.TUma;
import org.gluu.oxauth.model.uma.UmaPermission;
import org.gluu.oxauth.model.uma.UmaResourceResponse;
import org.gluu.oxauth.model.uma.UmaTestUtil;
import org.gluu.oxauth.model.uma.wrapper.Token;
import org.gluu.oxauth.util.ServerUtil;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class RegisterPermissionWSTest
extends BaseTest {
    @ArquillianResource
    private URI url;
    private static Token pat;
    private static UmaResourceResponse resource;
    private static String umaRegisterResourcePath;
    private static String umaPermissionPath;

    @Test
    @Parameters(value={"authorizePath", "tokenPath", "umaUserId", "umaUserSecret", "umaPatClientId", "umaPatClientSecret", "umaRedirectUri", "umaRegisterResourcePath", "umaPermissionPath"})
    public void init_(String authorizePath, String tokenPath, String umaUserId, String umaUserSecret, String umaPatClientId, String umaPatClientSecret, String umaRedirectUri, String umaRegisterResourcePath, String p_umaPermissionPath) {
        RegisterPermissionWSTest.umaRegisterResourcePath = umaRegisterResourcePath;
        umaPermissionPath = p_umaPermissionPath;
        pat = TUma.requestPat(this.url, authorizePath, tokenPath, umaUserId, umaUserSecret, umaPatClientId, umaPatClientSecret, umaRedirectUri);
        UmaTestUtil.assert_((Token)pat);
    }

    @Test(dependsOnMethods={"init_"})
    public void init() {
        resource = TUma.registerResource(this.url, pat, umaRegisterResourcePath, UmaTestUtil.createResource());
        UmaTestUtil.assert_((UmaResourceResponse)resource);
    }

    @Test(dependsOnMethods={"init"})
    public void testRegisterPermission() throws Exception {
        UmaPermission r = new UmaPermission();
        r.setResourceId(resource.getId());
        r.setScopes(Arrays.asList("http://photoz.example.com/dev/scopes/view"));
        PermissionTicket ticket = TUma.registerPermission(this.url, pat, r, umaPermissionPath);
        UmaTestUtil.assert_((PermissionTicket)ticket);
    }

    @Test(dependsOnMethods={"testRegisterPermission"})
    public void testRegisterPermissionWithInvalidResource() {
        String path = umaPermissionPath;
        try {
            Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + path).request();
            request.header("Accept", (Object)"application/json");
            request.header("Authorization", (Object)("Bearer " + pat.getAccessToken()));
            String json = null;
            try {
                UmaPermission r = new UmaPermission();
                r.setResourceId(resource.getId() + "x");
                json = ServerUtil.createJsonMapper().writeValueAsString((Object)r);
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail();
            }
            Response response = request.post(Entity.json(json));
            String entity = (String)response.readEntity(String.class);
            BaseTest.showResponse("UMA : RegisterPermissionWSTest.testRegisterPermissionWithInvalidResource() : ", response, entity);
            Assert.assertEquals((int)response.getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode(), (String)"Unexpected response code.");
            try {
                PermissionTicket t = (PermissionTicket)ServerUtil.createJsonMapper().readValue(entity, PermissionTicket.class);
                Assert.assertNull((Object)t);
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test(dependsOnMethods={"testRegisterPermissionWithInvalidResource"})
    public void cleanUp() {
        if (resource != null) {
            TUma.deleteResource(this.url, pat, umaRegisterResourcePath, resource.getId());
        }
    }
}

