/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.uma;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.BaseTest;
import org.gluu.oxauth.model.uma.TUma;
import org.gluu.oxauth.model.uma.UmaResource;
import org.gluu.oxauth.model.uma.UmaResourceResponse;
import org.gluu.oxauth.model.uma.UmaTestUtil;
import org.gluu.oxauth.model.uma.wrapper.Token;
import org.gluu.oxauth.util.ServerUtil;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.testng.Assert;

class TRegisterResource {
    private final URI baseUri;
    private UmaResourceResponse registerStatus;
    private UmaResourceResponse modifyStatus;

    public TRegisterResource(URI baseUri) {
        Assert.assertNotNull((Object)baseUri);
        this.baseUri = baseUri;
    }

    public UmaResourceResponse registerResource(Token pat, String umaRegisterResourcePath, UmaResource resource) {
        try {
            this.registerStatus = this.registerResourceInternal(pat, umaRegisterResourcePath, resource);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        UmaTestUtil.assert_((UmaResourceResponse)this.registerStatus);
        return this.registerStatus;
    }

    public UmaResourceResponse modifyResource(Token p_pat, String umaRegisterResourcePath, String p_rsId, UmaResource resource) {
        try {
            this.modifyStatus = this.modifyResourceInternal(p_pat, umaRegisterResourcePath, p_rsId, resource);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        UmaTestUtil.assert_((UmaResourceResponse)this.modifyStatus);
        return this.modifyStatus;
    }

    private UmaResourceResponse registerResourceInternal(Token pat, String umaRegisterResourcePath, UmaResource resource) throws Exception {
        String path = umaRegisterResourcePath;
        System.out.println("Path: " + path);
        System.out.println("PAT: " + pat.getAccessToken());
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.baseUri.toString() + path).request();
        request.header("Accept", (Object)"application/json");
        request.header("Authorization", (Object)("Bearer " + pat.getAccessToken()));
        String json = null;
        try {
            json = ServerUtil.createJsonMapper().writeValueAsString((Object)resource);
            System.out.println("Json: " + json);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        Response response = request.post(Entity.json((Object)json));
        String entity = (String)response.readEntity(String.class);
        BaseTest.showResponse("UMA : TRegisterResource.registerResourceInternal() : ", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.CREATED.getStatusCode(), (String)"Unexpected response code.");
        this.registerStatus = TUma.readJsonValue(entity, UmaResourceResponse.class);
        UmaTestUtil.assert_((UmaResourceResponse)this.registerStatus);
        return this.registerStatus;
    }

    private UmaResourceResponse modifyResourceInternal(Token p_pat, String umaRegisterResourcePath, String p_rsId, UmaResource resource) throws Exception {
        String path = umaRegisterResourcePath + "/" + p_rsId + "/";
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.baseUri.toString() + path).request();
        request.header("Accept", (Object)"application/json");
        request.header("Authorization", (Object)("Bearer " + p_pat.getAccessToken()));
        String json = null;
        try {
            json = ServerUtil.createJsonMapper().writeValueAsString((Object)resource);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        Response response = request.put(Entity.json((Object)json));
        String entity = (String)response.readEntity(String.class);
        BaseTest.showResponse("UMA : TRegisterResource.modifyResourceInternal() : ", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)"Unexpected response code.");
        this.modifyStatus = TUma.readJsonValue(entity, UmaResourceResponse.class);
        UmaTestUtil.assert_((UmaResourceResponse)this.modifyStatus);
        return this.modifyStatus;
    }

    public List<String> getResourceList(Token p_pat, String p_umaRegisterResourcePath) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.baseUri.toString() + p_umaRegisterResourcePath).request();
            request.header("Accept", (Object)"application/json");
            request.header("Authorization", (Object)("Bearer " + p_pat.getAccessToken()));
            Response response = request.get();
            String entity = (String)response.readEntity(String.class);
            BaseTest.showResponse("UMA : TRegisterResource.getResourceList() : ", response, entity);
            Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
            List list = TUma.readJsonValue(entity, List.class);
            if (list != null) {
                result.addAll(list);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        return result;
    }

    public void deleteResource(Token p_pat, String p_umaRegisterResourcePath, String p_id) {
        String path = p_umaRegisterResourcePath + "/" + p_id + "/";
        try {
            Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.baseUri.toString() + path).request();
            request.header("Authorization", (Object)("Bearer " + p_pat.getAccessToken()));
            Response response = request.delete();
            String entity = (String)response.readEntity(String.class);
            BaseTest.showResponse("UMA : TRegisterResource.deleteResource() : ", response, entity);
            Assert.assertEquals((int)response.getStatus(), (int)Response.Status.NO_CONTENT.getStatusCode(), (String)"Unexpected response code.");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

