/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.uma;

import java.io.IOException;
import java.net.URI;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.BaseTest;
import org.gluu.oxauth.model.uma.UmaMetadata;
import org.gluu.oxauth.model.uma.UmaTestUtil;
import org.gluu.oxauth.util.ServerUtil;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.testng.Assert;

class TConfiguration {
    private final URI baseUri;
    private UmaMetadata configuration = null;

    public TConfiguration(URI baseUri) {
        Assert.assertNotNull((Object)baseUri);
        this.baseUri = baseUri;
    }

    public UmaMetadata getConfiguration(String umaConfigurationPath) {
        if (this.configuration == null) {
            try {
                this.configuration(umaConfigurationPath);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail();
            }
        }
        UmaTestUtil.assert_((UmaMetadata)this.configuration);
        return this.configuration;
    }

    private void configuration(String umaConfigurationPath) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.baseUri.toString() + umaConfigurationPath).request();
        request.header("Accept", (Object)"application/json");
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        BaseTest.showResponse("UMA : TConfiguration.configuration", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        try {
            this.configuration = (UmaMetadata)ServerUtil.createJsonMapper().readValue(entity, UmaMetadata.class);
            UmaTestUtil.assert_((UmaMetadata)this.configuration);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

