/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.gluu.ws.rs;

import java.io.IOException;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.BaseTest;
import org.gluu.oxauth.model.gluu.GluuConfiguration;
import org.gluu.oxauth.util.ServerUtil;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.extension.rest.client.ArquillianResteasyResource;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.testng.Assert;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class GluuConfigurationWSTest
extends BaseTest {
    @ArquillianResource
    private URI url;

    @RunAsClient
    @Parameters(value={"gluuConfigurationPath", "webTarget"})
    @Consumes(value={"application/json"})
    @Test
    public void getConfigurationTest(String gluuConfigurationPath, @Optional @ArquillianResteasyResource(value="") WebTarget webTarget) throws Exception {
        Response response = webTarget.path(gluuConfigurationPath).request().get();
        String entity = (String)response.readEntity(String.class);
        BaseTest.showResponse("UMA : TConfiguration.configuration", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        try {
            GluuConfiguration appConfiguration = (GluuConfiguration)ServerUtil.createJsonMapper().readValue(entity, GluuConfiguration.class);
            System.err.println(appConfiguration.getIdGenerationEndpoint());
            Assert.assertNotNull((Object)appConfiguration, (String)"Meta data configuration is null");
            Assert.assertNotNull((Object)appConfiguration.getIdGenerationEndpoint());
            Assert.assertNotNull((Object)appConfiguration.getIntrospectionEndpoint());
            Assert.assertNotNull((Object)appConfiguration.getAuthLevelMapping());
            Assert.assertNotNull((Object)appConfiguration.getScopeToClaimsMapping());
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

