/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.dev;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.gluu.oxauth.model.config.BaseDnConfiguration;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.oxauth.model.error.ErrorMessage;
import org.gluu.oxauth.model.error.ErrorMessages;
import org.gluu.oxauth.model.jwk.JSONWebKeySet;
import org.gluu.oxauth.util.ServerUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConfSerialization {
    public static final String CONFIG_FOLDER = "U:\\own\\project\\oxAuth\\Server\\src\\main\\webapp\\WEB-INF\\";

    public static <T> T loadXml(String p_fileName, Class p_clazz) {
        URL url = ConfSerialization.class.getResource(p_fileName);
        try {
            System.out.println("Loading configuration file: " + url);
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{p_clazz});
            Unmarshaller u = jc.createUnmarshaller();
            return (T)u.unmarshal(url);
        }
        catch (JAXBException e) {
            System.out.println("Failed to get the configuration file: " + url);
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T loadJson(File p_file, Class p_clazz) {
        try {
            return (T)ServerUtil.createJsonMapper().readValue(p_file, p_clazz);
        }
        catch (Exception e) {
            System.out.println("Failed to load json from file: " + p_file.getPath());
            e.printStackTrace();
            return null;
        }
    }

    @Test
    public void errorXmlDeserializer() throws IOException {
        ErrorMessages objFromXml = (ErrorMessages)ConfSerialization.loadXml("oxauth-errors.xml", ConfSerialization.class);
        Assert.assertNotNull((Object)objFromXml);
        String jsonStr = ServerUtil.createJsonMapper().writeValueAsString((Object)objFromXml);
        System.out.println(jsonStr);
    }

    @Test
    public void errorJsonDeserializer() throws IOException {
        ErrorMessages object = (ErrorMessages)ConfSerialization.loadJson(new File("U:\\own\\project\\oxAuth\\Server\\src\\main\\webapp\\WEB-INF\\oxauth-errors.json"), ErrorMessages.class);
        Assert.assertTrue((object != null && ConfSerialization.notEmpty(object.getAuthorize()) && ConfSerialization.notEmpty(object.getUma()) && ConfSerialization.notEmpty(object.getUserInfo()) && ConfSerialization.notEmpty(object.getClientInfo()) && ConfSerialization.notEmpty(object.getToken()) && ConfSerialization.notEmpty(object.getEndSession()) ? 1 : 0) != 0);
    }

    @Test
    public void webKeysJsonDeserializer() throws IOException {
        JSONWebKeySet obj = (JSONWebKeySet)ConfSerialization.loadJson(new File("U:\\own\\project\\oxAuth\\Server\\src\\main\\webapp\\WEB-INF\\oxauth-web-keys.json"), JSONWebKeySet.class);
        Assert.assertTrue((obj != null && obj.getKeys() != null && !obj.getKeys().isEmpty() ? 1 : 0) != 0);
    }

    private static boolean notEmpty(List<ErrorMessage> p_list) {
        return p_list != null && !p_list.isEmpty();
    }

    @Test
    public void claims() throws IOException {
        BaseDnConfiguration baseDn = new BaseDnConfiguration();
        baseDn.setConfiguration("ou=configuration,o=gluu");
        baseDn.setPeople("ou=people,o=gluu");
        baseDn.setClients("ou=clients,o=gluu");
        baseDn.setScopes("ou=scopes,o=gluu");
        baseDn.setAttributes("ou=attributes,o=gluu");
        StaticConfiguration c = new StaticConfiguration();
        c.setBaseDn(baseDn);
        String jsonStr = ServerUtil.createJsonMapper().writeValueAsString((Object)c);
        System.out.println(jsonStr);
    }
}

