/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.comp;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.UUID;
import javax.inject.Inject;
import org.gluu.oxauth.BaseComponentTest;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.token.HandleTokenFactory;
import org.gluu.oxauth.model.uma.persistence.UmaResource;
import org.gluu.oxauth.service.ClientService;
import org.gluu.oxauth.service.common.InumService;
import org.gluu.oxauth.uma.service.UmaResourceService;
import org.gluu.util.security.StringEncrypter;
import org.junit.Assert;
import org.testng.annotations.Test;
import org.testng.collections.Lists;

public class UmaResourceServiceTest
extends BaseComponentTest {
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private ClientService clientService;
    @Inject
    private InumService inumService;
    @Inject
    private UmaResourceService umaResourceService;

    @Test
    public void umaResource_independentFromDeletableFlag_shouldBeSearchable() throws StringEncrypter.EncryptionException {
        Client client = this.createClient();
        this.clientService.persist(client);
        UmaResource resource = new UmaResource();
        resource.setName("Test resource");
        resource.setScopes(Lists.newArrayList((Object[])new String[]{"view"}));
        resource.setId(UUID.randomUUID().toString());
        resource.setDn(this.umaResourceService.getDnForResource(resource.getId()));
        resource.setDeletable(false);
        Calendar calendar = Calendar.getInstance();
        resource.setCreationDate(calendar.getTime());
        this.umaResourceService.addResource(resource);
        Assert.assertNotNull((Object)this.umaResourceService.getResourceById(resource.getId()));
        Assert.assertNotNull((Object)this.umaResourceService.getResourceById(resource.getId()));
        calendar.add(12, -10);
        resource.setExpirationDate(calendar.getTime());
        resource.setDeletable(true);
        this.umaResourceService.updateResource(resource, true);
        Assert.assertNotNull((Object)this.umaResourceService.getResourceById(resource.getId()));
        this.umaResourceService.remove(resource);
    }

    private Client createClient() throws StringEncrypter.EncryptionException {
        return this.createClient(true);
    }

    private Client createClient(boolean deletable) throws StringEncrypter.EncryptionException {
        String clientsBaseDN = this.staticConfiguration.getBaseDn().getClients();
        String inum = this.inumService.generateClientInum();
        String generatedClientSecret = UUID.randomUUID().toString();
        Client client = new Client();
        client.setDn("inum=" + inum + "," + clientsBaseDN);
        client.setClientName("Cleaner Timer Test");
        client.setClientId(inum);
        client.setClientSecret(this.clientService.encryptSecret(generatedClientSecret));
        client.setRegistrationAccessToken(HandleTokenFactory.generateHandleToken());
        client.setDeletable(Boolean.valueOf(deletable));
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        client.setClientIdIssuedAt(calendar.getTime());
        ((Calendar)calendar).add(12, 10);
        client.setExpirationDate(calendar.getTime());
        return client;
    }
}

