/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.comp;

import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.gluu.model.ProgrammingLanguage;
import org.gluu.model.custom.script.CustomScriptType;
import org.gluu.model.custom.script.model.CustomScript;
import org.gluu.oxauth.BaseComponentTest;
import org.gluu.oxauth.idgen.ws.rs.IdGenService;
import org.gluu.oxauth.model.config.ConfigurationFactory;
import org.gluu.oxauth.service.custom.CustomScriptService;
import org.gluu.persist.PersistenceEntryManager;
import org.testng.Assert;
import org.testng.annotations.Test;

public class IdGenServiceTest
extends BaseComponentTest {
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private CustomScriptService customScriptService;
    @Inject
    private IdGenService idGenService;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    private static String idCustomScriptDn;

    private CustomScript buildIdCustomScriptEntry(String idScript) {
        String customScriptId = UUID.randomUUID().toString();
        String dn = this.customScriptService.buildDn(customScriptId);
        CustomScript customScript = new CustomScript();
        customScript.setDn(dn);
        customScript.setInum(customScriptId);
        customScript.setProgrammingLanguage(ProgrammingLanguage.PYTHON);
        customScript.setScriptType(CustomScriptType.ID_GENERATOR);
        customScript.setScript(idScript);
        customScript.setName("test_id");
        customScript.setLevel(0);
        customScript.setEnabled(true);
        customScript.setRevision(1L);
        return customScript;
    }

    @Test
    public void loadCustomScript() {
        InputStream inputStream = IdGenServiceTest.class.getResourceAsStream("/id/gen/SampleIdGenerator.py");
        try {
            String idScript = IOUtils.toString((InputStream)inputStream);
            CustomScript idCustomScript = this.buildIdCustomScriptEntry(idScript);
            idCustomScriptDn = idCustomScript.getDn();
            this.ldapEntryManager.persist((Object)idCustomScript);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    @Test(dependsOnMethods={"loadCustomScript"})
    public void testCustomIdGenerationByPythonScript() {
        String uuid = this.idGenService.generateId("test", "");
        System.out.println("Generated Id: " + uuid);
        Assert.assertFalse((boolean)StringUtils.isNotBlank((String)uuid));
        String invalidUuid = this.idGenService.generateId("", "");
        System.out.println("Generated invalid Id: " + invalidUuid);
        Assert.assertFalse((boolean)StringUtils.equalsIgnoreCase((String)invalidUuid, (String)"invalid"));
    }

    @Test(dependsOnMethods={"testCustomIdGenerationByPythonScript"})
    public void removeCustomScript() {
        CustomScript customScript = new CustomScript();
        customScript.setDn(idCustomScriptDn);
        this.ldapEntryManager.remove((Object)customScript);
    }
}

