/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.comp;

import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.inject.Inject;
import org.gluu.oxauth.ConfigurableTest;
import org.gluu.oxauth.model.config.ConfigurationFactory;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.jwk.Algorithm;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CryptoProviderTest
extends ConfigurableTest {
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    private final String SIGNING_INPUT = "Signing Input";
    private final String SHARED_SECRET = "secret";
    private static Long expirationTime;
    private static String hs256Signature;
    private static String hs384Signature;
    private static String hs512Signature;
    private static String rs256Key;
    private static String rs256Signature;
    private static String rs384Key;
    private static String rs384Signature;
    private static String rs512Key;
    private static String rs512Signature;
    private static String es256Key;
    private static String es256Signature;
    private static String es384Key;
    private static String es384Signature;
    private static String es512Key;
    private static String es512Signature;

    @Test
    public void configuration() {
        try {
            AppConfiguration appConfiguration = this.configurationFactory.getAppConfiguration();
            Assert.assertNotNull((Object)appConfiguration);
            Assert.assertNotNull((Object)this.cryptoProvider);
            GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            calendar.add(12, 5);
            expirationTime = calendar.getTimeInMillis();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"configuration"})
    public void testSignHS256() {
        try {
            hs256Signature = this.cryptoProvider.sign("Signing Input", null, "secret", SignatureAlgorithm.HS256);
            Assert.assertNotNull((Object)hs256Signature);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"testSignHS256"})
    public void testVerifyHS256() {
        try {
            boolean signatureVerified = this.cryptoProvider.verifySignature("Signing Input", hs256Signature, null, null, "secret", SignatureAlgorithm.HS256);
            Assert.assertTrue((boolean)signatureVerified);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"configuration"})
    public void testSignHS384() {
        try {
            hs384Signature = this.cryptoProvider.sign("Signing Input", null, "secret", SignatureAlgorithm.HS384);
            Assert.assertNotNull((Object)hs384Signature);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"testSignHS384"})
    public void testVerifyHS384() {
        try {
            boolean signatureVerified = this.cryptoProvider.verifySignature("Signing Input", hs384Signature, null, null, "secret", SignatureAlgorithm.HS384);
            Assert.assertTrue((boolean)signatureVerified);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"configuration"})
    public void testSignHS512() {
        try {
            hs512Signature = this.cryptoProvider.sign("Signing Input", null, "secret", SignatureAlgorithm.HS512);
            Assert.assertNotNull((Object)hs512Signature);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"testSignHS512"})
    public void testVerifyHS512() {
        try {
            boolean signatureVerified = this.cryptoProvider.verifySignature("Signing Input", hs512Signature, null, null, "secret", SignatureAlgorithm.HS512);
            Assert.assertTrue((boolean)signatureVerified);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"configuration"})
    public void testGenerateKeyRS256() {
        try {
            JSONObject response = this.cryptoProvider.generateKey(Algorithm.RS256, expirationTime);
            rs256Key = response.optString("kid");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"testGenerateKeyRS256"})
    public void testSignRS256() {
        try {
            rs256Signature = this.cryptoProvider.sign("Signing Input", rs256Key, null, SignatureAlgorithm.RS256);
            Assert.assertNotNull((Object)rs256Signature);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"testSignRS256"})
    public void testVerifyRS256() {
        try {
            boolean signatureVerified = this.cryptoProvider.verifySignature("Signing Input", rs256Signature, rs256Key, null, null, SignatureAlgorithm.RS256);
            Assert.assertTrue((boolean)signatureVerified);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"testVerifyRS256"})
    public void testDeleteKeyRS256() {
        try {
            this.cryptoProvider.deleteKey(rs256Key);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"configuration"})
    public void testGenerateKeyRS384() {
        try {
            JSONObject response = this.cryptoProvider.generateKey(Algorithm.RS384, expirationTime);
            rs384Key = response.optString("kid");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"testGenerateKeyRS384"})
    public void testSignRS384() {
        try {
            rs384Signature = this.cryptoProvider.sign("Signing Input", rs384Key, null, SignatureAlgorithm.RS384);
            Assert.assertNotNull((Object)rs384Signature);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"testSignRS384"})
    public void testVerifyRS384() {
        try {
            boolean signatureVerified = this.cryptoProvider.verifySignature("Signing Input", rs384Signature, rs384Key, null, null, SignatureAlgorithm.RS384);
            Assert.assertTrue((boolean)signatureVerified);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"testVerifyRS384"})
    public void testDeleteKeyRS384() {
        try {
            this.cryptoProvider.deleteKey(rs384Key);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"configuration"})
    public void testGenerateKeyRS512() {
        try {
            JSONObject response = this.cryptoProvider.generateKey(Algorithm.RS512, expirationTime);
            rs512Key = response.optString("kid");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"testGenerateKeyRS512"})
    public void testSignRS512() {
        try {
            rs512Signature = this.cryptoProvider.sign("Signing Input", rs512Key, null, SignatureAlgorithm.RS512);
            Assert.assertNotNull((Object)rs512Signature);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"testSignRS512"})
    public void testVerifyRS512() {
        try {
            boolean signatureVerified = this.cryptoProvider.verifySignature("Signing Input", rs512Signature, rs512Key, null, null, SignatureAlgorithm.RS512);
            Assert.assertTrue((boolean)signatureVerified);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"testVerifyRS512"})
    public void testDeleteKeyRS512() {
        try {
            this.cryptoProvider.deleteKey(rs512Key);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"configuration"})
    public void testGenerateKeyES256() {
        try {
            JSONObject response = this.cryptoProvider.generateKey(Algorithm.ES256, expirationTime);
            es256Key = response.optString("kid");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"testGenerateKeyES256"})
    public void testSignES256() {
        try {
            es256Signature = this.cryptoProvider.sign("Signing Input", es256Key, null, SignatureAlgorithm.ES256);
            Assert.assertNotNull((Object)es256Signature);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"testSignES256"})
    public void testVerifyES256() {
        try {
            boolean signatureVerified = this.cryptoProvider.verifySignature("Signing Input", es256Signature, es256Key, null, null, SignatureAlgorithm.ES256);
            Assert.assertTrue((boolean)signatureVerified);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"testVerifyES256"})
    public void testDeleteKeyES256() {
        try {
            this.cryptoProvider.deleteKey(es256Key);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"configuration"})
    public void testGenerateKeyES384() {
        try {
            JSONObject response = this.cryptoProvider.generateKey(Algorithm.ES384, expirationTime);
            es384Key = response.optString("kid");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"testGenerateKeyES384"})
    public void testSignES384() {
        try {
            es384Signature = this.cryptoProvider.sign("Signing Input", es384Key, null, SignatureAlgorithm.ES384);
            Assert.assertNotNull((Object)es384Signature);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"testSignES384"})
    public void testVerifyES384() {
        try {
            boolean signatureVerified = this.cryptoProvider.verifySignature("Signing Input", es384Signature, es384Key, null, null, SignatureAlgorithm.ES384);
            Assert.assertTrue((boolean)signatureVerified);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"testVerifyES384"})
    public void testDeleteKeyES384() {
        try {
            this.cryptoProvider.deleteKey(es384Key);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"configuration"})
    public void testGenerateKeyES512() {
        try {
            JSONObject response = this.cryptoProvider.generateKey(Algorithm.ES512, expirationTime);
            es512Key = response.optString("kid");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"testGenerateKeyES512"})
    public void testSignES512() {
        try {
            es512Signature = this.cryptoProvider.sign("Signing Input", es512Key, null, SignatureAlgorithm.ES512);
            Assert.assertNotNull((Object)es512Signature);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"testSignES512"})
    public void testVerifyES512() {
        try {
            boolean signatureVerified = this.cryptoProvider.verifySignature("Signing Input", es512Signature, es512Key, null, null, SignatureAlgorithm.ES512);
            Assert.assertTrue((boolean)signatureVerified);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"testVerifyES512"})
    public void testDeleteKeyES512() {
        try {
            this.cryptoProvider.deleteKey(es512Key);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }
}

