/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.comp;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import org.gluu.oxauth.BaseComponentTest;
import org.gluu.oxauth.model.common.AccessToken;
import org.gluu.oxauth.model.common.AuthorizationGrantList;
import org.gluu.oxauth.model.common.ClientCredentialsGrant;
import org.gluu.oxauth.model.common.ExecutionContext;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.oxauth.model.fido.u2f.DeviceRegistration;
import org.gluu.oxauth.model.fido.u2f.DeviceRegistrationStatus;
import org.gluu.oxauth.model.fido.u2f.RequestMessageLdap;
import org.gluu.oxauth.model.ldap.TokenLdap;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.token.HandleTokenFactory;
import org.gluu.oxauth.model.uma.persistence.UmaPermission;
import org.gluu.oxauth.model.uma.persistence.UmaResource;
import org.gluu.oxauth.service.CleanerTimer;
import org.gluu.oxauth.service.ClientService;
import org.gluu.oxauth.service.GrantService;
import org.gluu.oxauth.service.common.InumService;
import org.gluu.oxauth.service.fido.u2f.DeviceRegistrationService;
import org.gluu.oxauth.service.fido.u2f.RegistrationService;
import org.gluu.oxauth.uma.authorization.UmaPCT;
import org.gluu.oxauth.uma.authorization.UmaRPT;
import org.gluu.oxauth.uma.service.UmaPctService;
import org.gluu.oxauth.uma.service.UmaPermissionService;
import org.gluu.oxauth.uma.service.UmaResourceService;
import org.gluu.oxauth.uma.service.UmaRptService;
import org.gluu.persist.exception.EntryPersistenceException;
import org.gluu.service.CacheService;
import org.gluu.util.security.StringEncrypter;
import org.junit.Assert;
import org.testng.annotations.Test;
import org.testng.collections.Lists;

public class CleanerTimerTest
extends BaseComponentTest {
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private ClientService clientService;
    @Inject
    private InumService inumService;
    @Inject
    private CleanerTimer cleanerTimer;
    @Inject
    private CacheService cacheService;
    @Inject
    private UmaRptService umaRptService;
    @Inject
    private UmaResourceService umaResourceService;
    @Inject
    private UmaPermissionService umaPermissionService;
    @Inject
    private UmaPctService umaPctService;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private GrantService grantService;
    @Inject
    private RegistrationService u2fRegistrationService;
    @Inject
    private DeviceRegistrationService deviceRegistrationService;

    @Test(enabled=false)
    public void client_whichIsExpiredAndDeletable_MustBeRemoved() throws StringEncrypter.EncryptionException {
        Client client = this.createClient(true);
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        client.setClientIdIssuedAt(calendar.getTime());
        ((Calendar)calendar).add(2, -1);
        client.setExpirationDate(calendar.getTime());
        this.clientService.persist(client);
        Assert.assertNotNull((Object)this.clientService.getClient(client.getClientId()));
        this.cleanerTimer.processImpl();
        this.cacheService.clear();
        org.testng.Assert.assertNull((Object)this.clientService.getClient(client.getClientId()));
    }

    @Test
    public void client_whichIsExpiredAndNotDeletable_MustNotBeRemoved() throws StringEncrypter.EncryptionException {
        Client client = this.createClient(false);
        try {
            GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            client.setClientIdIssuedAt(calendar.getTime());
            ((Calendar)calendar).add(10, -1);
            client.setExpirationDate(calendar.getTime());
            this.clientService.persist(client);
            Assert.assertNotNull((Object)this.clientService.getClient(client.getClientId()));
            this.cleanerTimer.processImpl();
            this.cacheService.clear();
            Assert.assertNotNull((Object)this.clientService.getClient(client.getClientId()));
        }
        finally {
            client.setDeletable(Boolean.valueOf(true));
            this.clientService.merge(client);
        }
    }

    @Test
    public void client_whichIsNotExpiredAndDeletable_MustNotBeRemoved() throws StringEncrypter.EncryptionException {
        Client client = this.createClient(true);
        this.clientService.persist(client);
        Assert.assertNotNull((Object)this.clientService.getClient(client.getClientId()));
        this.cleanerTimer.processImpl();
        this.cacheService.clear();
        Assert.assertNotNull((Object)this.clientService.getClient(client.getClientId()));
    }

    @Test
    public void u2fDevice_whichIsExpiredAndDeletable_MustBeRemoved() throws StringEncrypter.EncryptionException {
        Client client = this.createClient();
        this.clientService.persist(client);
        String userInum = "";
        String appId = "https://testapp.com";
        DeviceRegistration device = new DeviceRegistration();
        device.setStatus(DeviceRegistrationStatus.ACTIVE);
        device.setApplication(appId);
        device.setId(String.valueOf(System.currentTimeMillis()));
        device.setDn(this.deviceRegistrationService.getDnForU2fDevice(userInum, device.getId()));
        this.deviceRegistrationService.addOneStepDeviceRegistration(device);
        Assert.assertNotNull((Object)this.deviceRegistrationService.findUserDeviceRegistration(userInum, device.getId(), new String[0]));
        this.cleanerTimer.processImpl();
        this.cacheService.clear();
        Assert.assertNotNull((Object)this.deviceRegistrationService.findUserDeviceRegistration(userInum, device.getId(), new String[0]));
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, -10);
        device.setExpirationDate(calendar.getTime());
        this.deviceRegistrationService.merge(device);
        this.cleanerTimer.processImpl();
        this.cacheService.clear();
        try {
            this.deviceRegistrationService.findUserDeviceRegistration(userInum, device.getId(), new String[0]);
            throw new AssertionError((Object)"No exception, expected EntryPersistenceException on find.");
        }
        catch (EntryPersistenceException entryPersistenceException) {
            return;
        }
    }

    @Test
    public void u2fRequest_whichIsExpiredAndDeletable_MustBeRemoved() throws StringEncrypter.EncryptionException {
        Client client = this.createClient();
        this.clientService.persist(client);
        String userInum = "";
        String appId = "https://testapp.com";
        RequestMessageLdap request = this.u2fRegistrationService.storeRegisterRequestMessage(this.u2fRegistrationService.builRegisterRequestMessage(appId, userInum), userInum, userInum);
        Assert.assertNotNull((Object)this.u2fRegistrationService.getRegisterRequestMessage(request.getId()));
        this.cleanerTimer.processImpl();
        this.cacheService.clear();
        Assert.assertNotNull((Object)this.u2fRegistrationService.getRegisterRequestMessage(request.getId()));
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, -10);
        request.setExpirationDate(calendar.getTime());
        this.u2fRegistrationService.merge(request);
        this.cleanerTimer.processImpl();
        this.cacheService.clear();
        try {
            this.u2fRegistrationService.getRegisterRequestMessage(request.getId());
            throw new AssertionError((Object)"No exception, expected EntryPersistenceException on find request.");
        }
        catch (EntryPersistenceException entryPersistenceException) {
            return;
        }
    }

    @Test
    public void token_whichIsExpiredAndDeletable_MustBeRemoved() throws StringEncrypter.EncryptionException {
        Client client = this.createClient();
        this.clientService.persist(client);
        ClientCredentialsGrant grant = this.authorizationGrantList.createClientCredentialsGrant(new User(), client);
        AccessToken accessToken = grant.createAccessToken(null, new ExecutionContext(null, null));
        Assert.assertNotNull((Object)this.grantService.getGrantByCode(accessToken.getCode()));
        this.cleanerTimer.processImpl();
        this.cacheService.clear();
        TokenLdap grantLdap = this.grantService.getGrantByCode(accessToken.getCode());
        Assert.assertNotNull((Object)grantLdap);
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, -10);
        grantLdap.setExpirationDate(calendar.getTime());
        this.grantService.merge(grantLdap);
        this.cleanerTimer.processImpl();
        this.cacheService.clear();
        org.testng.Assert.assertNull((Object)this.grantService.getGrantByCode(accessToken.getCode()));
    }

    @Test
    public void umaRpt_whichIsExpiredAndDeletable_MustBeRemoved() throws StringEncrypter.EncryptionException {
        Client client = this.createClient();
        this.clientService.persist(client);
        ExecutionContext executionContext = new ExecutionContext(null, null);
        executionContext.setClient(client);
        UmaRPT rpt = this.umaRptService.createRPTAndPersist(executionContext, Lists.newArrayList());
        Assert.assertNotNull((Object)this.umaRptService.getRPTByCode(rpt.getNotHashedCode()));
        this.cleanerTimer.processImpl();
        this.cacheService.clear();
        Assert.assertNotNull((Object)this.umaRptService.getRPTByCode(rpt.getNotHashedCode()));
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        ((Calendar)calendar).add(12, -10);
        rpt.setExpirationDate(calendar.getTime());
        this.umaRptService.merge(rpt);
        this.cleanerTimer.processImpl();
        this.cacheService.clear();
        org.testng.Assert.assertNull((Object)this.umaRptService.getRPTByCode(rpt.getNotHashedCode()));
    }

    @Test
    public void umaResource_whichIsExpiredAndDeletable_MustBeRemoved() throws StringEncrypter.EncryptionException {
        Client client = this.createClient();
        this.clientService.persist(client);
        UmaResource resource = new UmaResource();
        resource.setName("Test resource");
        resource.setScopes(Lists.newArrayList((Object[])new String[]{"view"}));
        resource.setId(UUID.randomUUID().toString());
        resource.setDn(this.umaResourceService.getDnForResource(resource.getId()));
        Calendar calendar = Calendar.getInstance();
        resource.setCreationDate(calendar.getTime());
        this.umaResourceService.addResource(resource);
        Assert.assertNotNull((Object)this.umaResourceService.getResourceById(resource.getId()));
        this.cleanerTimer.processImpl();
        this.cacheService.clear();
        Assert.assertNotNull((Object)this.umaResourceService.getResourceById(resource.getId()));
        calendar.add(12, -10);
        resource.setExpirationDate(calendar.getTime());
        this.umaResourceService.updateResource(resource, true);
        this.cleanerTimer.processImpl();
        this.cacheService.clear();
        try {
            this.umaResourceService.getResourceById(resource.getId());
            throw new AssertionError((Object)"Test failed, no 404 exception");
        }
        catch (WebApplicationException e) {
            org.testng.Assert.assertEquals((int)404, (int)e.getResponse().getStatus());
            return;
        }
    }

    @Test
    public void umaPermission_whichIsExpiredAndDeletable_MustBeRemoved() throws StringEncrypter.EncryptionException {
        Client client = this.createClient();
        this.clientService.persist(client);
        String ticket = UUID.randomUUID().toString();
        UmaPermission permission = new UmaPermission();
        permission.setTicket(ticket);
        permission.setConfigurationCode(UUID.randomUUID().toString());
        permission.setResourceId(UUID.randomUUID().toString());
        this.umaPermissionService.addPermission(permission, client.getDn());
        Assert.assertNotNull(this.umaPermissionService.getPermissionsByTicket(ticket).get(0));
        this.cleanerTimer.processImpl();
        this.cacheService.clear();
        Assert.assertNotNull(this.umaPermissionService.getPermissionsByTicket(ticket).get(0));
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, -10);
        permission.setExpirationDate(calendar.getTime());
        this.umaPermissionService.merge(permission);
        this.cleanerTimer.processImpl();
        this.cacheService.clear();
        List permissionsByTicket = this.umaPermissionService.getPermissionsByTicket(ticket);
        org.testng.Assert.assertTrue((boolean)permissionsByTicket.isEmpty());
    }

    @Test
    public void umaPct_whichIsExpiredAndDeletable_MustBeRemoved() throws StringEncrypter.EncryptionException {
        Client client = this.createClient();
        this.clientService.persist(client);
        UmaPCT pct = this.umaPctService.createPct(client.getClientId());
        this.umaPctService.persist(pct);
        Assert.assertNotNull((Object)this.umaPctService.getByCode(pct.getCode()));
        this.cleanerTimer.processImpl();
        this.cacheService.clear();
        Assert.assertNotNull((Object)this.umaPctService.getByCode(pct.getCode()));
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, -10);
        pct.setExpirationDate(calendar.getTime());
        this.umaPctService.merge(pct);
        this.cleanerTimer.processImpl();
        this.cacheService.clear();
        org.testng.Assert.assertNull((Object)this.umaPctService.getByCode(pct.getCode()));
    }

    private Client createClient() throws StringEncrypter.EncryptionException {
        return this.createClient(true);
    }

    private Client createClient(boolean deletable) throws StringEncrypter.EncryptionException {
        String clientsBaseDN = this.staticConfiguration.getBaseDn().getClients();
        String inum = this.inumService.generateClientInum();
        String generatedClientSecret = UUID.randomUUID().toString();
        Client client = new Client();
        client.setDn("inum=" + inum + "," + clientsBaseDN);
        client.setClientName("Cleaner Timer Test");
        client.setClientId(inum);
        client.setClientSecret(this.clientService.encryptSecret(generatedClientSecret));
        client.setRegistrationAccessToken(HandleTokenFactory.generateHandleToken());
        client.setDeletable(Boolean.valueOf(deletable));
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        client.setClientIdIssuedAt(calendar.getTime());
        ((Calendar)calendar).add(12, 10);
        client.setExpirationDate(calendar.getTime());
        return client;
    }
}

