/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.uma.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.common.ScopeType;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.uma.UmaErrorResponseType;
import org.gluu.oxauth.service.SpontaneousScopeService;
import org.gluu.oxauth.service.common.InumService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.search.filter.Filter;
import org.oxauth.persistence.model.Scope;
import org.slf4j.Logger;

@Stateless
@Named(value="umaScopeService")
public class UmaScopeService {
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private InumService inumService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private SpontaneousScopeService spontaneousScopeService;

    public Scope getOrCreate(Client client, String scopeId, Set<String> regExps) {
        Scope fromLdap = this.getScope(scopeId);
        if (fromLdap != null) {
            return fromLdap;
        }
        if (!client.getAttributes().getAllowSpontaneousScopes().booleanValue()) {
            return null;
        }
        if (!this.spontaneousScopeService.isAllowedBySpontaneousScopes_(regExps, scopeId)) {
            return null;
        }
        return this.spontaneousScopeService.createSpontaneousScopeIfNeeded(regExps, scopeId, client.getClientId());
    }

    public Scope getScope(String scopeId) {
        try {
            Filter filter = Filter.createEqualityFilter((String)"oxId", (Object)scopeId);
            List entries = this.ldapEntryManager.findEntries(this.baseDn(), Scope.class, filter);
            if (entries != null && !entries.isEmpty()) {
                if (entries.size() > 1) {
                    this.log.error("Found more then one UMA scope, id: {}", (Object)scopeId);
                    for (Scope s : entries) {
                        this.log.error("Scope, Id: {}, dn: {}", (Object)s.getId(), (Object)s.getDn());
                    }
                }
                return (Scope)entries.get(0);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public boolean persist(Scope scope) {
        try {
            if (StringUtils.isBlank((String)scope.getDn())) {
                scope.setDn(String.format("inum=%s,%s", scope.getInum(), this.baseDn()));
            }
            this.ldapEntryManager.persist((Object)scope);
            return true;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public List<String> getScopeDNsByIdsAndAddToLdapIfNeeded(List<String> scopeIds) {
        ArrayList<String> result = new ArrayList<String>();
        for (Scope scope : this.getScopesByIds(scopeIds)) {
            result.add(scope.getDn());
        }
        return result;
    }

    public List<Scope> getScopesByDns(List<String> scopeDns) {
        ArrayList<Scope> result = new ArrayList<Scope>();
        try {
            if (scopeDns != null && !scopeDns.isEmpty()) {
                for (String dn : scopeDns) {
                    Scope scopeDescription = (Scope)this.ldapEntryManager.find(Scope.class, (Object)dn);
                    if (scopeDescription != null) {
                        result.add(scopeDescription);
                        continue;
                    }
                    this.log.error("Failed to load UMA scope with dn: {}", (Object)dn);
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public List<String> getScopeIdsByDns(List<String> scopeDns) {
        return this.getScopeIds(this.getScopesByDns(scopeDns));
    }

    public List<String> getScopeIds(List<Scope> scopes) {
        ArrayList<String> result = new ArrayList<String>();
        if (scopes != null && !scopes.isEmpty()) {
            for (Scope scope : scopes) {
                result.add(scope.getId());
            }
        }
        return result;
    }

    public List<Scope> getScopesByIds(List<String> scopeIds) {
        ArrayList<Scope> result = new ArrayList<Scope>();
        if (scopeIds != null && !scopeIds.isEmpty()) {
            ArrayList<String> notInLdap = new ArrayList<String>(scopeIds);
            List entries = this.ldapEntryManager.findEntries(this.baseDn(), Scope.class, this.createAnyFilterByIds(scopeIds));
            if (entries != null) {
                result.addAll(entries);
                for (Scope scope : entries) {
                    notInLdap.remove(scope.getId());
                }
            }
            if (!notInLdap.isEmpty()) {
                for (String scopeId : notInLdap) {
                    result.add(this.addScope(scopeId));
                }
            }
        }
        return result;
    }

    private Scope addScope(String scopeId) {
        Boolean addAutomatically = this.appConfiguration.getUmaAddScopesAutomatically();
        if (addAutomatically != null && addAutomatically.booleanValue()) {
            String inum = this.inumService.generateInum();
            Scope newScope = new Scope();
            newScope.setScopeType(ScopeType.UMA);
            newScope.setInum(inum);
            newScope.setDisplayName(scopeId);
            newScope.setId(scopeId);
            newScope.setDeletable(Boolean.valueOf(false));
            boolean persisted = this.persist(newScope);
            if (persisted) {
                return newScope;
            }
            this.log.error("Failed to persist scope, id:{}" + scopeId);
        }
        throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_SCOPE, "Failed to persist scope.");
    }

    private Filter createAnyFilterByIds(List<String> scopeIds) {
        if (scopeIds != null && !scopeIds.isEmpty()) {
            ArrayList<Filter> filters = new ArrayList<Filter>();
            for (String url : scopeIds) {
                Filter filter = Filter.createEqualityFilter((String)"oxId", (Object)url);
                filters.add(filter);
            }
            Filter filter = Filter.createORFilter((Filter[])filters.toArray(new Filter[0]));
            this.log.trace("Uma scope ids: " + scopeIds + ", ldapFilter: " + filter);
            return filter;
        }
        return null;
    }

    public String baseDn() {
        return this.staticConfiguration.getBaseDn().getScopes();
    }

    public static String asString(Collection<Scope> scopes) {
        String result = "";
        for (Scope scope : scopes) {
            result = result + scope.getId() + " ";
        }
        return result.trim();
    }
}

