/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.uma.service;

import java.util.List;
import java.util.UUID;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.jwt.Jwt;
import org.gluu.oxauth.model.jwt.JwtClaims;
import org.gluu.oxauth.model.uma.persistence.UmaPermission;
import org.gluu.oxauth.uma.authorization.UmaPCT;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.model.base.SimpleBranch;
import org.gluu.search.filter.Filter;
import org.gluu.util.INumGenerator;
import org.slf4j.Logger;

@Stateless
@Named
public class UmaPctService {
    public static final int DEFAULT_PCT_LIFETIME = 2592000;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private AppConfiguration appConfiguration;

    public UmaPCT updateClaims(UmaPCT pct, Jwt idToken, String clientId, List<UmaPermission> permissions) {
        try {
            boolean hasPct;
            String ticketPctCode = (String)permissions.get(0).getAttributes().get("pct");
            UmaPCT ticketPct = StringUtils.isNotBlank((String)ticketPctCode) ? this.getByCode(ticketPctCode) : null;
            boolean bl = hasPct = pct != null;
            if (!hasPct) {
                pct = ticketPct != null ? ticketPct : this.createPctAndPersist(clientId);
            }
            JwtClaims pctClaims = pct.getClaims();
            if (ticketPct != null && hasPct) {
                JwtClaims ticketClaims = ticketPct.getClaims();
                for (String key : ticketClaims.keys()) {
                    pctClaims.setClaimObject(key, ticketClaims.getClaim(key), false);
                }
                pct = ticketPct;
            }
            if (idToken != null && idToken.getClaims() != null) {
                for (String key : idToken.getClaims().keys()) {
                    pctClaims.setClaimObject(key, idToken.getClaims().getClaim(key), false);
                }
            }
            pct.setClaims(pctClaims);
            this.log.trace("PCT code: " + pct.getCode() + ", claims: " + pct.getClaimValuesAsJson());
            this.ldapEntryManager.merge((Object)pct);
            return (UmaPCT)this.ldapEntryManager.find(UmaPCT.class, (Object)pct.getDn());
        }
        catch (Exception e) {
            this.log.error("Failed to update PCT claims. " + e.getMessage(), (Throwable)e);
            return pct;
        }
    }

    public UmaPCT getByCode(String pctCode) {
        try {
            Filter filter = Filter.createEqualityFilter((String)"tknCde", (Object)pctCode);
            List entries = this.ldapEntryManager.findEntries(this.branchBaseDn(), UmaPCT.class, filter);
            if (entries != null && !entries.isEmpty()) {
                return (UmaPCT)entries.get(0);
            }
            this.log.error("Failed to find PCT by code: " + pctCode);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public UmaPCT createPct(String clientId) {
        String code = UUID.randomUUID().toString() + "_" + INumGenerator.generate((int)8);
        UmaPCT pct = new UmaPCT(this.pctLifetime());
        pct.setCode(code);
        pct.setDn(this.dn(pct.getCode()));
        pct.setClientId(clientId);
        return pct;
    }

    public UmaPCT createPctAndPersist(String clientId) {
        UmaPCT pct = this.createPct(clientId);
        this.persist(pct);
        return pct;
    }

    public int pctLifetime() {
        int lifeTime = this.appConfiguration.getUmaPctLifetime();
        if (lifeTime <= 0) {
            lifeTime = 2592000;
        }
        return lifeTime;
    }

    public void persist(UmaPCT pct) {
        try {
            this.prepareBranch();
            pct.setDn(this.dn(pct.getCode()));
            this.ldapEntryManager.persist((Object)pct);
        }
        catch (Exception e) {
            this.log.error("Failed to persist PCT, code: " + pct.getCode() + ". " + e.getMessage(), (Throwable)e);
        }
    }

    public void remove(UmaPCT umaPCT) {
        this.ldapEntryManager.remove((Object)umaPCT);
    }

    public void remove(String pctCode) {
        this.remove(this.getByCode(pctCode));
    }

    public void remove(List<UmaPCT> pctList) {
        for (UmaPCT pct : pctList) {
            this.remove(pct);
        }
    }

    private void prepareBranch() {
        if (!this.ldapEntryManager.hasBranchesSupport(this.branchBaseDn())) {
            return;
        }
        if (!this.ldapEntryManager.contains(this.branchBaseDn(), SimpleBranch.class)) {
            this.addBranch();
        }
    }

    public void addBranch() {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName("pct");
        branch.setDn(this.branchBaseDn());
        this.ldapEntryManager.persist((Object)branch);
    }

    public String dn(String pctCode) {
        if (StringUtils.isBlank((String)pctCode)) {
            throw new IllegalArgumentException("PCT code is null or blank.");
        }
        return String.format("tknCde=%s,%s", pctCode, this.branchBaseDn());
    }

    public String branchBaseDn() {
        String umaBaseDn = this.staticConfiguration.getBaseDn().getUmaBase();
        return String.format("ou=pct,%s", umaBaseDn);
    }

    public void merge(UmaPCT pct) {
        try {
            this.ldapEntryManager.merge((Object)pct);
        }
        catch (Exception e) {
            this.log.error("Failed to merge PCT, code: " + pct.getCode() + ". " + e.getMessage(), (Throwable)e);
        }
    }
}

