/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.uma.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.gluu.jsf2.service.FacesService;
import org.gluu.model.custom.script.conf.CustomScriptConfiguration;
import org.gluu.oxauth.i18n.LanguageBean;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.uma.persistence.UmaPermission;
import org.gluu.oxauth.service.common.UserService;
import org.gluu.oxauth.service.external.ExternalUmaClaimsGatheringService;
import org.gluu.oxauth.uma.authorization.UmaGatherContext;
import org.gluu.oxauth.uma.service.UmaPctService;
import org.gluu.oxauth.uma.service.UmaPermissionService;
import org.gluu.oxauth.uma.service.UmaSessionService;
import org.slf4j.Logger;

@RequestScoped
@Named(value="gatherer")
public class UmaGatherer {
    @Inject
    private Logger log;
    @Inject
    private ExternalUmaClaimsGatheringService external;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private FacesContext facesContext;
    @Inject
    private ExternalContext externalContext;
    @Inject
    private FacesService facesService;
    @Inject
    private LanguageBean languageBean;
    @Inject
    private UmaSessionService umaSessionService;
    @Inject
    private UmaPermissionService umaPermissionService;
    @Inject
    private UmaPctService umaPctService;
    @Inject
    private UserService userService;
    private final Map<String, String> pageClaims = new HashMap<String, String>();

    public boolean gather() {
        try {
            int stepsCount;
            HttpServletRequest httpRequest = (HttpServletRequest)this.externalContext.getRequest();
            HttpServletResponse httpResponse = (HttpServletResponse)this.externalContext.getResponse();
            SessionId session = this.umaSessionService.getSession(httpRequest, httpResponse);
            CustomScriptConfiguration script = this.getScript(session);
            UmaGatherContext context = new UmaGatherContext(script.getConfigurationAttributes(), httpRequest, session, this.umaSessionService, this.umaPermissionService, this.umaPctService, this.pageClaims, this.userService, this.facesService, this.appConfiguration);
            int step = this.umaSessionService.getStep(session);
            if (!this.umaSessionService.isPassedPreviousSteps(session, step)) {
                this.log.error("There are claims-gathering steps not marked as passed. scriptName: '{}', step: '{}'", (Object)script.getName(), (Object)step);
                return false;
            }
            boolean gatheredResult = this.external.gather(script, step, context);
            this.log.debug("Claims-gathering result for script '{}', step: '{}', gatheredResult: '{}'", new Object[]{script.getName(), step, gatheredResult});
            int overridenNextStep = this.external.getNextStep(script, step, context);
            if (!gatheredResult && overridenNextStep == -1) {
                return false;
            }
            if (overridenNextStep != -1) {
                this.umaSessionService.resetToStep(session, overridenNextStep, step);
                step = overridenNextStep;
            }
            if (step < (stepsCount = this.external.getStepsCount(script, context)) || overridenNextStep != -1) {
                int nextStep;
                if (overridenNextStep != -1) {
                    nextStep = overridenNextStep;
                } else {
                    nextStep = step + 1;
                    this.umaSessionService.markStep(session, step, true);
                }
                this.umaSessionService.setStep(nextStep, session);
                context.persist();
                String page = this.external.getPageForStep(script, nextStep, context);
                this.log.trace("Redirecting to page: '{}'", (Object)page);
                this.facesService.redirect(page);
                return true;
            }
            if (step == stepsCount) {
                context.persist();
                this.onSuccess(session, context);
                return true;
            }
        }
        catch (Exception e) {
            this.log.error("Exception during gather() method call.", (Throwable)e);
        }
        this.log.error("Failed to perform gather() method successfully.");
        return false;
    }

    private void onSuccess(SessionId session, UmaGatherContext context) {
        List<UmaPermission> permissions = context.getPermissions();
        String newTicket = this.umaPermissionService.changeTicket(permissions, permissions.get(0).getAttributes());
        String url = this.constructRedirectUri(session, context, newTicket);
        if (StringUtils.isNotBlank((String)url)) {
            this.facesService.redirectToExternalURL(url);
        } else {
            this.log.debug("Redirect to claims_redirect_uri is skipped because it was not provided during request.");
        }
    }

    private String constructRedirectUri(SessionId session, UmaGatherContext context, String newTicket) {
        String claimsRedirectUri = this.umaSessionService.getClaimsRedirectUri(session);
        if (StringUtils.isBlank((String)claimsRedirectUri)) {
            this.log.debug("claims_redirect_uri is blank, session: " + session);
            return "";
        }
        claimsRedirectUri = UmaGatherer.addQueryParameters(claimsRedirectUri, context.getRedirectUserParameters().buildQueryString().trim());
        claimsRedirectUri = UmaGatherer.addQueryParameter(claimsRedirectUri, "state", this.umaSessionService.getState(session));
        claimsRedirectUri = UmaGatherer.addQueryParameter(claimsRedirectUri, "ticket", newTicket);
        return claimsRedirectUri;
    }

    public static String addQueryParameters(String url, String parameters) {
        if (StringUtils.isNotBlank((String)parameters)) {
            url = url.contains("?") ? url + "&" + parameters : url + "?" + parameters;
        }
        return url;
    }

    public static String addQueryParameter(String url, String paramName, String paramValue) {
        if (StringUtils.isBlank((String)url)) {
            return "";
        }
        if (StringUtils.isNotBlank((String)paramValue)) {
            url = url.contains("?") ? url + "&" + paramName + "=" + paramValue : url + "?" + paramName + "=" + paramValue;
        }
        return url;
    }

    public String prepareForStep() {
        try {
            HttpServletRequest httpRequest = (HttpServletRequest)this.externalContext.getRequest();
            HttpServletResponse httpResponse = (HttpServletResponse)this.externalContext.getResponse();
            SessionId session = this.umaSessionService.getSession(httpRequest, httpResponse);
            if (session == null || session.getSessionAttributes().isEmpty()) {
                this.log.error("Invalid session.");
                return this.result("expired");
            }
            CustomScriptConfiguration script = this.getScript(session);
            UmaGatherContext context = new UmaGatherContext(script.getConfigurationAttributes(), httpRequest, session, this.umaSessionService, this.umaPermissionService, this.umaPctService, this.pageClaims, this.userService, this.facesService, this.appConfiguration);
            int step = this.umaSessionService.getStep(session);
            if (step < 1) {
                this.log.error("Invalid step: {}", (Object)step);
                return this.result("invalid_step");
            }
            if (script == null) {
                this.log.error("Failed to load script, step: '{}'", (Object)step);
                return this.result("failure");
            }
            if (!this.umaSessionService.isPassedPreviousSteps(session, step)) {
                this.log.error("There are claims-gathering steps not marked as passed. scriptName: '{}', step: '{}'", (Object)script.getName(), (Object)step);
                return this.result("failure");
            }
            boolean result = this.external.prepareForStep(script, step, context);
            if (result) {
                context.persist();
                return this.result("success");
            }
            String redirectToExternalUrl = context.getRedirectToExternalUrl();
            if (StringUtils.isNotBlank((String)redirectToExternalUrl)) {
                this.log.debug("Redirect to : " + redirectToExternalUrl);
                this.facesService.redirectToExternalURL(redirectToExternalUrl);
                return redirectToExternalUrl;
            }
        }
        catch (Exception e) {
            this.log.error("Failed to prepareForStep()", (Throwable)e);
        }
        return this.result("failure");
    }

    private void errorPage(String errorKey) {
        this.addMessage(FacesMessage.SEVERITY_ERROR, errorKey);
        this.facesService.redirect("/error.xhtml");
    }

    public String result(String resultCode) {
        if ("failure".equals(resultCode)) {
            this.addMessage(FacesMessage.SEVERITY_ERROR, "uma2.gather.failed");
        } else if ("invalid_step".equals(resultCode)) {
            this.addMessage(FacesMessage.SEVERITY_ERROR, "uma2.invalid.step");
        } else if ("expired".equals(resultCode)) {
            this.addMessage(FacesMessage.SEVERITY_ERROR, "uma2.invalid.session");
        }
        return resultCode;
    }

    public void addMessage(FacesMessage.Severity severity, String summary) {
        String msg = this.languageBean.getMessage(summary);
        FacesMessage message = new FacesMessage(severity, msg, null);
        this.facesContext.addMessage(null, message);
    }

    public Map<String, String> getPageClaims() {
        return this.pageClaims;
    }

    protected CustomScriptConfiguration getScript(SessionId session) {
        String scriptName = this.umaSessionService.getScriptName(session);
        CustomScriptConfiguration script = this.external.getCustomScriptConfigurationByName(scriptName);
        return script;
    }
}

