/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.util.Util;
import org.slf4j.Logger;

@WebServlet(urlPatterns={"/firebase-messaging-sw.js"})
public class BcFirebaseMessagingSwServlet
extends HttpServlet {
    private static final long serialVersionUID = 5445488800130871634L;
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/javascript");
        this.loadFirebaseMessagingSwFile(response);
    }

    private void loadFirebaseMessagingSwFile(HttpServletResponse response) {
        String baseJavascriptFileConfiguration = "/WEB-INF/firebase-messaging-sw.js";
        try (InputStream in = this.getServletContext().getResourceAsStream(baseJavascriptFileConfiguration);
             ServletOutputStream out = response.getOutputStream();){
            String content = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            HashMap<String, String> publicConfiguration = new HashMap<String, String>();
            publicConfiguration.put("apiKey", this.appConfiguration.getCibaEndUserNotificationConfig().getApiKey());
            publicConfiguration.put("authDomain", this.appConfiguration.getCibaEndUserNotificationConfig().getAuthDomain());
            publicConfiguration.put("databaseURL", this.appConfiguration.getCibaEndUserNotificationConfig().getDatabaseURL());
            publicConfiguration.put("projectId", this.appConfiguration.getCibaEndUserNotificationConfig().getProjectId());
            publicConfiguration.put("storageBucket", this.appConfiguration.getCibaEndUserNotificationConfig().getStorageBucket());
            publicConfiguration.put("messagingSenderId", this.appConfiguration.getCibaEndUserNotificationConfig().getMessagingSenderId());
            publicConfiguration.put("appId", this.appConfiguration.getCibaEndUserNotificationConfig().getAppId());
            content = content.replace("'${FIREBASE_CONFIG}'", Util.asJson(publicConfiguration));
            IOUtils.write((String)content, (OutputStream)out, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            this.log.debug("Error loading firebase-messaging-sw.js configuration file: " + e.getMessage());
        }
    }
}

