/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service.external;

import java.util.List;
import javax.ejb.DependsOn;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.model.custom.script.CustomScriptType;
import org.gluu.model.custom.script.conf.CustomScriptConfiguration;
import org.gluu.model.custom.script.type.uma.UmaRptClaimsType;
import org.gluu.oxauth.service.external.context.ExternalUmaRptClaimsContext;
import org.gluu.service.custom.script.ExternalScriptService;
import org.json.JSONObject;
import org.slf4j.Logger;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ExternalUmaRptClaimsService
extends ExternalScriptService {
    @Inject
    private Logger log;

    public ExternalUmaRptClaimsService() {
        super(CustomScriptType.UMA_RPT_CLAIMS);
    }

    public boolean externalModify(JSONObject rptAsJson, ExternalUmaRptClaimsContext context) {
        List scripts = this.getCustomScriptConfigurationsByDns(context.getClient().getAttributes().getRptClaimsScripts());
        if (scripts.isEmpty()) {
            return false;
        }
        this.log.trace("Found {} RPT Claims scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            if (this.externalModify(rptAsJson, script, context)) continue;
            return false;
        }
        this.log.debug("ExternalModify returned 'true'.");
        return true;
    }

    public boolean externalModify(JSONObject rptAsJson, CustomScriptConfiguration scriptConfiguration, ExternalUmaRptClaimsContext context) {
        try {
            this.log.trace("Executing external 'externalModify' method, script name: {}, context: {}", (Object)scriptConfiguration.getName(), (Object)context);
            UmaRptClaimsType script = (UmaRptClaimsType)scriptConfiguration.getExternalType();
            context.setScript(scriptConfiguration);
            boolean result = script.modify((Object)rptAsJson, (Object)context);
            this.log.trace("Finished external 'externalModify' method, script name: {}, context: {}, result: {}", new Object[]{scriptConfiguration.getName(), context, result});
            return result;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(scriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }
}

