/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service.external;

import javax.ejb.DependsOn;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.model.custom.script.CustomScriptType;
import org.gluu.model.custom.script.conf.CustomScriptConfiguration;
import org.gluu.model.custom.script.type.owner.ResourceOwnerPasswordCredentialsType;
import org.gluu.oxauth.service.external.context.ExternalResourceOwnerPasswordCredentialsContext;
import org.gluu.service.custom.script.ExternalScriptService;
import org.slf4j.Logger;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ExternalResourceOwnerPasswordCredentialsService
extends ExternalScriptService {
    private static final long serialVersionUID = -1070021905117551202L;
    @Inject
    private Logger log;

    public ExternalResourceOwnerPasswordCredentialsService() {
        super(CustomScriptType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
    }

    public boolean executeExternalAuthenticate(ExternalResourceOwnerPasswordCredentialsContext context) {
        if (this.customScriptConfigurations == null || this.customScriptConfigurations.isEmpty()) {
            this.log.debug("There is no any external interception scripts defined.");
            return false;
        }
        for (CustomScriptConfiguration script : this.customScriptConfigurations) {
            if (this.executeExternalAuthenticate(script, context)) continue;
            this.log.debug("Stopped running external RO PC scripts because script {} returns false.", (Object)script.getName());
            return false;
        }
        return true;
    }

    private boolean executeExternalAuthenticate(CustomScriptConfiguration customScriptConfiguration, ExternalResourceOwnerPasswordCredentialsContext context) {
        try {
            this.log.debug("Executing external 'executeExternalAuthenticate' method, script name: {}, context: {}", (Object)customScriptConfiguration.getName(), (Object)context);
            ResourceOwnerPasswordCredentialsType script = (ResourceOwnerPasswordCredentialsType)customScriptConfiguration.getExternalType();
            context.setScript(customScriptConfiguration);
            if (script == null) {
                this.log.error("Failed to load script, name: " + customScriptConfiguration.getName());
                return false;
            }
            boolean result = script.authenticate((Object)context);
            this.log.debug("Finished external 'executeExternalAuthenticate' method, script name: {}, context: {}, result: {}", new Object[]{customScriptConfiguration.getName(), context, result});
            return result;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }
}

