/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service.external;

import java.util.Map;
import javax.ejb.DependsOn;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.gluu.model.custom.script.CustomScriptType;
import org.gluu.model.custom.script.conf.CustomScriptConfiguration;
import org.gluu.model.custom.script.type.client.ClientRegistrationType;
import org.gluu.oxauth.client.RegisterRequest;
import org.gluu.oxauth.model.jwt.Jwt;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.service.external.context.DynamicClientRegistrationContext;
import org.gluu.service.custom.script.ExternalScriptService;
import org.json.JSONObject;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ExternalDynamicClientRegistrationService
extends ExternalScriptService {
    private static final long serialVersionUID = 1416361273036208686L;

    public ExternalDynamicClientRegistrationService() {
        super(CustomScriptType.CLIENT_REGISTRATION);
    }

    public boolean executeExternalCreateClientMethod(CustomScriptConfiguration customScriptConfiguration, RegisterRequest registerRequest, Client client) {
        try {
            this.log.trace("Executing python 'createClient' method");
            ClientRegistrationType externalClientRegistrationType = (ClientRegistrationType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return externalClientRegistrationType.createClient((Object)registerRequest, (Object)client, configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }

    public boolean executeExternalCreateClientMethods(RegisterRequest registerRequest, Client client) {
        boolean result = true;
        for (CustomScriptConfiguration customScriptConfiguration : this.customScriptConfigurations) {
            if (customScriptConfiguration.getExternalType().getApiVersion() <= 1 || (result &= this.executeExternalCreateClientMethod(customScriptConfiguration, registerRequest, client))) continue;
            return result;
        }
        return result;
    }

    public boolean executeExternalUpdateClientMethod(CustomScriptConfiguration customScriptConfiguration, RegisterRequest registerRequest, Client client) {
        try {
            this.log.trace("Executing python 'updateClient' method");
            ClientRegistrationType externalClientRegistrationType = (ClientRegistrationType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return externalClientRegistrationType.updateClient((Object)registerRequest, (Object)client, configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }

    public boolean executeExternalUpdateClientMethods(RegisterRequest registerRequest, Client client) {
        boolean result = true;
        for (CustomScriptConfiguration customScriptConfiguration : this.customScriptConfigurations) {
            if (result &= this.executeExternalUpdateClientMethod(customScriptConfiguration, registerRequest, client)) continue;
            return result;
        }
        return result;
    }

    public JSONObject getSoftwareStatementJwks(HttpServletRequest httpRequest, JSONObject registerRequest, Jwt softwareStatement) {
        try {
            this.log.trace("Executing python 'getSoftwareStatementJwks' method");
            DynamicClientRegistrationContext context = new DynamicClientRegistrationContext(httpRequest, registerRequest, this.defaultExternalCustomScript);
            context.setSoftwareStatement(softwareStatement);
            ClientRegistrationType externalType = (ClientRegistrationType)this.defaultExternalCustomScript.getExternalType();
            String result = externalType.getSoftwareStatementJwks((Object)context);
            this.log.trace("Result of python 'getSoftwareStatementJwks' method: " + result);
            return new JSONObject(result);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(this.defaultExternalCustomScript.getCustomScript(), ex);
            return null;
        }
    }

    public String getSoftwareStatementHmacSecret(HttpServletRequest httpRequest, JSONObject registerRequest, Jwt softwareStatement) {
        try {
            this.log.trace("Executing python 'getSoftwareStatementHmacSecret' method");
            DynamicClientRegistrationContext context = new DynamicClientRegistrationContext(httpRequest, registerRequest, this.defaultExternalCustomScript);
            context.setSoftwareStatement(softwareStatement);
            ClientRegistrationType externalType = (ClientRegistrationType)this.defaultExternalCustomScript.getExternalType();
            String result = externalType.getSoftwareStatementHmacSecret((Object)context);
            this.log.trace("Result of python 'getSoftwareStatementHmacSecret' method: " + result);
            return result;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(this.defaultExternalCustomScript.getCustomScript(), ex);
            return "";
        }
    }
}

