/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service.expiration;

import java.lang.annotation.Annotation;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import net.jodah.expiringmap.ExpirationListener;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.service.cdi.event.ExpirationEvent;
import org.gluu.oxauth.service.expiration.ExpId;
import org.gluu.oxauth.service.expiration.ExpType;
import org.gluu.oxauth.service.external.ExternalApplicationSessionService;
import org.gluu.oxauth.service.external.session.SessionEvent;
import org.gluu.oxauth.service.external.session.SessionEventType;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.search.filter.Filter;
import org.gluu.service.cdi.async.Asynchronous;
import org.gluu.service.cdi.event.Scheduled;
import org.gluu.service.timer.event.TimerEvent;
import org.gluu.service.timer.schedule.TimerSchedule;
import org.slf4j.Logger;

@ApplicationScoped
@Named
public class ExpirationNotificatorTimer
implements ExpirationListener<ExpId, Object> {
    private static final int DEFAULT_INTERVAL = 600;
    @Inject
    private Logger log;
    @Inject
    private Event<TimerEvent> timerEvent;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ExternalApplicationSessionService externalApplicationSessionService;
    private ExpiringMap<ExpId, Object> expiringMap = ExpiringMap.builder().expirationPolicy(ExpirationPolicy.CREATED).variableExpiration().build();
    private AtomicBoolean isActive;
    private long lastFinishedTime;

    public void initTimer() {
        this.log.debug("Initializing ExpirationNotificatorTimer");
        this.isActive = new AtomicBoolean(false);
        this.expiringMap = ExpiringMap.builder().expirationPolicy(ExpirationPolicy.CREATED).maxSize(this.appConfiguration.getExpirationNotificatorMapSizeLimit()).variableExpiration().build();
        this.expiringMap.addExpirationListener((ExpirationListener)this);
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(600, 600), (Object)new ExpirationEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
        this.lastFinishedTime = System.currentTimeMillis();
    }

    @Asynchronous
    public void process(@Observes @Scheduled ExpirationEvent expirationEvent) {
        if (!this.appConfiguration.getExpirationNotificatorEnabled().booleanValue()) {
            return;
        }
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            if (!this.allowToRun()) {
                this.log.trace("Not allowed to run.");
                return;
            }
            this.fillMap();
            this.lastFinishedTime = System.currentTimeMillis();
        }
        catch (Exception ex) {
            this.log.error("Exception happened while trying to fill expiringMap update", (Throwable)ex);
        }
        finally {
            this.isActive.set(false);
        }
    }

    private void fillMap() {
        Calendar future = Calendar.getInstance();
        future.add(13, this.appConfiguration.getExpirationNotificatorIntervalInSeconds());
        this.fillSessions(future.getTime());
    }

    private void fillSessions(Date future) {
        Filter filter;
        String baseDn = this.staticConfiguration.getBaseDn().getSessions();
        List sessions = this.persistenceEntryManager.findEntries(baseDn, SessionId.class, filter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"del", (Object)true), Filter.createLessOrEqualFilter((String)"exp", (Object)this.persistenceEntryManager.encodeTime(baseDn, future))}));
        if (sessions == null || sessions.isEmpty()) {
            return;
        }
        long now = new Date().getTime();
        for (SessionId session : sessions) {
            long duration = session.getExpirationDate().getTime() - now;
            if (duration <= 0L) {
                this.remove(session);
                continue;
            }
            this.expiringMap.put((Object)new ExpId(session.getId(), ExpType.SESSION), (Object)session, duration, TimeUnit.MILLISECONDS);
        }
    }

    public void expired(ExpId key, Object value) {
        if (key.getType() == ExpType.SESSION && value instanceof SessionId) {
            this.externalApplicationSessionService.externalEvent(new SessionEvent(SessionEventType.GONE, (SessionId)value));
        }
    }

    private boolean allowToRun() {
        int interval = this.appConfiguration.getExpirationNotificatorIntervalInSeconds();
        if (interval < 0) {
            this.log.info("ExpirationNotificator Timer is disabled.");
            this.log.warn("ExpirationNotificator Timer Interval (expirationNotificatorIntervalInSeconds in oxauth configuration) is negative which turns OFF internal clean up by the server. Please set it to positive value if you wish internal clean up timer run.");
            return false;
        }
        long timerInterval = interval * 1000;
        long timeDiffrence = System.currentTimeMillis() - this.lastFinishedTime;
        return timeDiffrence >= timerInterval;
    }

    public boolean remove(SessionId sessionId) {
        try {
            this.persistenceEntryManager.remove(sessionId.getDn());
            this.externalApplicationSessionService.externalEvent(new SessionEvent(SessionEventType.GONE, sessionId));
            return true;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

