/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.unboundid.ldap.sdk.LDAPException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.enterprise.context.RequestScoped;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.audit.ApplicationAuditLogger;
import org.gluu.oxauth.model.audit.Action;
import org.gluu.oxauth.model.audit.OAuth2AuditLog;
import org.gluu.oxauth.model.common.Prompt;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.common.SessionIdState;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.oxauth.model.config.WebKeysConfiguration;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.exception.AcrChangedException;
import org.gluu.oxauth.model.exception.InvalidSessionStateException;
import org.gluu.oxauth.model.jwt.Jwt;
import org.gluu.oxauth.model.jwt.JwtSubClaimObject;
import org.gluu.oxauth.model.token.JwtSigner;
import org.gluu.oxauth.model.util.JwtUtil;
import org.gluu.oxauth.model.util.Pair;
import org.gluu.oxauth.model.util.Util;
import org.gluu.oxauth.security.Identity;
import org.gluu.oxauth.service.CookieService;
import org.gluu.oxauth.service.RequestParameterService;
import org.gluu.oxauth.service.common.UserService;
import org.gluu.oxauth.service.external.ExternalApplicationSessionService;
import org.gluu.oxauth.service.external.ExternalAuthenticationService;
import org.gluu.oxauth.service.external.session.SessionEvent;
import org.gluu.oxauth.service.external.session.SessionEventType;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.exception.EntryPersistenceException;
import org.gluu.search.filter.Filter;
import org.gluu.service.CacheService;
import org.gluu.service.LocalCacheService;
import org.gluu.util.StringHelper;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.slf4j.Logger;

@RequestScoped
@Named
public class SessionIdService {
    public static final String OP_BROWSER_STATE = "opbs";
    public static final String SESSION_CUSTOM_STATE = "session_custom_state";
    private static final int MAX_MERGE_ATTEMPTS = 3;
    private static final int DEFAULT_LOCAL_CACHE_EXPIRATION = 2;
    @Inject
    private Logger log;
    @Inject
    private ExternalAuthenticationService externalAuthenticationService;
    @Inject
    private ExternalApplicationSessionService externalApplicationSessionService;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private WebKeysConfiguration webKeysConfiguration;
    @Inject
    private FacesContext facesContext;
    @Inject
    private ExternalContext externalContext;
    @Inject
    private RequestParameterService requestParameterService;
    @Inject
    private UserService userService;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private CookieService cookieService;
    @Inject
    private Identity identity;
    @Inject
    private LocalCacheService localCacheService;
    @Inject
    private CacheService cacheService;

    private String buildDn(String sessionId) {
        return String.format("oxId=%s,%s", sessionId, this.staticConfiguration.getBaseDn().getSessions());
    }

    public Set<SessionId> getCurrentSessions() {
        Set<String> ids = this.cookieService.getCurrentSessions();
        HashSet sessions = Sets.newHashSet();
        for (String sessionId : ids) {
            if (StringUtils.isBlank((String)sessionId)) {
                this.log.error("Invalid sessionId in current_sessions: " + sessionId);
                continue;
            }
            SessionId sessionIdObj = this.getSessionId(sessionId);
            if (sessionIdObj == null) {
                this.log.trace("Unable to find session object by id: " + sessionId + " {expired?}");
                continue;
            }
            if (sessionIdObj.getState() != SessionIdState.AUTHENTICATED) {
                this.log.error("Session is not authenticated, id: " + sessionId);
                continue;
            }
            sessions.add(sessionIdObj);
        }
        return sessions;
    }

    public String getAcr(SessionId session) {
        if (session == null) {
            return null;
        }
        String acr = session.getSessionAttributes().get("acr");
        if (StringUtils.isBlank((String)acr)) {
            acr = session.getSessionAttributes().get("acr_values");
        }
        return acr;
    }

    public SessionId assertAuthenticatedSessionCorrespondsToNewRequest(SessionId session, String acrValuesStr) throws AcrChangedException {
        if (session != null && !session.getSessionAttributes().isEmpty() && session.getState() == SessionIdState.AUTHENTICATED) {
            boolean isAcrChanged;
            Map<String, String> sessionAttributes = session.getSessionAttributes();
            String sessionAcr = this.getAcr(session);
            if (StringUtils.isBlank((String)sessionAcr)) {
                this.log.trace("Failed to fetch acr from session, attributes: " + sessionAttributes);
                return session;
            }
            List<String> acrValuesList = this.acrValuesList(acrValuesStr);
            boolean bl = isAcrChanged = !acrValuesList.isEmpty() && !acrValuesList.contains(sessionAcr);
            if (isAcrChanged) {
                Map<String, Integer> acrToLevel = this.externalAuthenticationService.acrToLevelMapping();
                Integer sessionAcrLevel = acrToLevel.get(this.externalAuthenticationService.scriptName(sessionAcr));
                for (String acrValue : acrValuesList) {
                    Integer currentAcrLevel = acrToLevel.get(this.externalAuthenticationService.scriptName(acrValue));
                    this.log.info("Acr is changed. Session acr: " + sessionAcr + "(level: " + sessionAcrLevel + "), current acr: " + acrValue + "(level: " + currentAcrLevel + ")");
                    if (currentAcrLevel == null) {
                        throw new AcrChangedException(false);
                    }
                    if (sessionAcrLevel >= currentAcrLevel) continue;
                    throw new AcrChangedException();
                }
                return session;
            }
            this.reinitLogin(session, false);
        }
        return session;
    }

    private static boolean shouldReinitSession(Map<String, String> sessionAttributes, Map<String, String> currentSessionAttributes) {
        HashMap<String, String> copySessionAttributes = new HashMap<String, String>(sessionAttributes);
        HashMap<String, String> copyCurrentSessionAttributes = new HashMap<String, String>(currentSessionAttributes);
        copySessionAttributes.remove("state");
        copyCurrentSessionAttributes.remove("state");
        return !copyCurrentSessionAttributes.equals(copySessionAttributes);
    }

    public boolean reinitLogin(SessionId session, boolean force) {
        Map<String, String> sessionAttributes = session.getSessionAttributes();
        Map<String, String> currentSessionAttributes = this.getCurrentSessionAttributes(sessionAttributes);
        if (force || SessionIdService.shouldReinitSession(sessionAttributes, currentSessionAttributes)) {
            boolean updateResult;
            sessionAttributes.putAll(currentSessionAttributes);
            sessionAttributes.put("c", "1");
            Iterator<Map.Entry<String, String>> it = currentSessionAttributes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> currentSessionAttributesEntry = it.next();
                String name = currentSessionAttributesEntry.getKey();
                if (!name.startsWith("auth_step_passed_")) continue;
                it.remove();
            }
            session.setSessionAttributes(currentSessionAttributes);
            if (force) {
                session.setState(SessionIdState.UNAUTHENTICATED);
                this.externalEvent(new SessionEvent(SessionEventType.UNAUTHENTICATED, session));
            }
            if (!(updateResult = this.updateSessionId(session, true, true, true))) {
                this.log.debug("Failed to update session entry: '{}'", (Object)session.getId());
            }
            return updateResult;
        }
        return false;
    }

    public SessionId resetToStep(SessionId session, int resetToStep) {
        Map<String, String> sessionAttributes = session.getSessionAttributes();
        int currentStep = 1;
        if (sessionAttributes.containsKey("auth_step")) {
            currentStep = StringHelper.toInteger((String)sessionAttributes.get("auth_step"), (int)currentStep);
        }
        for (int i = resetToStep; i <= currentStep; ++i) {
            String key = String.format("auth_step_passed_%d", i);
            sessionAttributes.remove(key);
        }
        sessionAttributes.put("auth_step", String.valueOf(resetToStep));
        boolean updateResult = this.updateSessionId(session, true, true, true);
        if (!updateResult) {
            this.log.debug("Failed to update session entry: '{}'", (Object)session.getId());
            return null;
        }
        return session;
    }

    private Map<String, String> getCurrentSessionAttributes(Map<String, String> sessionAttributes) {
        if (this.facesContext == null) {
            return sessionAttributes;
        }
        HashMap<String, String> currentSessionAttributes = new HashMap<String, String>(sessionAttributes);
        Map parameterMap = this.externalContext.getRequestParameterMap();
        Map<String, String> newRequestParameterMap = this.requestParameterService.getAllowedParameters(parameterMap);
        for (Map.Entry<String, String> newRequestParameterMapEntry : newRequestParameterMap.entrySet()) {
            String name = newRequestParameterMapEntry.getKey();
            if (StringHelper.equalsIgnoreCase((String)name, (String)"auth_step")) continue;
            currentSessionAttributes.put(name, newRequestParameterMapEntry.getValue());
        }
        return currentSessionAttributes;
    }

    public SessionId getSessionId() {
        String sessionId = this.cookieService.getSessionIdFromCookie();
        if (StringHelper.isEmpty((String)sessionId) && this.identity.getSessionId() != null) {
            sessionId = this.identity.getSessionId().getId();
        }
        if (StringHelper.isNotEmpty((String)sessionId)) {
            return this.getSessionId(sessionId);
        }
        this.log.trace("Session cookie not exists");
        return null;
    }

    public Map<String, String> getSessionAttributes(SessionId sessionId) {
        if (sessionId != null) {
            return sessionId.getSessionAttributes();
        }
        return null;
    }

    public SessionId generateAuthenticatedSessionId(HttpServletRequest httpRequest, String userDn) throws InvalidSessionStateException {
        HashMap<String, String> sessionIdAttributes = new HashMap<String, String>();
        sessionIdAttributes.put("prompt", "");
        return this.generateAuthenticatedSessionId(httpRequest, userDn, sessionIdAttributes);
    }

    public SessionId generateAuthenticatedSessionId(HttpServletRequest httpRequest, String userDn, String prompt) throws InvalidSessionStateException {
        HashMap<String, String> sessionIdAttributes = new HashMap<String, String>();
        sessionIdAttributes.put("prompt", prompt);
        return this.generateAuthenticatedSessionId(httpRequest, userDn, sessionIdAttributes);
    }

    public SessionId generateAuthenticatedSessionId(HttpServletRequest httpRequest, String userDn, Map<String, String> sessionIdAttributes) throws InvalidSessionStateException {
        SessionId sessionId = this.generateSessionId(userDn, new Date(), SessionIdState.AUTHENTICATED, sessionIdAttributes, true);
        if (this.externalApplicationSessionService.isEnabled()) {
            String userName = sessionId.getSessionAttributes().get("auth_user");
            boolean externalResult = this.externalApplicationSessionService.executeExternalStartSessionMethods(httpRequest, sessionId);
            this.log.info("Start session result for '{}': '{}'", new Object[]{userName, "start", externalResult});
            if (!externalResult) {
                this.reinitLogin(sessionId, true);
                throw new InvalidSessionStateException("Session creation is prohibited by external session script!");
            }
            this.externalEvent(new SessionEvent(SessionEventType.AUTHENTICATED, sessionId).setHttpRequest(httpRequest));
        }
        return sessionId;
    }

    public SessionId generateUnauthenticatedSessionId(String userDn) {
        HashMap<String, String> sessionIdAttributes = new HashMap<String, String>();
        return this.generateSessionId(userDn, new Date(), SessionIdState.UNAUTHENTICATED, sessionIdAttributes, true);
    }

    public SessionId generateUnauthenticatedSessionId(String userDn, Date authenticationDate, SessionIdState state, Map<String, String> sessionIdAttributes, boolean persist) {
        return this.generateSessionId(userDn, authenticationDate, state, sessionIdAttributes, persist);
    }

    public String computeSessionState(SessionId sessionId, String clientId, String redirectUri) {
        boolean isSameClient;
        boolean bl = isSameClient = clientId.equals(sessionId.getSessionAttributes().get("client_id")) && redirectUri.equals(sessionId.getSessionAttributes().get("redirect_uri"));
        if (isSameClient) {
            return sessionId.getSessionState();
        }
        String salt = UUID.randomUUID().toString();
        String opbs = sessionId.getOPBrowserState();
        String sessionState = this.computeSessionState(clientId, redirectUri, opbs, salt);
        return sessionState;
    }

    private String computeSessionState(String clientId, String redirectUri, String opbs, String salt) {
        try {
            String clientOrigin = this.getClientOrigin(redirectUri);
            String sessionState = JwtUtil.bytesToHex((byte[])JwtUtil.getMessageDigestSHA256((String)(clientId + " " + clientOrigin + " " + opbs + " " + salt))) + "." + salt;
            return sessionState;
        }
        catch (UnsupportedEncodingException | URISyntaxException | NoSuchAlgorithmException | NoSuchProviderException e) {
            this.log.error("Failed generating session state! " + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String getClientOrigin(String redirectUri) throws URISyntaxException {
        if (StringHelper.isNotEmpty((String)redirectUri)) {
            URI uri = new URI(redirectUri);
            String result = uri.getScheme() + "://" + uri.getHost();
            if (uri.getPort() > 0) {
                result = result + ":" + Integer.toString(uri.getPort());
            }
            return result;
        }
        return this.appConfiguration.getIssuer();
    }

    private SessionId generateSessionId(String userDn, Date authenticationDate, SessionIdState state, Map<String, String> sessionIdAttributes, boolean persist) {
        String internalSid = UUID.randomUUID().toString();
        String outsideSid = UUID.randomUUID().toString();
        String salt = UUID.randomUUID().toString();
        String clientId = sessionIdAttributes.get("client_id");
        String opbs = UUID.randomUUID().toString();
        String redirectUri = sessionIdAttributes.get("redirect_uri");
        String sessionState = this.computeSessionState(clientId, redirectUri, opbs, salt);
        String dn = this.buildDn(internalSid);
        sessionIdAttributes.put(OP_BROWSER_STATE, opbs);
        Preconditions.checkNotNull((Object)dn);
        if (SessionIdState.AUTHENTICATED == state && StringUtils.isBlank((String)userDn) && !sessionIdAttributes.containsKey("uma")) {
            return null;
        }
        SessionId sessionId = new SessionId();
        sessionId.setId(internalSid);
        sessionId.setOutsideSid(outsideSid);
        sessionId.setDn(dn);
        sessionId.setUserDn(userDn);
        sessionId.setSessionState(sessionState);
        Pair<Date, Integer> expiration = this.expirationDate(sessionId.getCreationDate(), state);
        sessionId.setExpirationDate((Date)expiration.getFirst());
        sessionId.setTtl((Integer)expiration.getSecond());
        Boolean sessionAsJwt = this.appConfiguration.getSessionAsJwt();
        sessionId.setIsJwt(sessionAsJwt != null && sessionAsJwt != false);
        sessionId.setAuthenticationTime(authenticationDate != null ? authenticationDate : new Date());
        if (state != null) {
            sessionId.setState(state);
        }
        sessionId.setSessionAttributes(sessionIdAttributes);
        sessionId.setLastUsedAt(new Date());
        if (sessionId.getIsJwt().booleanValue()) {
            sessionId.setJwt(this.generateJwt(sessionId, userDn).asString());
        }
        boolean persisted = false;
        if (persist) {
            persisted = this.persistSessionId(sessionId);
        }
        this.auditLogging(sessionId);
        this.log.trace("Generated new session, id = '{}', state = '{}', asJwt = '{}', persisted = '{}'", new Object[]{sessionId.getId(), sessionId.getState(), sessionId.getIsJwt(), persisted});
        return sessionId;
    }

    private Jwt generateJwt(SessionId sessionId, String audience) {
        try {
            JwtSigner jwtSigner = new JwtSigner(this.appConfiguration, this.webKeysConfiguration, SignatureAlgorithm.RS512, audience);
            Jwt jwt = jwtSigner.newJwt();
            jwt.getClaims().setClaim("id", sessionId.getId());
            jwt.getClaims().setClaim("authentication_time", sessionId.getAuthenticationTime());
            jwt.getClaims().setClaim("user_dn", sessionId.getUserDn());
            jwt.getClaims().setClaim("state", sessionId.getState() != null ? sessionId.getState().getValue() : "");
            jwt.getClaims().setClaim("session_attributes", JwtSubClaimObject.fromMap(sessionId.getSessionAttributes()));
            jwt.getClaims().setClaim("last_used_at", sessionId.getLastUsedAt());
            jwt.getClaims().setClaim("permission_granted", sessionId.getPermissionGranted());
            jwt.getClaims().setClaim("permission_granted_map", JwtSubClaimObject.fromBooleanMap(sessionId.getPermissionGrantedMap().getPermissionGranted()));
            return jwtSigner.sign();
        }
        catch (Exception e) {
            this.log.error("Failed to sign session jwt! " + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public SessionId setSessionIdStateAuthenticated(HttpServletRequest httpRequest, HttpServletResponse httpResponse, SessionId sessionId, String p_userDn) {
        boolean persisted;
        sessionId.setUserDn(p_userDn);
        sessionId.setAuthenticationTime(new Date());
        sessionId.setState(SessionIdState.AUTHENTICATED);
        if (this.appConfiguration.getChangeSessionIdOnAuthentication().booleanValue() && httpResponse != null) {
            String oldSesionId = sessionId.getId();
            String newSessionId = UUID.randomUUID().toString();
            this.log.debug("Changing session id from {} to {} ...", (Object)oldSesionId, (Object)newSessionId);
            this.remove(sessionId);
            sessionId.setId(newSessionId);
            sessionId.setDn(this.buildDn(newSessionId));
            if (sessionId.getIsJwt().booleanValue()) {
                sessionId.setJwt(this.generateJwt(sessionId, sessionId.getUserDn()).asString());
            }
            persisted = this.persistSessionId(sessionId, true);
            this.cookieService.createSessionIdCookie(sessionId, httpRequest, httpResponse, false);
            this.log.debug("Session identifier changed from {} to {} .", (Object)oldSesionId, (Object)newSessionId);
        } else {
            persisted = this.updateSessionId(sessionId, true, true, true);
        }
        this.auditLogging(sessionId);
        this.log.trace("Authenticated session, id = '{}', state = '{}', persisted = '{}'", new Object[]{sessionId.getId(), sessionId.getState(), persisted});
        if (this.externalApplicationSessionService.isEnabled()) {
            String userName = sessionId.getSessionAttributes().get("auth_user");
            boolean externalResult = this.externalApplicationSessionService.executeExternalStartSessionMethods(httpRequest, sessionId);
            this.log.info("Start session result for '{}': '{}'", new Object[]{userName, "start", externalResult});
            if (!externalResult) {
                this.reinitLogin(sessionId, true);
                throw new InvalidSessionStateException("Session creation is prohibited by external session script!");
            }
            this.externalEvent(new SessionEvent(SessionEventType.AUTHENTICATED, sessionId).setHttpRequest(httpRequest).setHttpResponse(httpResponse));
        }
        return sessionId;
    }

    public boolean persistSessionId(SessionId sessionId) {
        return this.persistSessionId(sessionId, false);
    }

    public boolean persistSessionId(SessionId sessionId, boolean forcePersistence) {
        List<Prompt> prompts = this.getPromptsFromSessionId(sessionId);
        try {
            int unusedLifetime = this.appConfiguration.getSessionIdUnusedLifetime();
            if (unusedLifetime > 0 && this.isPersisted(prompts) || forcePersistence) {
                sessionId.setLastUsedAt(new Date());
                Pair<Date, Integer> expiration = this.expirationDate(sessionId.getCreationDate(), sessionId.getState());
                sessionId.setPersisted(true);
                sessionId.setExpirationDate((Date)expiration.getFirst());
                sessionId.setTtl((Integer)expiration.getSecond());
                this.log.trace("sessionIdAttributes: " + sessionId.getPermissionGrantedMap());
                if (this.appConfiguration.getSessionIdPersistInCache().booleanValue()) {
                    this.cacheService.put(((Integer)expiration.getSecond()).intValue(), sessionId.getDn(), (Object)sessionId);
                } else {
                    this.persistenceEntryManager.persist((Object)sessionId);
                }
                this.localCacheService.put(2, sessionId.getDn(), (Object)sessionId);
                return true;
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public boolean updateSessionId(SessionId sessionId) {
        return this.updateSessionId(sessionId, true);
    }

    public boolean updateSessionId(SessionId sessionId, boolean updateLastUsedAt) {
        return this.updateSessionId(sessionId, updateLastUsedAt, false, true);
    }

    public boolean updateSessionId(SessionId sessionId, boolean updateLastUsedAt, boolean forceUpdate, boolean modified) {
        List<Prompt> prompts = this.getPromptsFromSessionId(sessionId);
        try {
            int unusedLifetime = this.appConfiguration.getSessionIdUnusedLifetime();
            if (unusedLifetime > 0 && this.isPersisted(prompts) || forceUpdate) {
                boolean update = modified;
                if (updateLastUsedAt) {
                    Date lastUsedAt = new Date();
                    if (sessionId.getLastUsedAt() != null) {
                        long diff = lastUsedAt.getTime() - sessionId.getLastUsedAt().getTime();
                        int unusedDiffInSeconds = (int)(diff / 1000L);
                        if (unusedDiffInSeconds > unusedLifetime) {
                            this.log.debug("Session id expired: {} by sessionIdUnusedLifetime, remove it.", (Object)sessionId.getId());
                            this.remove(sessionId);
                            return false;
                        }
                        if (diff > 500L) {
                            update = true;
                            sessionId.setLastUsedAt(lastUsedAt);
                        }
                    } else {
                        update = true;
                        sessionId.setLastUsedAt(lastUsedAt);
                    }
                }
                if (!sessionId.isPersisted()) {
                    update = true;
                    sessionId.setPersisted(true);
                }
                if (this.isExpired(sessionId)) {
                    this.log.debug("Session id expired: {} by lifetime property, remove it.", (Object)sessionId.getId());
                    this.remove(sessionId);
                    update = false;
                }
                if (update) {
                    this.mergeWithRetry(sessionId);
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean isExpired(SessionId sessionId) {
        if (sessionId.getAuthenticationTime() == null) {
            return false;
        }
        long currentLifetimeInSeconds = (System.currentTimeMillis() - sessionId.getAuthenticationTime().getTime()) / 1000L;
        return currentLifetimeInSeconds > (long)this.getServerSessionIdLifetimeInSeconds();
    }

    public int getServerSessionIdLifetimeInSeconds() {
        if (this.appConfiguration.getServerSessionIdLifetime() != null && this.appConfiguration.getServerSessionIdLifetime() > 0) {
            return this.appConfiguration.getServerSessionIdLifetime();
        }
        if (this.appConfiguration.getSessionIdLifetime() != null && this.appConfiguration.getSessionIdLifetime() > 0) {
            return this.appConfiguration.getSessionIdLifetime();
        }
        if (this.appConfiguration.getServerSessionIdLifetime() != null && this.appConfiguration.getSessionIdLifetime() != null && this.appConfiguration.getServerSessionIdLifetime() <= 0 && this.appConfiguration.getSessionIdLifetime() <= 0) {
            return Integer.MAX_VALUE;
        }
        this.log.debug("Session id lifetime configuration is null.");
        return 86400;
    }

    private Pair<Date, Integer> expirationDate(Date creationDate, SessionIdState state) {
        int expirationInSeconds = state == SessionIdState.UNAUTHENTICATED ? this.appConfiguration.getSessionIdUnauthenticatedUnusedLifetime() : this.getServerSessionIdLifetimeInSeconds();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(creationDate);
        calendar.add(13, expirationInSeconds);
        return new Pair((Object)calendar.getTime(), (Object)expirationInSeconds);
    }

    private void mergeWithRetry(SessionId sessionId) {
        Pair<Date, Integer> expiration = this.expirationDate(sessionId.getCreationDate(), sessionId.getState());
        sessionId.setExpirationDate((Date)expiration.getFirst());
        sessionId.setTtl((Integer)expiration.getSecond());
        EntryPersistenceException lastException = null;
        for (int i = 1; i <= 3; ++i) {
            try {
                if (this.appConfiguration.getSessionIdPersistInCache().booleanValue()) {
                    this.cacheService.put(((Integer)expiration.getSecond()).intValue(), sessionId.getDn(), (Object)sessionId);
                } else {
                    this.persistenceEntryManager.merge((Object)sessionId);
                }
                this.localCacheService.put(2, sessionId.getDn(), (Object)sessionId);
                this.externalEvent(new SessionEvent(SessionEventType.UPDATED, sessionId));
                return;
            }
            catch (EntryPersistenceException ex) {
                block9: {
                    block8: {
                        lastException = ex;
                        if (!(ex.getCause() instanceof LDAPException)) break block8;
                        LDAPException parentEx = (LDAPException)ex.getCause();
                        this.log.debug("LDAP exception resultCode: '{}'", (Object)parentEx.getResultCode().intValue());
                        if (parentEx.getResultCode().intValue() == 16 || parentEx.getResultCode().intValue() == 20) break block9;
                    }
                    throw ex;
                }
                this.log.warn("Session entry update attempt '{}' was unsuccessfull", (Object)i);
                continue;
            }
        }
        this.log.error("Session entry update attempt was unsuccessfull after '{}' attempts", (Object)3);
        throw lastException;
    }

    public void updateSessionIdIfNeeded(SessionId sessionId, boolean modified) {
        this.updateSessionId(sessionId, true, false, modified);
    }

    private boolean isPersisted(List<Prompt> prompts) {
        if (prompts != null && prompts.contains(Prompt.NONE)) {
            Boolean persistOnPromptNone = this.appConfiguration.getSessionIdPersistOnPromptNone();
            return persistOnPromptNone != null && persistOnPromptNone != false;
        }
        return true;
    }

    @Nullable
    public SessionId getSessionById(@Nullable String sessionId, boolean silently) {
        return this.getSessionByDn(this.buildDn(sessionId), silently);
    }

    @Nullable
    public SessionId getSessionByDn(@Nullable String dn) {
        return this.getSessionByDn(dn, false);
    }

    @Nullable
    public SessionId getSessionByDn(@Nullable String dn, boolean silently) {
        if (StringUtils.isBlank((String)dn)) {
            return null;
        }
        Object localCopy = this.localCacheService.get(dn);
        if (localCopy instanceof SessionId) {
            if (this.isSessionValid((SessionId)localCopy)) {
                return (SessionId)localCopy;
            }
            this.localCacheService.remove(dn);
        }
        try {
            SessionId sessionId = this.appConfiguration.getSessionIdPersistInCache() != false ? (SessionId)this.cacheService.get(dn) : (SessionId)this.persistenceEntryManager.find(SessionId.class, (Object)dn);
            this.localCacheService.put(2, sessionId.getDn(), (Object)sessionId);
            return sessionId;
        }
        catch (Exception e) {
            if (!silently) {
                this.log.error("Failed to get session by dn: " + dn, (Throwable)e);
            }
            return null;
        }
    }

    @Deprecated
    public String getSessionIdFromCookie() {
        return this.cookieService.getSessionIdFromCookie();
    }

    public SessionId getSessionId(HttpServletRequest request) {
        String sessionIdFromCookie = this.cookieService.getSessionIdFromCookie(request);
        this.log.trace("SessionId from cookie: " + sessionIdFromCookie);
        return this.getSessionId(sessionIdFromCookie);
    }

    public SessionId getSessionId(String sessionId) {
        return this.getSessionId(sessionId, false);
    }

    public SessionId getSessionId(String sessionId, boolean silently) {
        block5: {
            if (StringHelper.isEmpty((String)sessionId)) {
                return null;
            }
            try {
                SessionId entity = this.getSessionById(sessionId, silently);
                this.log.trace("Try to get session by id: {} ...", (Object)sessionId);
                if (entity != null) {
                    this.log.trace("Session dn: {}", (Object)entity.getDn());
                    if (this.isSessionValid(entity)) {
                        return entity;
                    }
                }
            }
            catch (Exception ex) {
                if (silently) break block5;
                this.log.trace(ex.getMessage(), (Throwable)ex);
            }
        }
        this.log.trace("Failed to get session by id: {}", (Object)sessionId);
        return null;
    }

    public boolean remove(SessionId sessionId) {
        try {
            if (this.appConfiguration.getSessionIdPersistInCache().booleanValue()) {
                this.cacheService.remove(sessionId.getDn());
            } else {
                this.persistenceEntryManager.remove(sessionId.getDn());
            }
            this.localCacheService.remove(sessionId.getDn());
            this.externalEvent(new SessionEvent(SessionEventType.GONE, sessionId));
            return true;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void remove(List<SessionId> list) {
        for (SessionId id : list) {
            try {
                this.remove(id);
            }
            catch (Exception e) {
                this.log.error("Failed to remove entry", (Throwable)e);
            }
        }
    }

    public boolean isSessionValid(SessionId sessionId) {
        if (sessionId == null) {
            return false;
        }
        long sessionInterval = TimeUnit.SECONDS.toMillis(this.appConfiguration.getSessionIdUnusedLifetime());
        long sessionUnauthenticatedInterval = TimeUnit.SECONDS.toMillis(this.appConfiguration.getSessionIdUnauthenticatedUnusedLifetime());
        long timeSinceLastAccess = System.currentTimeMillis() - sessionId.getLastUsedAt().getTime();
        if (timeSinceLastAccess > sessionInterval && this.appConfiguration.getSessionIdUnusedLifetime() != -1) {
            return false;
        }
        return sessionId.getState() != SessionIdState.UNAUTHENTICATED || timeSinceLastAccess <= sessionUnauthenticatedInterval || this.appConfiguration.getSessionIdUnauthenticatedUnusedLifetime() == -1;
    }

    private List<Prompt> getPromptsFromSessionId(SessionId sessionId) {
        String promptParam = sessionId.getSessionAttributes().get("prompt");
        return Prompt.fromString((String)promptParam, (String)" ");
    }

    public boolean isSessionIdAuthenticated(SessionId sessionId) {
        if (sessionId == null) {
            return false;
        }
        return SessionIdState.AUTHENTICATED.equals((Object)sessionId.getState());
    }

    public List<String> acrValuesList(String acrValues) {
        List acrs;
        try {
            acrs = Util.jsonArrayStringAsList((String)acrValues);
        }
        catch (JSONException ex) {
            acrs = Util.splittedStringAsList((String)acrValues, (String)" ");
        }
        return acrs;
    }

    private void auditLogging(SessionId sessionId) {
        HttpServletRequest httpServletRequest = ServerUtil.getRequestOrNull();
        if (httpServletRequest != null) {
            Action action;
            switch (sessionId.getState()) {
                case AUTHENTICATED: {
                    action = Action.SESSION_AUTHENTICATED;
                    break;
                }
                case UNAUTHENTICATED: {
                    action = Action.SESSION_UNAUTHENTICATED;
                    break;
                }
                default: {
                    action = Action.SESSION_UNAUTHENTICATED;
                }
            }
            OAuth2AuditLog oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(httpServletRequest), action);
            oAuth2AuditLog.setSuccess(true);
            this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
        }
    }

    public User getUser(SessionId sessionId) {
        if (sessionId == null) {
            return null;
        }
        if (sessionId.getUser() != null) {
            return sessionId.getUser();
        }
        if (StringUtils.isBlank((String)sessionId.getUserDn())) {
            return null;
        }
        User user = this.userService.getUserByDn(sessionId.getUserDn(), new String[0]);
        if (user != null) {
            sessionId.setUser(user);
            return user;
        }
        return null;
    }

    public List<SessionId> findByUser(String userDn) {
        if (this.appConfiguration.getSessionIdPersistInCache().booleanValue()) {
            throw new UnsupportedOperationException("Operation is not supported with sessionIdPersistInCache=true. Set it to false to avoid this exception.");
        }
        Filter filter = Filter.createEqualityFilter((String)"oxAuthUserDN", (Object)userDn);
        return this.persistenceEntryManager.findEntries(this.staticConfiguration.getBaseDn().getSessions(), SessionId.class, filter);
    }

    public void externalEvent(SessionEvent event) {
        this.externalApplicationSessionService.externalEvent(event);
    }
}

