/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import java.util.UUID;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.common.AuthorizationGrantType;
import org.gluu.oxauth.model.common.BackchannelTokenDeliveryMode;
import org.gluu.oxauth.model.common.CIBAGrant;
import org.gluu.oxauth.model.common.IAuthorizationGrant;
import org.gluu.oxauth.model.common.SubjectType;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.service.PairwiseIdentifierService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.util.StringHelper;
import org.oxauth.persistence.model.PairwiseIdentifier;
import org.oxauth.persistence.model.SectorIdentifier;
import org.slf4j.Logger;

@Stateless
@Named
public class SectorIdentifierService {
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private PairwiseIdentifierService pairwiseIdentifierService;
    @Inject
    protected AppConfiguration appConfiguration;

    public SectorIdentifier getSectorIdentifierById(String oxId) {
        SectorIdentifier result = null;
        try {
            result = (SectorIdentifier)this.ldapEntryManager.find(SectorIdentifier.class, (Object)this.getDnForSectorIdentifier(oxId));
        }
        catch (Exception e) {
            this.log.error("Failed to find sector identifier by oxId " + oxId, (Throwable)e);
        }
        return result;
    }

    public String getDnForSectorIdentifier(String oxId) {
        String sectorIdentifierDn = this.staticConfiguration.getBaseDn().getSectorIdentifiers();
        if (StringHelper.isEmpty((String)oxId)) {
            return sectorIdentifierDn;
        }
        return String.format("oxId=%s,%s", oxId, sectorIdentifierDn);
    }

    public String getSub(IAuthorizationGrant grant) {
        Client client = grant.getClient();
        User user = grant.getUser();
        if (user == null) {
            this.log.trace("User is null, return blank sub");
            return "";
        }
        if (client == null) {
            this.log.trace("Client is null, return blank sub.");
            return "";
        }
        if (grant.getAuthorizationGrantType() == AuthorizationGrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS) {
            return user.getUserId();
        }
        return this.getSub(client, user, grant instanceof CIBAGrant);
    }

    public String getSub(Client client, User user, boolean isCibaGrant) {
        if (user == null) {
            this.log.trace("User is null, return blank sub");
            return "";
        }
        if (client == null) {
            this.log.trace("Client is null, return blank sub.");
            return "";
        }
        boolean isClientPairwise = SubjectType.PAIRWISE.equals((Object)SubjectType.fromString((String)client.getSubjectType()));
        if (isClientPairwise) {
            String sectorIdentifierUri = StringUtils.isNotBlank((String)client.getSectorIdentifierUri()) ? client.getSectorIdentifierUri() : (!isCibaGrant ? (!ArrayUtils.isEmpty((Object[])client.getRedirectUris()) ? client.getRedirectUris()[0] : null) : (client.getBackchannelTokenDeliveryMode() == BackchannelTokenDeliveryMode.PUSH ? client.getBackchannelClientNotificationEndpoint() : client.getJwksUri()));
            String userInum = user.getAttribute("inum");
            try {
                PairwiseIdentifier pairwiseIdentifier = this.pairwiseIdentifierService.findPairWiseIdentifier(userInum, sectorIdentifierUri, client.getClientId());
                if (pairwiseIdentifier == null) {
                    pairwiseIdentifier = new PairwiseIdentifier(sectorIdentifierUri, client.getClientId(), userInum);
                    pairwiseIdentifier.setId(UUID.randomUUID().toString());
                    pairwiseIdentifier.setDn(this.pairwiseIdentifierService.getDnForPairwiseIdentifier(pairwiseIdentifier.getId(), userInum));
                    this.pairwiseIdentifierService.addPairwiseIdentifier(userInum, pairwiseIdentifier);
                }
                return pairwiseIdentifier.getId();
            }
            catch (Exception e) {
                this.log.error("Failed to get sub claim. PairwiseIdentifierService failed to find pair wise identifier.", (Throwable)e);
                return "";
            }
        }
        String openidSubAttribute = this.appConfiguration.getOpenidSubAttribute();
        if (StringHelper.equalsIgnoreCase((String)openidSubAttribute, (String)"uid")) {
            return user.getUserId();
        }
        return user.getAttribute(openidSubAttribute);
    }
}

