/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import java.net.URI;
import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.oxauth.model.common.PairwiseIdType;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.util.SubjectIdentifierGenerator;
import org.gluu.oxauth.service.common.UserService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.model.base.SimpleBranch;
import org.gluu.search.filter.Filter;
import org.gluu.util.StringHelper;
import org.oxauth.persistence.model.PairwiseIdentifier;
import org.slf4j.Logger;

@Stateless
@Named
public class PairwiseIdentifierService {
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private UserService userService;
    @Inject
    private AppConfiguration appConfiguration;

    public void addBranch(String userInum) {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName("pairwiseIdentifiers");
        branch.setDn(this.getBaseDnForPairwiseIdentifiers(userInum));
        this.ldapEntryManager.persist((Object)branch);
    }

    public boolean containsBranch(String userInum) {
        return this.ldapEntryManager.contains(this.getBaseDnForPairwiseIdentifiers(userInum), SimpleBranch.class);
    }

    public void prepareBranch(String userInum) {
        if (!this.ldapEntryManager.hasBranchesSupport(this.userService.getDnForUser(userInum))) {
            return;
        }
        if (!this.containsBranch(userInum)) {
            this.addBranch(userInum);
        }
    }

    public PairwiseIdentifier findPairWiseIdentifier(String userInum, String sectorIdentifierUri, String clientId) throws Exception {
        PairwiseIdType pairwiseIdType = PairwiseIdType.fromString((String)this.appConfiguration.getPairwiseIdType());
        String sectorIdentifier = URI.create(sectorIdentifierUri).getHost();
        if (PairwiseIdType.PERSISTENT == pairwiseIdType) {
            Filter sectorIdentifierFilter;
            this.prepareBranch(userInum);
            String baseDnForPairwiseIdentifiers = this.getBaseDnForPairwiseIdentifiers(userInum);
            Filter filter = null;
            if (this.appConfiguration.isShareSubjectIdBetweenClientsWithSameSectorId().booleanValue()) {
                sectorIdentifierFilter = Filter.createEqualityFilter((String)"oxSectorIdentifier", (Object)sectorIdentifier);
                Filter userInumFilter = Filter.createEqualityFilter((String)"oxAuthUserId", (Object)userInum);
                filter = Filter.createANDFilter((Filter[])new Filter[]{sectorIdentifierFilter, userInumFilter});
            } else {
                sectorIdentifierFilter = Filter.createEqualityFilter((String)"oxSectorIdentifier", (Object)sectorIdentifier);
                Filter clientIdFilter = Filter.createEqualityFilter((String)"oxAuthClientId", (Object)clientId);
                Filter userInumFilter = Filter.createEqualityFilter((String)"oxAuthUserId", (Object)userInum);
                filter = Filter.createANDFilter((Filter[])new Filter[]{sectorIdentifierFilter, clientIdFilter, userInumFilter});
            }
            List entries = this.ldapEntryManager.findEntries(baseDnForPairwiseIdentifiers, PairwiseIdentifier.class, filter);
            if (entries != null && !entries.isEmpty()) {
                if (entries.size() > 1) {
                    this.log.error("Found more then one pairwise identifier by sector identifier: {}" + sectorIdentifier);
                    for (PairwiseIdentifier pairwiseIdentifier : entries) {
                        this.log.error("PairwiseIdentifier: {}", (Object)pairwiseIdentifier);
                    }
                }
                return (PairwiseIdentifier)entries.get(0);
            }
        } else {
            String key = this.appConfiguration.getPairwiseCalculationKey();
            String salt = this.appConfiguration.getPairwiseCalculationSalt();
            String localAccountId = this.appConfiguration.isShareSubjectIdBetweenClientsWithSameSectorId() != false ? userInum : userInum + clientId;
            String calculatedSub = SubjectIdentifierGenerator.generatePairwiseSubjectIdentifier((String)sectorIdentifierUri, (String)localAccountId, (String)key, (String)salt, (AppConfiguration)this.appConfiguration);
            PairwiseIdentifier pairwiseIdentifier = new PairwiseIdentifier(sectorIdentifierUri, clientId, userInum);
            pairwiseIdentifier.setId(calculatedSub);
            return pairwiseIdentifier;
        }
        return null;
    }

    public void addPairwiseIdentifier(String userInum, PairwiseIdentifier pairwiseIdentifier) {
        this.prepareBranch(userInum);
        this.userService.addUserAttributeByUserInum(userInum, "oxPPID", (Object)pairwiseIdentifier.getId());
        this.ldapEntryManager.persist((Object)pairwiseIdentifier);
    }

    public String getDnForPairwiseIdentifier(String oxId, String userInum) {
        String baseDn = this.getBaseDnForPairwiseIdentifiers(userInum);
        if (StringHelper.isEmpty((String)oxId)) {
            return baseDn;
        }
        return String.format("oxId=%s,%s", oxId, baseDn);
    }

    public String getBaseDnForPairwiseIdentifiers(String userInum) {
        String userBaseDn = this.userService.getDnForUser(userInum);
        return String.format("ou=pairwiseIdentifiers,%s", userBaseDn);
    }
}

