/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.Stateless;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.config.ConfigurationFactory;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.util.StringUtils;
import org.gluu.oxauth.service.SessionIdService;
import org.gluu.persist.exception.EntryPersistenceException;
import org.gluu.service.cdi.util.CdiUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.slf4j.Logger;

@Stateless
@Named
public class CookieService {
    private static final String SESSION_STATE_COOKIE_NAME = "session_state";
    public static final String OP_BROWSER_STATE = "opbs";
    public static final String SESSION_ID_COOKIE_NAME = "session_id";
    private static final String RP_ORIGIN_ID_COOKIE_NAME = "rp_origin_id";
    private static final String UMA_SESSION_ID_COOKIE_NAME = "uma_session_id";
    public static final String CONSENT_SESSION_ID_COOKIE_NAME = "consent_session_id";
    public static final String CURRENT_SESSIONS_COOKIE_NAME = "current_sessions";
    @Inject
    private Logger log;
    @Inject
    private FacesContext facesContext;
    @Inject
    private ExternalContext externalContext;
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private AppConfiguration appConfiguration;

    public String getSessionIdFromCookie(HttpServletRequest request) {
        return this.getValueFromCookie(request, SESSION_ID_COOKIE_NAME);
    }

    public String getUmaSessionIdFromCookie(HttpServletRequest request) {
        return this.getValueFromCookie(request, UMA_SESSION_ID_COOKIE_NAME);
    }

    public String getConsentSessionIdFromCookie(HttpServletRequest request) {
        return this.getValueFromCookie(request, CONSENT_SESSION_ID_COOKIE_NAME);
    }

    public String getSessionStateFromCookie(HttpServletRequest request) {
        return this.getValueFromCookie(request, SESSION_STATE_COOKIE_NAME);
    }

    public Set<String> getCurrentSessions() {
        try {
            if (this.facesContext == null) {
                return null;
            }
            HttpServletRequest request = (HttpServletRequest)this.externalContext.getRequest();
            if (request != null) {
                return this.getCurrentSessions(request);
            }
            this.log.trace("Faces context returns null for http request object.");
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public Set<String> getCurrentSessions(HttpServletRequest request) {
        String valueFromCookie = this.getValueFromCookie(request, CURRENT_SESSIONS_COOKIE_NAME);
        if (org.apache.commons.lang.StringUtils.isBlank((String)valueFromCookie)) {
            return Sets.newHashSet();
        }
        try {
            return Sets.newHashSet((Iterable)StringUtils.toList((JSONArray)new JSONArray(valueFromCookie)));
        }
        catch (JSONException e) {
            this.log.error("Failed to parse current_sessions, value: " + valueFromCookie, (Throwable)e);
            return Sets.newHashSet();
        }
    }

    public void addCurrentSessionCookie(SessionId sessionId, HttpServletRequest request, HttpServletResponse httpResponse) {
        Set<String> currentSessions = this.getCurrentSessions(request);
        this.removeOutdatedCurrentSessions(currentSessions);
        currentSessions.add(sessionId.getId());
        String header = "current_sessions=" + new JSONArray(currentSessions).toString();
        header = header + "; Path=/";
        header = header + "; Secure";
        header = header + "; HttpOnly";
        this.createCookie(header, httpResponse);
    }

    private void removeOutdatedCurrentSessions(Set<String> currentSessions) {
        if (currentSessions.isEmpty()) {
            return;
        }
        SessionIdService sessionIdService = (SessionIdService)CdiUtil.bean(SessionIdService.class);
        HashSet toRemove = Sets.newHashSet();
        for (String sessionId : currentSessions) {
            SessionId sessionIdObject = null;
            try {
                sessionIdObject = sessionIdService.getSessionId(sessionId, true);
            }
            catch (EntryPersistenceException entryPersistenceException) {
                // empty catch block
            }
            if (sessionIdObject != null) continue;
            toRemove.add(sessionId);
        }
        currentSessions.removeAll(toRemove);
    }

    public String getValueFromCookie(HttpServletRequest request, String cookieName) {
        try {
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equals(cookieName)) continue;
                    this.log.trace("Found cookie: '{}'", (Object)cookie.getValue());
                    return cookie.getValue();
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return "";
    }

    public String getRpOriginIdCookie() {
        return this.getValueFromCookie(RP_ORIGIN_ID_COOKIE_NAME);
    }

    public String getValueFromCookie(String cookieName) {
        try {
            if (this.facesContext == null) {
                return null;
            }
            HttpServletRequest request = (HttpServletRequest)this.externalContext.getRequest();
            if (request != null) {
                return this.getValueFromCookie(request, cookieName);
            }
            this.log.trace("Faces context returns null for http request object.");
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public String getSessionIdFromCookie() {
        try {
            if (this.facesContext == null) {
                return null;
            }
            HttpServletRequest request = (HttpServletRequest)this.externalContext.getRequest();
            if (request != null) {
                return this.getSessionIdFromCookie(request);
            }
            this.log.trace("Faces context returns null for http request object.");
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void creatRpOriginIdCookie(String rpOriginId) {
        try {
            Object response = this.externalContext.getResponse();
            if (response instanceof HttpServletResponse) {
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                this.creatRpOriginIdCookie(rpOriginId, httpResponse);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void creatRpOriginIdCookie(String rpOriginId, HttpServletResponse httpResponse) {
        String header = "rp_origin_id=" + rpOriginId;
        header = header + "; Path=" + this.configurationFactory.getContextPath();
        header = header + "; Secure";
        header = header + "; HttpOnly";
        this.createCookie(header, httpResponse);
    }

    public void createCookieWithState(String sessionId, String sessionState, String opbs, HttpServletRequest request, HttpServletResponse httpResponse, String cookieName) {
        String header = cookieName + "=" + sessionId;
        header = header + "; Path=/";
        header = header + "; Secure";
        header = header + "; HttpOnly";
        this.createCookie(header, httpResponse);
        this.createSessionStateCookie(sessionState, httpResponse);
        this.createOPBrowserStateCookie(opbs, httpResponse);
    }

    public void createSessionIdCookie(SessionId sessionId, HttpServletRequest request, HttpServletResponse httpResponse, boolean isUma) {
        String cookieName;
        String string = cookieName = isUma ? UMA_SESSION_ID_COOKIE_NAME : SESSION_ID_COOKIE_NAME;
        if (!isUma) {
            this.addCurrentSessionCookie(sessionId, request, httpResponse);
        }
        this.createCookieWithState(sessionId.getId(), sessionId.getSessionState(), sessionId.getOPBrowserState(), request, httpResponse, cookieName);
    }

    public void createSessionIdCookie(SessionId sessionId, boolean isUma) {
        try {
            Object response = this.externalContext.getResponse();
            Object request = this.externalContext.getRequest();
            if (response instanceof HttpServletResponse && request instanceof HttpServletRequest) {
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                this.createSessionIdCookie(sessionId, httpRequest, httpResponse, isUma);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void createSessionStateCookie(String sessionState, HttpServletResponse httpResponse) {
        String header = "session_state=" + sessionState;
        header = header + "; Path=/";
        header = header + "; Secure";
        this.createCookie(header, httpResponse);
    }

    public void createOPBrowserStateCookie(String opbs, HttpServletResponse httpResponse) {
        String header = "opbs=" + opbs;
        header = header + "; Path=/";
        header = header + "; Secure";
        Integer sessionStateLifetime = this.appConfiguration.getSessionIdLifetime();
        if (sessionStateLifetime != null && sessionStateLifetime > 0) {
            SimpleDateFormat formatter = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss Z");
            Calendar expirationDate = Calendar.getInstance();
            expirationDate.add(13, sessionStateLifetime);
            header = header + "; Expires=" + formatter.format(expirationDate.getTime()) + ";";
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.appConfiguration.getCookieDomain())) {
                header = header + "Domain=" + this.appConfiguration.getCookieDomain() + ";";
            }
        }
        httpResponse.addHeader("Set-Cookie", header);
    }

    protected void createCookie(String header, HttpServletResponse httpResponse) {
        Integer sessionStateLifetime = this.appConfiguration.getSessionIdLifetime();
        if (sessionStateLifetime != null && sessionStateLifetime > 0) {
            SimpleDateFormat formatter = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss Z");
            Calendar expirationDate = Calendar.getInstance();
            expirationDate.add(13, sessionStateLifetime);
            header = header + "; Expires=" + formatter.format(expirationDate.getTime()) + ";";
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.appConfiguration.getCookieDomain())) {
                header = header + "Domain=" + this.appConfiguration.getCookieDomain() + ";";
            }
        }
        httpResponse.addHeader("Set-Cookie", header);
    }

    public void removeSessionIdCookie(HttpServletResponse httpResponse) {
        this.removeCookie(SESSION_ID_COOKIE_NAME, httpResponse);
    }

    public void removeOPBrowserStateCookie(HttpServletResponse httpResponse) {
        this.removeCookie(OP_BROWSER_STATE, httpResponse);
    }

    public void removeUmaSessionIdCookie(HttpServletResponse httpResponse) {
        this.removeCookie(UMA_SESSION_ID_COOKIE_NAME, httpResponse);
    }

    public void removeConsentSessionIdCookie(HttpServletResponse httpResponse) {
        this.removeCookie(CONSENT_SESSION_ID_COOKIE_NAME, httpResponse);
    }

    public void removeCookie(String cookieName, HttpServletResponse httpResponse) {
        Cookie cookie = new Cookie(cookieName, null);
        cookie.setPath("/");
        cookie.setMaxAge(0);
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.appConfiguration.getCookieDomain())) {
            cookie.setDomain(this.appConfiguration.getCookieDomain());
        }
        httpResponse.addCookie(cookie);
    }
}

