/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gluu.jsf2.message.FacesMessages;
import org.gluu.jsf2.service.FacesService;
import org.gluu.oxauth.auth.Authenticator;
import org.gluu.oxauth.ciba.CIBAPingCallbackService;
import org.gluu.oxauth.ciba.CIBAPushErrorService;
import org.gluu.oxauth.model.authorize.AuthorizeErrorResponseType;
import org.gluu.oxauth.model.ciba.PushErrorResponseType;
import org.gluu.oxauth.model.common.AuthorizationGrantList;
import org.gluu.oxauth.model.common.CibaRequestCacheControl;
import org.gluu.oxauth.model.common.CibaRequestStatus;
import org.gluu.oxauth.model.common.DeviceAuthorizationCacheControl;
import org.gluu.oxauth.model.common.DeviceAuthorizationStatus;
import org.gluu.oxauth.model.common.Prompt;
import org.gluu.oxauth.model.common.ResponseMode;
import org.gluu.oxauth.model.common.ResponseType;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.util.StringUtils;
import org.gluu.oxauth.security.Identity;
import org.gluu.oxauth.service.ClientAuthorizationsService;
import org.gluu.oxauth.service.ClientService;
import org.gluu.oxauth.service.CookieService;
import org.gluu.oxauth.service.DeviceAuthorizationService;
import org.gluu.oxauth.service.RequestParameterService;
import org.gluu.oxauth.service.ScopeService;
import org.gluu.oxauth.service.SessionIdService;
import org.gluu.oxauth.service.ciba.CibaRequestService;
import org.gluu.oxauth.util.RedirectUri;
import org.gluu.oxauth.util.ServerUtil;
import org.oxauth.persistence.model.Scope;
import org.slf4j.Logger;

@RequestScoped
public class AuthorizeService {
    @Inject
    private Logger log;
    @Inject
    private ClientService clientService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private CookieService cookieService;
    @Inject
    private ClientAuthorizationsService clientAuthorizationsService;
    @Inject
    private Identity identity;
    @Inject
    private Authenticator authenticator;
    @Inject
    private FacesService facesService;
    @Inject
    private FacesMessages facesMessages;
    @Inject
    private ExternalContext externalContext;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ScopeService scopeService;
    @Inject
    private RequestParameterService requestParameterService;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private CIBAPingCallbackService cibaPingCallbackService;
    @Inject
    private CIBAPushErrorService cibaPushErrorService;
    @Inject
    private CibaRequestService cibaRequestService;
    @Inject
    private DeviceAuthorizationService deviceAuthorizationService;

    public SessionId getSession() {
        return this.getSession(null);
    }

    public SessionId getSession(String sessionId) {
        SessionId ldapSessionId;
        if (org.apache.commons.lang.StringUtils.isBlank((String)sessionId) && org.apache.commons.lang.StringUtils.isBlank((String)(sessionId = this.cookieService.getSessionIdFromCookie()))) {
            return null;
        }
        if (!this.identity.isLoggedIn()) {
            this.authenticator.authenticateBySessionId(sessionId);
        }
        if ((ldapSessionId = this.sessionIdService.getSessionId(sessionId)) == null) {
            this.identity.logout();
        }
        return ldapSessionId;
    }

    public void permissionGranted(HttpServletRequest httpRequest, SessionId session) {
        this.log.trace("permissionGranted");
        try {
            Map<String, String> sessionAttribute;
            boolean persistDuringImplicitFlow;
            User user = this.sessionIdService.getUser(session);
            if (user == null) {
                this.log.debug("Permission denied. Failed to find session user: userDn = " + session.getUserDn() + ".");
                this.permissionDenied(session);
                return;
            }
            String clientId = session.getSessionAttributes().get("client_id");
            Client client = this.clientService.getClient(clientId);
            String scope = session.getSessionAttributes().get("scope");
            String responseType = session.getSessionAttributes().get("response_type");
            boolean bl = persistDuringImplicitFlow = ServerUtil.isFalse(this.appConfiguration.getUseCacheForAllImplicitFlowObjects()) || !ResponseType.isImplicitFlow((String)responseType);
            if (!client.getTrustedClient() && persistDuringImplicitFlow && client.getPersistClientAuthorizations()) {
                HashSet scopes = Sets.newHashSet((Iterable)StringUtils.spaceSeparatedToList((String)scope));
                this.clientAuthorizationsService.add(user.getAttribute("inum"), client.getClientId(), scopes);
            }
            session.addPermission(clientId, true);
            this.sessionIdService.updateSessionId(session);
            if (!this.appConfiguration.getInvalidateSessionCookiesAfterAuthorizationFlow().booleanValue()) {
                this.cookieService.createSessionIdCookie(session, false);
                this.identity.setSessionId(session);
            }
            if ((sessionAttribute = this.requestParameterService.getAllowedParameters(session.getSessionAttributes())).containsKey("prompt")) {
                List prompts = Prompt.fromString((String)sessionAttribute.get("prompt"), (String)" ");
                prompts.remove(Prompt.CONSENT);
                sessionAttribute.put("prompt", StringUtils.implodeEnum((List)prompts, (String)" "));
            }
            String parametersAsString = this.requestParameterService.parametersAsString(sessionAttribute);
            String uri = httpRequest.getContextPath() + "/restv1/authorize?" + parametersAsString;
            this.log.trace("permissionGranted, redirectTo: {}", (Object)uri);
            if (this.invalidateSessionCookiesIfNeeded() && !uri.contains("session_id") && this.appConfiguration.getSessionIdRequestParameterEnabled().booleanValue()) {
                uri = uri + "&session_id=" + session.getId();
            }
            this.facesService.redirectToExternalURL(uri);
        }
        catch (UnsupportedEncodingException e) {
            this.log.trace(e.getMessage(), (Throwable)e);
        }
    }

    public void permissionDenied(SessionId session) {
        String authReqId;
        CibaRequestCacheControl request;
        this.log.trace("permissionDenied");
        this.invalidateSessionCookiesIfNeeded();
        if (session == null) {
            this.authenticationFailedSessionInvalid();
            return;
        }
        String baseRedirectUri = session.getSessionAttributes().get("redirect_uri");
        String state = session.getSessionAttributes().get("state");
        ResponseMode responseMode = ResponseMode.fromString((String)session.getSessionAttributes().get("response_mode"));
        List responseType = ResponseType.fromString((String)session.getSessionAttributes().get("response_type"), (String)" ");
        RedirectUri redirectUri = new RedirectUri(baseRedirectUri, responseType, responseMode);
        redirectUri.parseQueryString(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.ACCESS_DENIED, state));
        Map<String, String> sessionAttribute = this.requestParameterService.getAllowedParameters(session.getSessionAttributes());
        if (sessionAttribute.containsKey("auth_req_id") && (request = this.cibaRequestService.getCibaRequest(authReqId = sessionAttribute.get("auth_req_id"))) != null && request.getClient() != null) {
            if (request.getStatus() == CibaRequestStatus.PENDING) {
                this.cibaRequestService.removeCibaRequest(authReqId);
            }
            switch (request.getClient().getBackchannelTokenDeliveryMode()) {
                case POLL: {
                    request.setStatus(CibaRequestStatus.DENIED);
                    request.setTokensDelivered(false);
                    this.cibaRequestService.update(request);
                    break;
                }
                case PING: {
                    request.setStatus(CibaRequestStatus.DENIED);
                    request.setTokensDelivered(false);
                    this.cibaRequestService.update(request);
                    this.cibaPingCallbackService.pingCallback(request.getAuthReqId(), request.getClient().getBackchannelClientNotificationEndpoint(), request.getClientNotificationToken());
                    break;
                }
                case PUSH: {
                    this.cibaPushErrorService.pushError(request.getAuthReqId(), request.getClient().getBackchannelClientNotificationEndpoint(), request.getClientNotificationToken(), PushErrorResponseType.ACCESS_DENIED, "The end-user denied the authorization request.");
                }
            }
        }
        if (sessionAttribute.containsKey("user_code")) {
            this.processDeviceAuthDeniedResponse(sessionAttribute);
        }
        this.facesService.redirectToExternalURL(redirectUri.toString());
    }

    private void authenticationFailedSessionInvalid() {
        this.facesMessages.add(FacesMessage.SEVERITY_ERROR, "login.errorSessionInvalidMessage");
        this.facesService.redirect("/error.xhtml");
    }

    public List<Scope> getScopes() {
        SessionId session = this.getSession();
        String scope = session.getSessionAttributes().get("scope");
        return this.getScopes(scope);
    }

    public List<Scope> getScopes(String scopes) {
        ArrayList<Scope> result = new ArrayList<Scope>();
        if (scopes != null && !scopes.isEmpty()) {
            String[] scopesName;
            for (String scopeName : scopesName = scopes.split(" ")) {
                Scope s = this.scopeService.getScopeById(scopeName);
                if (s == null || s.getDescription() == null) continue;
                result.add(s);
            }
        }
        return result;
    }

    private boolean invalidateSessionCookiesIfNeeded() {
        if (this.appConfiguration.getInvalidateSessionCookiesAfterAuthorizationFlow().booleanValue()) {
            return this.invalidateSessionCookies();
        }
        return false;
    }

    private boolean invalidateSessionCookies() {
        try {
            if (this.externalContext.getResponse() instanceof HttpServletResponse) {
                HttpServletResponse httpResponse = (HttpServletResponse)this.externalContext.getResponse();
                this.log.trace("Invalidated {} cookie.", (Object)"session_id");
                httpResponse.addHeader("Set-Cookie", "session_id=deleted; Path=/; Secure; HttpOnly; Expires=Thu, 01 Jan 1970 00:00:01 GMT;");
                this.log.trace("Invalidated {} cookie.", (Object)"consent_session_id");
                httpResponse.addHeader("Set-Cookie", "consent_session_id=deleted; Path=/; Secure; HttpOnly; Expires=Thu, 01 Jan 1970 00:00:01 GMT;");
                return true;
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private void processDeviceAuthDeniedResponse(Map<String, String> sessionAttribute) {
        String userCode = sessionAttribute.get("user_code");
        DeviceAuthorizationCacheControl cacheData = this.deviceAuthorizationService.getDeviceAuthzByUserCode(userCode);
        if (cacheData != null && cacheData.getStatus() == DeviceAuthorizationStatus.PENDING) {
            cacheData.setStatus(DeviceAuthorizationStatus.DENIED);
            this.deviceAuthorizationService.saveInCache(cacheData, true, false);
            this.deviceAuthorizationService.removeDeviceAuthRequestInCache(userCode, null);
        }
    }
}

