/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import com.codahale.metrics.Timer;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.ejb.Stateless;
import javax.faces.context.ExternalContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.gluu.jsf2.service.FacesService;
import org.gluu.model.GluuStatus;
import org.gluu.model.SimpleProperty;
import org.gluu.model.ldap.GluuLdapConfiguration;
import org.gluu.model.metric.MetricType;
import org.gluu.model.security.Credentials;
import org.gluu.model.security.SimplePrincipal;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.common.SimpleUser;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.session.SessionClient;
import org.gluu.oxauth.model.util.Util;
import org.gluu.oxauth.security.Identity;
import org.gluu.oxauth.service.AuthenticationProtectionService;
import org.gluu.oxauth.service.ClientService;
import org.gluu.oxauth.service.MetricService;
import org.gluu.oxauth.service.RequestParameterService;
import org.gluu.oxauth.service.SessionIdService;
import org.gluu.oxauth.service.common.UserService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.exception.AuthenticationException;
import org.gluu.persist.exception.EntryPersistenceException;
import org.gluu.persist.model.base.CustomAttribute;
import org.gluu.persist.model.base.CustomEntry;
import org.gluu.persist.model.base.CustomObjectAttribute;
import org.gluu.util.ArrayHelper;
import org.gluu.util.Pair;
import org.gluu.util.StringHelper;
import org.json.JSONException;
import org.slf4j.Logger;

@Stateless
@Named
public class AuthenticationService {
    private static final String AUTH_EXTERNAL_ATTRIBUTES = "auth_external_attributes";
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private Identity identity;
    @Inject
    private Credentials credentials;
    @Inject
    @Named(value="persistenceAuthConfig")
    private List<GluuLdapConfiguration> ldapAuthConfigs;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    @Named(value="persistenceAuthEntryManager")
    private List<PersistenceEntryManager> ldapAuthEntryManagers;
    @Inject
    private UserService userService;
    @Inject
    private ClientService clientService;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private MetricService metricService;
    @Inject
    private ExternalContext externalContext;
    @Inject
    private FacesService facesService;
    @Inject
    private RequestParameterService requestParameterService;
    @Inject
    private AuthenticationProtectionService authenticationProtectionService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(String userName, String password) {
        this.log.debug("Authenticating user with LDAP: username: '{}', credentials: '{}'", (Object)userName, (Object)System.identityHashCode(this.credentials));
        boolean authenticated = false;
        boolean protectionServiceEnabled = this.authenticationProtectionService.isEnabled();
        Timer.Context timerContext = null;
        timerContext = this.metricService.getTimer(MetricType.OXAUTH_USER_AUTHENTICATION_RATE).time();
        try {
            authenticated = this.ldapAuthConfigs == null || this.ldapAuthConfigs.size() == 0 ? this.localAuthenticate(userName, password) : this.externalAuthenticate(userName, password);
        }
        finally {
            timerContext.stop();
        }
        String userId = userName;
        if (this.identity.getUser() != null && StringHelper.isNotEmpty((String)this.identity.getUser().getUserId())) {
            userId = this.identity.getUser().getUserId();
        }
        this.setAuthenticatedUserSessionAttribute(userId, authenticated);
        MetricType metricType = authenticated ? MetricType.OXAUTH_USER_AUTHENTICATION_SUCCESS : MetricType.OXAUTH_USER_AUTHENTICATION_FAILURES;
        this.metricService.incCounter(metricType);
        if (protectionServiceEnabled) {
            this.authenticationProtectionService.storeAttempt(userId, authenticated);
            this.authenticationProtectionService.doDelayIfNeeded(userId);
        }
        return authenticated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(String nameValue, String password, String ... nameAttributes) {
        this.log.debug("Authenticating user with LDAP: nameValue: '{}', nameAttributes: '{}', credentials: '{}'", new Object[]{nameValue, ArrayHelper.toString((Object[])nameAttributes), System.identityHashCode(this.credentials)});
        Pair<Boolean, User> authenticatedPair = null;
        boolean authenticated = false;
        boolean protectionServiceEnabled = this.authenticationProtectionService.isEnabled();
        Timer.Context timerContext = this.metricService.getTimer(MetricType.OXAUTH_USER_AUTHENTICATION_RATE).time();
        try {
            authenticatedPair = this.localAuthenticate(nameValue, password, nameAttributes);
        }
        finally {
            timerContext.stop();
        }
        String userId = null;
        if (authenticatedPair != null && authenticatedPair.getSecond() != null) {
            authenticated = (Boolean)authenticatedPair.getFirst();
            userId = ((User)authenticatedPair.getSecond()).getUserId();
        }
        this.setAuthenticatedUserSessionAttribute(userId, authenticated);
        MetricType metricType = authenticated ? MetricType.OXAUTH_USER_AUTHENTICATION_SUCCESS : MetricType.OXAUTH_USER_AUTHENTICATION_FAILURES;
        this.metricService.incCounter(metricType);
        if (protectionServiceEnabled) {
            this.authenticationProtectionService.storeAttempt(userId, authenticated);
            this.authenticationProtectionService.doDelayIfNeeded(userId);
        }
        return authenticated;
    }

    private void setAuthenticatedUserSessionAttribute(String userName, boolean authenticated) {
        SessionId sessionId = this.sessionIdService.getSessionId();
        if (sessionId != null) {
            Map<String, String> sessionIdAttributes = sessionId.getSessionAttributes();
            if (authenticated) {
                sessionIdAttributes.put("auth_user", userName);
            }
            this.sessionIdService.updateSessionIdIfNeeded(sessionId, authenticated);
        }
    }

    private boolean localAuthenticate(String userName, String password) {
        User user = this.userService.getUser(userName, new String[0]);
        if (user != null) {
            boolean authenticated;
            block5: {
                if (!this.checkUserStatus(user)) {
                    return false;
                }
                authenticated = false;
                try {
                    authenticated = this.ldapEntryManager.authenticate(user.getDn(), password);
                }
                catch (AuthenticationException ex) {
                    this.log.error("Authentication failed: " + ex.getMessage());
                    if (!this.log.isDebugEnabled()) break block5;
                    this.log.debug("Authentication failed:", (Throwable)ex);
                }
            }
            if (authenticated) {
                this.configureAuthenticatedUser(user);
                this.updateLastLogonUserTime(user);
                this.log.trace("Authenticate: credentials: '{}', credentials.userName: '{}', authenticatedUser.userId: '{}'", new Object[]{System.identityHashCode(this.credentials), this.credentials.getUsername(), this.getAuthenticatedUserId()});
            }
            return authenticated;
        }
        return false;
    }

    private Pair<Boolean, User> localAuthenticate(String nameValue, String password, String ... nameAttributes) {
        String lowerNameValue = StringHelper.toString((Object)nameValue);
        User user = this.userService.getUserByAttributes((Object)lowerNameValue, nameAttributes, new String[]{"uid", "gluuStatus"});
        if (user != null) {
            if (!this.checkUserStatus(user)) {
                return new Pair((Object)false, (Object)user);
            }
            boolean authenticated = this.ldapEntryManager.authenticate(user.getDn(), password);
            if (authenticated) {
                this.configureAuthenticatedUser(user);
                this.updateLastLogonUserTime(user);
                this.log.trace("Authenticate: credentials: '{}', credentials.userName: '{}', authenticatedUser.userId: '{}'", new Object[]{System.identityHashCode(this.credentials), this.credentials.getUsername(), this.getAuthenticatedUserId()});
            }
            return new Pair((Object)authenticated, (Object)user);
        }
        return new Pair((Object)false, null);
    }

    private boolean externalAuthenticate(String keyValue, String password) {
        for (int i = 0; i < this.ldapAuthConfigs.size(); ++i) {
            boolean authenticated;
            GluuLdapConfiguration ldapAuthConfig = this.ldapAuthConfigs.get(i);
            PersistenceEntryManager ldapAuthEntryManager = this.ldapAuthEntryManagers.get(i);
            String primaryKey = "uid";
            if (StringHelper.isNotEmpty((String)ldapAuthConfig.getPrimaryKey())) {
                primaryKey = ldapAuthConfig.getPrimaryKey();
            }
            String localPrimaryKey = "uid";
            if (StringHelper.isNotEmpty((String)ldapAuthConfig.getLocalPrimaryKey())) {
                localPrimaryKey = ldapAuthConfig.getLocalPrimaryKey();
            }
            if (!(authenticated = this.authenticate(ldapAuthConfig, ldapAuthEntryManager, keyValue, password, primaryKey, localPrimaryKey, false))) continue;
            return authenticated;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(String keyValue, String password, String primaryKey, String localPrimaryKey) {
        if (this.ldapAuthConfigs == null) {
            return this.authenticate(null, this.ldapEntryManager, keyValue, password, primaryKey, localPrimaryKey);
        }
        boolean authenticated = false;
        boolean protectionServiceEnabled = this.authenticationProtectionService.isEnabled();
        Timer.Context timerContext = this.metricService.getTimer(MetricType.OXAUTH_USER_AUTHENTICATION_RATE).time();
        try {
            for (int i = 0; i < this.ldapAuthConfigs.size(); ++i) {
                PersistenceEntryManager ldapAuthEntryManager;
                GluuLdapConfiguration ldapAuthConfig = this.ldapAuthConfigs.get(i);
                authenticated = this.authenticate(ldapAuthConfig, ldapAuthEntryManager = this.ldapAuthEntryManagers.get(i), keyValue, password, primaryKey, localPrimaryKey, false);
                if (!authenticated) continue;
                break;
            }
        }
        finally {
            timerContext.stop();
        }
        String userId = null;
        if (this.identity.getUser() != null && StringHelper.isNotEmpty((String)this.identity.getUser().getUserId())) {
            userId = this.identity.getUser().getUserId();
        }
        this.setAuthenticatedUserSessionAttribute(userId, authenticated);
        MetricType metricType = authenticated ? MetricType.OXAUTH_USER_AUTHENTICATION_SUCCESS : MetricType.OXAUTH_USER_AUTHENTICATION_FAILURES;
        this.metricService.incCounter(metricType);
        if (protectionServiceEnabled) {
            this.authenticationProtectionService.storeAttempt(keyValue, authenticated);
            this.authenticationProtectionService.doDelayIfNeeded(keyValue);
        }
        return authenticated;
    }

    public boolean authenticate(GluuLdapConfiguration ldapAuthConfig, PersistenceEntryManager ldapAuthEntryManager, String keyValue, String password, String primaryKey, String localPrimaryKey) {
        return this.authenticate(ldapAuthConfig, ldapAuthEntryManager, keyValue, password, primaryKey, localPrimaryKey, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(GluuLdapConfiguration ldapAuthConfig, PersistenceEntryManager ldapAuthEntryManager, String keyValue, String password, String primaryKey, String localPrimaryKey, boolean updateMetrics) {
        boolean authenticated = false;
        boolean protectionServiceEnabled = this.authenticationProtectionService.isEnabled();
        Timer.Context timerContext = null;
        if (updateMetrics) {
            timerContext = this.metricService.getTimer(MetricType.OXAUTH_USER_AUTHENTICATION_RATE).time();
        }
        try {
            authenticated = this.authenticateImpl(ldapAuthConfig, ldapAuthEntryManager, keyValue, password, primaryKey, localPrimaryKey);
        }
        finally {
            if (updateMetrics) {
                timerContext.stop();
            }
        }
        String userId = keyValue;
        if (this.identity.getUser() != null && StringHelper.isNotEmpty((String)this.identity.getUser().getUserId())) {
            userId = this.identity.getUser().getUserId();
        }
        this.setAuthenticatedUserSessionAttribute(userId, authenticated);
        if (updateMetrics) {
            MetricType metricType = authenticated ? MetricType.OXAUTH_USER_AUTHENTICATION_SUCCESS : MetricType.OXAUTH_USER_AUTHENTICATION_FAILURES;
            this.metricService.incCounter(metricType);
        }
        if (protectionServiceEnabled) {
            this.authenticationProtectionService.storeAttempt(userId, authenticated);
            this.authenticationProtectionService.doDelayIfNeeded(userId);
        }
        return authenticated;
    }

    private boolean authenticateImpl(GluuLdapConfiguration ldapAuthConfig, PersistenceEntryManager ldapAuthEntryManager, String keyValue, String password, String primaryKey, String localPrimaryKey) {
        this.log.debug("Attempting to find userDN by primary key: '{}' and key value: '{}', credentials: '{}'", new Object[]{primaryKey, keyValue, System.identityHashCode(this.credentials)});
        try {
            List<String> baseDNs = ldapAuthConfig == null ? Arrays.asList(this.userService.getDnForUser(null)) : ldapAuthConfig.getBaseDNs();
            if (baseDNs != null && !baseDNs.isEmpty()) {
                for (Object e : baseDNs) {
                    String baseDn = e instanceof SimpleProperty ? ((SimpleProperty)e).getValue() : e.toString();
                    User user = this.getUserByAttribute(ldapAuthEntryManager, baseDn, primaryKey, keyValue);
                    if (user == null) continue;
                    String userDn = user.getDn();
                    this.log.debug("Attempting to authenticate userDN: {}", (Object)userDn);
                    if (!ldapAuthEntryManager.authenticate(userDn, password)) continue;
                    this.log.debug("User authenticated: {}", (Object)userDn);
                    this.log.debug("Attempting to find userDN by local primary key: {}", (Object)localPrimaryKey);
                    User localUser = this.userService.getUserByAttribute(localPrimaryKey, (Object)keyValue);
                    if (localUser == null) continue;
                    if (!this.checkUserStatus(localUser)) {
                        return false;
                    }
                    this.configureAuthenticatedUser(localUser);
                    this.updateLastLogonUserTime(localUser);
                    this.log.trace("authenticate_external: credentials: '{}', credentials.userName: '{}', authenticatedUser.userId: '{}'", new Object[]{System.identityHashCode(this.credentials), this.credentials.getUsername(), this.getAuthenticatedUserId()});
                    return true;
                }
            } else {
                this.log.error("There are no baseDns specified in authentication configuration.");
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(String userName) {
        this.log.debug("Authenticating user with LDAP: username: '{}', credentials: '{}'", (Object)userName, (Object)System.identityHashCode(this.credentials));
        boolean authenticated = false;
        boolean protectionServiceEnabled = this.authenticationProtectionService.isEnabled();
        Timer.Context timerContext = this.metricService.getTimer(MetricType.OXAUTH_USER_AUTHENTICATION_RATE).time();
        try {
            User user = this.userService.getUser(userName, new String[0]);
            if (user != null && this.checkUserStatus(user)) {
                this.credentials.setUsername(user.getUserId());
                this.configureAuthenticatedUser(user);
                this.updateLastLogonUserTime(user);
                this.log.trace("Authenticate: credentials: '{}', credentials.userName: '{}', authenticatedUser.userId: '{}'", new Object[]{System.identityHashCode(this.credentials), this.credentials.getUsername(), this.getAuthenticatedUserId()});
                authenticated = true;
            }
        }
        finally {
            timerContext.stop();
        }
        this.setAuthenticatedUserSessionAttribute(userName, authenticated);
        MetricType metricType = authenticated ? MetricType.OXAUTH_USER_AUTHENTICATION_SUCCESS : MetricType.OXAUTH_USER_AUTHENTICATION_FAILURES;
        this.metricService.incCounter(metricType);
        if (protectionServiceEnabled) {
            this.authenticationProtectionService.storeAttempt(userName, authenticated);
            this.authenticationProtectionService.doDelayIfNeeded(userName);
        }
        return authenticated;
    }

    private User getUserByAttribute(PersistenceEntryManager ldapAuthEntryManager, String baseDn, String attributeName, String attributeValue) {
        this.log.debug("Getting user information from LDAP: attributeName = '{}', attributeValue = '{}'", (Object)attributeName, (Object)attributeValue);
        if (StringHelper.isEmpty((String)attributeValue)) {
            return null;
        }
        SimpleUser sampleUser = new SimpleUser();
        sampleUser.setDn(baseDn);
        ArrayList<CustomObjectAttribute> customAttributes = new ArrayList<CustomObjectAttribute>();
        customAttributes.add(new CustomObjectAttribute(attributeName, (Object)attributeValue));
        sampleUser.setCustomAttributes(customAttributes);
        this.log.debug("Searching user by attributes: '{}', baseDn: '{}'", customAttributes, (Object)baseDn);
        List entries = ldapAuthEntryManager.findEntries((Object)sampleUser, 1);
        this.log.debug("Found '{}' entries", (Object)entries.size());
        if (entries.size() > 0) {
            SimpleUser foundUser = (SimpleUser)entries.get(0);
            return (User)ldapAuthEntryManager.find(User.class, (Object)foundUser.getDn());
        }
        return null;
    }

    private boolean checkUserStatus(User user) {
        CustomObjectAttribute userStatus = this.userService.getCustomAttribute(user, "gluuStatus");
        if (userStatus != null && GluuStatus.ACTIVE.equals((Object)GluuStatus.getByValue((String)StringHelper.toString((Object)userStatus.getValue())))) {
            return true;
        }
        this.log.warn("User '{}' was disabled", (Object)user.getUserId());
        return false;
    }

    private void updateLastLogonUserTime(User user) {
        if (!this.appConfiguration.getUpdateUserLastLogonTime().booleanValue()) {
            return;
        }
        CustomEntry customEntry = new CustomEntry();
        customEntry.setDn(user.getDn());
        List personCustomObjectClassList = this.appConfiguration.getPersonCustomObjectClassList();
        if (personCustomObjectClassList != null && !personCustomObjectClassList.isEmpty()) {
            HashSet<String> customPersonCustomObjectClassList = new HashSet<String>();
            customPersonCustomObjectClassList.add("gluuPerson");
            customPersonCustomObjectClassList.addAll(personCustomObjectClassList);
            if (user.getCustomObjectClasses() != null) {
                customPersonCustomObjectClassList.addAll(Arrays.asList(user.getCustomObjectClasses()));
            }
            customEntry.setCustomObjectClasses(customPersonCustomObjectClassList.toArray(new String[customPersonCustomObjectClassList.size()]));
        } else {
            customEntry.setCustomObjectClasses(UserService.USER_OBJECT_CLASSES);
        }
        Date now = new GregorianCalendar(TimeZone.getTimeZone("UTC")).getTime();
        String nowDateString = this.ldapEntryManager.encodeTime(customEntry.getDn(), now);
        CustomAttribute customAttribute = new CustomAttribute("oxLastLogonTime", nowDateString);
        customEntry.getCustomAttributes().add(customAttribute);
        try {
            this.ldapEntryManager.merge((Object)customEntry);
        }
        catch (EntryPersistenceException epe) {
            this.log.error("Failed to update oxLastLogonTime of user '{}'", (Object)user.getUserId());
        }
    }

    public SessionId configureSessionUser(SessionId sessionId, Map<String, String> sessionIdAttributes) {
        this.log.trace("configureSessionUser: credentials: '{}', sessionId: '{}', credentials.userName: '{}', authenticatedUser.userId: '{}'", new Object[]{System.identityHashCode(this.credentials), sessionId, this.credentials.getUsername(), this.getAuthenticatedUserId()});
        User user = this.getAuthenticatedUser();
        String sessionAuthUser = sessionIdAttributes.get("auth_user");
        this.log.trace("configureSessionUser sessionId: '{}', sessionId.auth_user: '{}'", (Object)sessionId, (Object)sessionAuthUser);
        SessionId newSessionId = this.sessionIdService.setSessionIdStateAuthenticated(this.getHttpRequest(), this.getHttpResponse(), sessionId, user.getDn());
        this.identity.setSessionId(sessionId);
        newSessionId.setUser(user);
        return newSessionId;
    }

    public SessionId configureEventUser() {
        User user = this.getAuthenticatedUser();
        if (user == null) {
            return null;
        }
        this.log.debug("ConfigureEventUser: username: '{}', credentials: '{}'", (Object)user.getUserId(), (Object)System.identityHashCode(this.credentials));
        SessionId sessionId = this.sessionIdService.generateAuthenticatedSessionId(this.getHttpRequest(), user.getDn());
        this.identity.setSessionId(sessionId);
        return sessionId;
    }

    private HttpServletRequest getHttpRequest() {
        if (this.externalContext == null) {
            return null;
        }
        return (HttpServletRequest)this.externalContext.getRequest();
    }

    private HttpServletResponse getHttpResponse() {
        if (this.externalContext == null) {
            return null;
        }
        return (HttpServletResponse)this.externalContext.getResponse();
    }

    public void configureEventUser(SessionId sessionId) {
        this.sessionIdService.updateSessionId(sessionId);
        this.identity.setSessionId(sessionId);
    }

    public void quietLogin(String userName) {
        SimplePrincipal principal = new SimplePrincipal(userName);
        this.identity.acceptExternallyAuthenticatedPrincipal((Principal)principal);
        this.identity.quietLogin();
    }

    private void configureAuthenticatedUser(User user) {
        this.identity.setUser(user);
    }

    public User getAuthenticatedUser() {
        Map<String, String> sessionIdAttributes;
        String userId;
        if (this.identity.getUser() != null) {
            return this.identity.getUser();
        }
        SessionId sessionId = this.sessionIdService.getSessionId();
        if (sessionId != null && StringHelper.isNotEmpty((String)(userId = (sessionIdAttributes = sessionId.getSessionAttributes()).get("auth_user")))) {
            User user = this.userService.getUser(userId, new String[0]);
            this.identity.setUser(user);
            return user;
        }
        return null;
    }

    public String getAuthenticatedUserId() {
        User authenticatedUser = this.getAuthenticatedUser();
        if (authenticatedUser != null) {
            return authenticatedUser.getUserId();
        }
        return null;
    }

    public Client configureSessionClient() {
        String clientInum = this.credentials.getUsername();
        this.log.debug("ConfigureSessionClient: username: '{}', credentials: '{}'", (Object)clientInum, (Object)System.identityHashCode(this.credentials));
        Client client = this.clientService.getClient(clientInum);
        this.configureSessionClient(client);
        return client;
    }

    public void configureSessionClient(Client client) {
        SessionClient sessionClient = new SessionClient();
        sessionClient.setClient(client);
        this.identity.setSessionClient(sessionClient);
        this.clientService.updateAccessTime(client, true);
    }

    public void onSuccessfulLogin(SessionId sessionUser) {
        this.log.info("Attempting to redirect user: SessionUser: {}", (Object)sessionUser);
        if (sessionUser == null || StringUtils.isBlank((String)sessionUser.getUserDn())) {
            return;
        }
        User user = this.sessionIdService.getUser(sessionUser);
        this.log.info("Attempting to redirect user: User: {}", (Object)user);
        if (user == null) {
            this.log.error("Failed to identify logged in user for session: {}", (Object)sessionUser);
            return;
        }
        Map<String, String> result = sessionUser.getSessionAttributes();
        Map<String, String> allowedParameters = this.requestParameterService.getAllowedParameters(result);
        result.put("session_id", sessionUser.getId());
        this.log.trace("Logged in successfully! User: {}, page: /authorize.xhtml, map: {}", (Object)user, allowedParameters);
        this.facesService.redirect("/authorize.xhtml", allowedParameters);
    }

    public User getUserOrRemoveSession(SessionId p_sessionId) {
        if (p_sessionId != null) {
            try {
                if (StringUtils.isNotBlank((String)p_sessionId.getUserDn())) {
                    User user = this.sessionIdService.getUser(p_sessionId);
                    if (user != null) {
                        return user;
                    }
                    this.sessionIdService.remove(p_sessionId);
                } else {
                    this.sessionIdService.remove(p_sessionId);
                }
            }
            catch (Exception e) {
                this.log.trace(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public String parametersAsString() throws UnsupportedEncodingException {
        Map<String, String> parameterMap = this.getParametersMap(null);
        return this.requestParameterService.parametersAsString(parameterMap);
    }

    public Map<String, String> getParametersMap(List<String> extraParameters) {
        HashMap<String, String> parameterMap = new HashMap<String, String>(this.externalContext.getRequestParameterMap());
        return this.requestParameterService.getParametersMap(extraParameters, parameterMap);
    }

    public boolean isParameterExists(String p_name) {
        return this.identity.isSetWorkingParameter(p_name);
    }

    public void updateExtraParameters(Map<String, String> sessionIdAttributes, List<String> extraParameters) {
        Map<String, String> authExternalAttributes = this.getExternalScriptExtraParameters(sessionIdAttributes);
        if (extraParameters != null) {
            this.log.trace("Attempting to store extraParameters: {}", extraParameters);
            for (String extraParameter : extraParameters) {
                if (!this.isParameterExists(extraParameter)) continue;
                Pair<String, String> extraParameterValueWithType = this.requestParameterService.getParameterValueWithType(extraParameter);
                String extraParameterValue = (String)extraParameterValueWithType.getFirst();
                String extraParameterType = (String)extraParameterValueWithType.getSecond();
                sessionIdAttributes.put(extraParameter, extraParameterValue);
                authExternalAttributes.put(extraParameter, extraParameterType);
            }
        }
        this.setExternalScriptExtraParameters(sessionIdAttributes, authExternalAttributes);
        this.log.trace("Storing sessionIdAttributes: {}", sessionIdAttributes);
        this.log.trace("Storing authExternalAttributes: {}", authExternalAttributes);
    }

    public Map<String, String> getExternalScriptExtraParameters(Map<String, String> sessionIdAttributes) {
        String authExternalAttributesString = sessionIdAttributes.get(AUTH_EXTERNAL_ATTRIBUTES);
        HashMap<String, String> authExternalAttributes = new HashMap();
        try {
            authExternalAttributes = Util.jsonObjectArrayStringAsMap((String)authExternalAttributesString);
        }
        catch (JSONException ex) {
            this.log.error("Failed to convert JSON array of auth_external_attributes to Map<String, String>");
        }
        return authExternalAttributes;
    }

    public void setExternalScriptExtraParameters(Map<String, String> sessionIdAttributes, Map<String, String> authExternalAttributes) {
        String authExternalAttributesString = null;
        try {
            authExternalAttributesString = Util.mapAsString(authExternalAttributes);
        }
        catch (JSONException ex) {
            this.log.error("Failed to convert Map<String, String> of auth_external_attributes to JSON array");
        }
        sessionIdAttributes.put(AUTH_EXTERNAL_ATTRIBUTES, authExternalAttributesString);
    }

    public void clearExternalScriptExtraParameters(Map<String, String> sessionIdAttributes) {
        Map<String, String> authExternalAttributes = this.getExternalScriptExtraParameters(sessionIdAttributes);
        for (String authExternalAttribute : authExternalAttributes.keySet()) {
            sessionIdAttributes.remove(authExternalAttribute);
        }
        sessionIdAttributes.remove(AUTH_EXTERNAL_ATTRIBUTES);
    }

    public void copyAuthenticatorExternalAttributes(SessionId oldSession, SessionId newSession) {
        if (oldSession != null && oldSession.getSessionAttributes() != null && newSession != null && newSession.getSessionAttributes() != null) {
            Map<String, String> newSessionIdAttributes = newSession.getSessionAttributes();
            Map<String, String> oldSessionIdAttributes = oldSession.getSessionAttributes();
            Map<String, String> authExternalAttributes = this.getExternalScriptExtraParameters(oldSession.getSessionAttributes());
            if (authExternalAttributes != null) {
                this.log.trace("Attempting to copy extraParameters into new session: {}", authExternalAttributes);
                for (String authExternalAttributeName : authExternalAttributes.keySet()) {
                    if (!oldSessionIdAttributes.containsKey(authExternalAttributeName)) continue;
                    String authExternalAttributeValue = oldSessionIdAttributes.get(authExternalAttributeName);
                    newSessionIdAttributes.put(authExternalAttributeName, authExternalAttributeValue);
                }
            }
            this.setExternalScriptExtraParameters(newSessionIdAttributes, authExternalAttributes);
        }
    }
}

