/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.token;

import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.jwk.Algorithm;
import org.gluu.oxauth.model.jwk.JSONWebKeySet;
import org.gluu.oxauth.model.jwk.Use;
import org.gluu.oxauth.model.jwt.Jwt;
import org.gluu.oxauth.model.jwt.JwtType;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.service.ClientService;
import org.gluu.oxauth.service.ServerCryptoProvider;
import org.gluu.service.cdi.util.CdiUtil;
import org.python.jline.internal.Preconditions;

public class JwtSigner {
    private AbstractCryptoProvider cryptoProvider;
    private SignatureAlgorithm signatureAlgorithm;
    private String audience;
    private String hmacSharedSecret;
    private AppConfiguration appConfiguration;
    private JSONWebKeySet webKeys;
    private Jwt jwt;

    public JwtSigner(AppConfiguration appConfiguration, JSONWebKeySet webKeys, SignatureAlgorithm signatureAlgorithm, String audience) throws Exception {
        this(appConfiguration, webKeys, signatureAlgorithm, audience, null);
    }

    public JwtSigner(AppConfiguration appConfiguration, JSONWebKeySet webKeys, SignatureAlgorithm signatureAlgorithm, String audience, String hmacSharedSecret) throws Exception {
        this.appConfiguration = appConfiguration;
        this.webKeys = webKeys;
        this.signatureAlgorithm = signatureAlgorithm;
        this.audience = audience;
        this.hmacSharedSecret = hmacSharedSecret;
        this.cryptoProvider = new ServerCryptoProvider((AbstractCryptoProvider)CdiUtil.bean(AbstractCryptoProvider.class));
    }

    public static JwtSigner newJwtSigner(AppConfiguration appConfiguration, JSONWebKeySet webKeys, Client client) throws Exception {
        Preconditions.checkNotNull((Object)client);
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.fromString((String)appConfiguration.getDefaultSignatureAlgorithm());
        if (client.getIdTokenSignedResponseAlg() != null) {
            signatureAlgorithm = SignatureAlgorithm.fromString((String)client.getIdTokenSignedResponseAlg());
        }
        ClientService clientService = (ClientService)CdiUtil.bean(ClientService.class);
        return new JwtSigner(appConfiguration, webKeys, signatureAlgorithm, client.getClientId(), clientService.decryptSecret(client.getClientSecret()));
    }

    public Jwt newJwt() throws Exception {
        this.jwt = new Jwt();
        String keyId = this.cryptoProvider.getKeyId(this.webKeys, Algorithm.fromString((String)this.signatureAlgorithm.getName()), Use.SIGNATURE);
        if (keyId != null) {
            this.jwt.getHeader().setKeyId(keyId);
        }
        this.jwt.getHeader().setType(JwtType.JWT);
        this.jwt.getHeader().setAlgorithm(this.signatureAlgorithm);
        this.jwt.getClaims().setIssuer(this.appConfiguration.getIssuer());
        this.jwt.getClaims().setAudience(this.audience);
        return this.jwt;
    }

    public Jwt sign() throws Exception {
        String signature = this.cryptoProvider.sign(this.jwt.getSigningInput(), this.jwt.getHeader().getKeyId(), this.hmacSharedSecret, this.signatureAlgorithm);
        this.jwt.setEncodedSignature(signature);
        return this.jwt;
    }

    public Jwt getJwt() {
        return this.jwt;
    }

    public void setJwt(Jwt jwt) {
        this.jwt = jwt;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setCryptoProvider(AbstractCryptoProvider cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
    }
}

