/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.token;

import com.google.common.base.Function;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.common.IAuthorizationGrant;
import org.gluu.oxauth.model.config.WebKeysConfiguration;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.gluu.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.gluu.oxauth.model.exception.InvalidJweException;
import org.gluu.oxauth.model.jwe.Jwe;
import org.gluu.oxauth.model.jwe.JweEncrypterImpl;
import org.gluu.oxauth.model.jwk.Algorithm;
import org.gluu.oxauth.model.jwk.JSONWebKeySet;
import org.gluu.oxauth.model.jwk.Use;
import org.gluu.oxauth.model.jwt.Jwt;
import org.gluu.oxauth.model.jwt.JwtType;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.token.JsonWebResponse;
import org.gluu.oxauth.model.token.JwtSigner;
import org.gluu.oxauth.model.util.JwtUtil;
import org.gluu.oxauth.service.ClientService;
import org.gluu.oxauth.service.SectorIdentifierService;
import org.gluu.oxauth.service.ServerCryptoProvider;
import org.json.JSONObject;
import org.slf4j.Logger;

@Stateless
@Named
public class JwrService {
    @Inject
    private Logger log;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    @Inject
    private ClientService clientService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private WebKeysConfiguration webKeysConfiguration;
    @Inject
    private SectorIdentifierService sectorIdentifierService;

    public JsonWebResponse encode(JsonWebResponse jwr, Client client) throws Exception {
        if (jwr instanceof Jwe) {
            return this.encryptJwe((Jwe)jwr, client);
        }
        if (jwr instanceof Jwt) {
            return this.signJwt((Jwt)jwr, client);
        }
        throw new IllegalArgumentException("Unknown Jwr instance.");
    }

    private Jwt signJwt(Jwt jwt, Client client) throws Exception {
        JwtSigner jwtSigner = JwtSigner.newJwtSigner(this.appConfiguration, this.webKeysConfiguration, client);
        jwtSigner.setJwt(jwt);
        jwtSigner.sign();
        return jwt;
    }

    private Jwe encryptJwe(Jwe jwe, Client client) throws Exception {
        KeyEncryptionAlgorithm keyEncryptionAlgorithm = KeyEncryptionAlgorithm.fromName((String)jwe.getHeader().getClaimAsString("alg"));
        BlockEncryptionAlgorithm encryptionMethod = jwe.getHeader().getEncryptionMethod();
        if (keyEncryptionAlgorithm == KeyEncryptionAlgorithm.RSA_OAEP || keyEncryptionAlgorithm == KeyEncryptionAlgorithm.RSA1_5) {
            JSONObject jsonWebKeys = JwtUtil.getJSONWebKeys((String)client.getJwksUri());
            String keyId = new ServerCryptoProvider(this.cryptoProvider).getKeyId(JSONWebKeySet.fromJSONObject((JSONObject)jsonWebKeys), Algorithm.fromString((String)keyEncryptionAlgorithm.getName()), Use.ENCRYPTION);
            PublicKey publicKey = this.cryptoProvider.getPublicKey(keyId, jsonWebKeys, null);
            jwe.getHeader().setKeyId(keyId);
            if (publicKey == null) {
                throw new InvalidJweException("The public key is not valid");
            }
            JweEncrypterImpl jweEncrypter = new JweEncrypterImpl(keyEncryptionAlgorithm, encryptionMethod, publicKey);
            return jweEncrypter.encrypt(jwe);
        }
        if (keyEncryptionAlgorithm == KeyEncryptionAlgorithm.A128KW || keyEncryptionAlgorithm == KeyEncryptionAlgorithm.A256KW) {
            byte[] sharedSymmetricKey = this.clientService.decryptSecret(client.getClientSecret()).getBytes(StandardCharsets.UTF_8);
            JweEncrypterImpl jweEncrypter = new JweEncrypterImpl(keyEncryptionAlgorithm, encryptionMethod, sharedSymmetricKey);
            return jweEncrypter.encrypt(jwe);
        }
        throw new IllegalArgumentException("Unsupported encryption algorithm: " + keyEncryptionAlgorithm);
    }

    public JsonWebResponse createJwr(Client client) {
        try {
            if (client.getIdTokenEncryptedResponseAlg() != null && client.getIdTokenEncryptedResponseEnc() != null) {
                Jwe jwe = new Jwe();
                KeyEncryptionAlgorithm keyEncryptionAlgorithm = KeyEncryptionAlgorithm.fromName((String)client.getIdTokenEncryptedResponseAlg());
                BlockEncryptionAlgorithm blockEncryptionAlgorithm = BlockEncryptionAlgorithm.fromName((String)client.getIdTokenEncryptedResponseEnc());
                jwe.getHeader().setType(JwtType.JWT);
                jwe.getHeader().setAlgorithm(keyEncryptionAlgorithm);
                jwe.getHeader().setEncryptionMethod(blockEncryptionAlgorithm);
                return jwe;
            }
            JwtSigner jwtSigner = JwtSigner.newJwtSigner(this.appConfiguration, this.webKeysConfiguration, client);
            return jwtSigner.newJwt();
        }
        catch (Exception e) {
            this.log.error("Failed to create logout_token.", (Throwable)e);
            return null;
        }
    }

    public void setSubjectIdentifier(JsonWebResponse jwr, IAuthorizationGrant authorizationGrant) {
        jwr.getClaims().setSubjectIdentifier(authorizationGrant.getSub());
    }

    public static Function<JsonWebResponse, Void> wrapWithSidFunction(Function<JsonWebResponse, Void> input, String outsideSid) {
        return jwr -> {
            if (jwr == null) {
                return null;
            }
            if (input != null) {
                input.apply(jwr);
            }
            if (StringUtils.isNotEmpty((String)outsideSid)) {
                jwr.setClaim("sid", outsideSid);
            }
            return null;
        };
    }
}

