/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.token;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.gluu.model.GluuAttribute;
import org.gluu.model.attribute.AttributeDataType;
import org.gluu.model.custom.script.conf.CustomScriptConfiguration;
import org.gluu.model.custom.script.type.auth.PersonAuthenticationType;
import org.gluu.oxauth.claims.Audience;
import org.gluu.oxauth.model.authorize.Claim;
import org.gluu.oxauth.model.authorize.JwtAuthorizationRequest;
import org.gluu.oxauth.model.common.AbstractToken;
import org.gluu.oxauth.model.common.AccessToken;
import org.gluu.oxauth.model.common.AuthorizationCode;
import org.gluu.oxauth.model.common.CIBAGrant;
import org.gluu.oxauth.model.common.IAuthorizationGrant;
import org.gluu.oxauth.model.common.RefreshToken;
import org.gluu.oxauth.model.common.ScopeType;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.common.UnmodifiableAuthorizationGrant;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.exception.InvalidClaimException;
import org.gluu.oxauth.model.jwt.JwtClaims;
import org.gluu.oxauth.model.jwt.JwtSubClaimObject;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.token.JsonWebResponse;
import org.gluu.oxauth.model.token.JwrService;
import org.gluu.oxauth.service.AttributeService;
import org.gluu.oxauth.service.ScopeService;
import org.gluu.oxauth.service.SessionIdService;
import org.gluu.oxauth.service.external.ExternalAuthenticationService;
import org.gluu.oxauth.service.external.ExternalDynamicScopeService;
import org.gluu.oxauth.service.external.context.DynamicScopeExternalContext;
import org.json.JSONArray;
import org.oxauth.persistence.model.Scope;

@Stateless
@Named
public class IdTokenFactory {
    @Inject
    private ExternalDynamicScopeService externalDynamicScopeService;
    @Inject
    private ExternalAuthenticationService externalAuthenticationService;
    @Inject
    private ScopeService scopeService;
    @Inject
    private AttributeService attributeService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private JwrService jwrService;
    @Inject
    private SessionIdService sessionIdService;

    private void setAmrClaim(JsonWebResponse jwt, String acrValues) {
        ArrayList amrList = Lists.newArrayList();
        CustomScriptConfiguration script = this.externalAuthenticationService.getCustomScriptConfigurationByName(acrValues);
        if (script != null) {
            Map authenticationMethodClaimsOrNull;
            amrList.add(Integer.toString(script.getLevel()));
            PersonAuthenticationType externalAuthenticator = (PersonAuthenticationType)script.getExternalType();
            int apiVersion = externalAuthenticator.getApiVersion();
            if (apiVersion > 3 && (authenticationMethodClaimsOrNull = externalAuthenticator.getAuthenticationMethodClaims(script.getConfigurationAttributes())) != null) {
                for (String key : authenticationMethodClaimsOrNull.keySet()) {
                    amrList.add(key + ":" + (String)authenticationMethodClaimsOrNull.get(key));
                }
            }
        }
        jwt.getClaims().setClaim("amr", (List)amrList);
    }

    private void fillClaims(JsonWebResponse jwr, IAuthorizationGrant authorizationGrant, String nonce, AuthorizationCode authorizationCode, AccessToken accessToken, RefreshToken refreshToken, String state, Set<String> scopes, boolean includeIdTokenClaims, Function<JsonWebResponse, Void> preProcessing) throws Exception {
        SessionId session;
        jwr.getClaims().setIssuer(this.appConfiguration.getIssuer());
        Audience.setAudience((JwtClaims)jwr.getClaims(), (Client)authorizationGrant.getClient());
        int lifeTime = this.appConfiguration.getIdTokenLifetime();
        Calendar calendar = Calendar.getInstance();
        Date issuedAt = calendar.getTime();
        calendar.add(13, lifeTime);
        Date expiration = calendar.getTime();
        jwr.getClaims().setExpirationTime(expiration);
        jwr.getClaims().setIssuedAt(issuedAt);
        if (preProcessing != null) {
            preProcessing.apply((Object)jwr);
        }
        if ((session = this.sessionIdService.getSessionByDn(authorizationGrant.getSessionDn())) != null) {
            jwr.setClaim("sid", session.getOutsideSid());
        }
        if (authorizationGrant.getAcrValues() != null) {
            jwr.setClaim("acr", authorizationGrant.getAcrValues());
            this.setAmrClaim(jwr, authorizationGrant.getAcrValues());
        }
        if (StringUtils.isNotBlank((String)nonce)) {
            jwr.setClaim("nonce", nonce);
        }
        if (authorizationGrant.getAuthenticationTime() != null) {
            jwr.getClaims().setClaim("auth_time", authorizationGrant.getAuthenticationTime());
        }
        if (authorizationCode != null) {
            String codeHash = AbstractToken.getHash(authorizationCode.getCode(), jwr.getHeader().getSignatureAlgorithm());
            jwr.setClaim("c_hash", codeHash);
        }
        if (accessToken != null) {
            String accessTokenHash = AbstractToken.getHash(accessToken.getCode(), jwr.getHeader().getSignatureAlgorithm());
            jwr.setClaim("at_hash", accessTokenHash);
        }
        if (Strings.isNotBlank((String)state)) {
            String stateHash = AbstractToken.getHash(state, jwr.getHeader().getSignatureAlgorithm());
            jwr.setClaim("s_hash", stateHash);
        }
        jwr.setClaim("oxOpenIDConnectVersion", this.appConfiguration.getOxOpenIdConnectVersion());
        User user = authorizationGrant.getUser();
        ArrayList<Scope> dynamicScopes = new ArrayList<Scope>();
        if (includeIdTokenClaims && authorizationGrant.getClient().isIncludeClaimsInIdToken()) {
            for (String scopeName : scopes) {
                Scope scope = this.scopeService.getScopeById(scopeName);
                if (scope == null) continue;
                if (ScopeType.DYNAMIC == scope.getScopeType()) {
                    dynamicScopes.add(scope);
                    continue;
                }
                Map<String, Object> claims = this.getClaims(user, scope);
                if (Boolean.TRUE.equals(scope.isOxAuthGroupClaims())) {
                    JwtSubClaimObject groupClaim = new JwtSubClaimObject();
                    groupClaim.setName(scope.getId());
                    for (Map.Entry<String, Object> entry : claims.entrySet()) {
                        String key = entry.getKey();
                        Object value = entry.getValue();
                        if (value instanceof List) {
                            groupClaim.setClaim(key, (List)value);
                            continue;
                        }
                        groupClaim.setClaim(key, (String)value);
                    }
                    jwr.getClaims().setClaim(scope.getId(), groupClaim);
                } else {
                    for (Map.Entry<String, Object> entry : claims.entrySet()) {
                        String key = entry.getKey();
                        Object value = entry.getValue();
                        if (value instanceof List) {
                            jwr.getClaims().setClaim(key, (List)value);
                            continue;
                        }
                        if (value instanceof Boolean) {
                            jwr.getClaims().setClaim(key, (Boolean)value);
                            continue;
                        }
                        if (value instanceof Date) {
                            jwr.getClaims().setClaim(key, Long.valueOf(((Date)value).getTime()));
                            continue;
                        }
                        jwr.setClaim(key, (String)value);
                    }
                }
                jwr.getClaims().setSubjectIdentifier(authorizationGrant.getUser().getAttribute("inum"));
            }
        }
        this.setClaimsFromJwtAuthorizationRequest(jwr, authorizationGrant, scopes);
        this.jwrService.setSubjectIdentifier(jwr, authorizationGrant);
        if (dynamicScopes.size() > 0 && this.externalDynamicScopeService.isEnabled()) {
            UnmodifiableAuthorizationGrant unmodifiableAuthorizationGrant = new UnmodifiableAuthorizationGrant(authorizationGrant);
            DynamicScopeExternalContext dynamicScopeContext = new DynamicScopeExternalContext(dynamicScopes, jwr, unmodifiableAuthorizationGrant);
            this.externalDynamicScopeService.executeExternalUpdateMethods(dynamicScopeContext);
        }
        this.processCiba(jwr, authorizationGrant, refreshToken);
    }

    private void processCiba(JsonWebResponse jwr, IAuthorizationGrant authorizationGrant, RefreshToken refreshToken) {
        if (!(authorizationGrant instanceof CIBAGrant)) {
            return;
        }
        String refreshTokenHash = AbstractToken.getHash(refreshToken.getCode(), null);
        jwr.setClaim("urn:openid:params:jwt:claim:rt_hash", refreshTokenHash);
        CIBAGrant cibaGrant = (CIBAGrant)authorizationGrant;
        jwr.setClaim("urn:openid:params:jwt:claim:auth_req_id", cibaGrant.getAuthReqId());
    }

    private void setClaimsFromJwtAuthorizationRequest(JsonWebResponse jwr, IAuthorizationGrant authorizationGrant, Set<String> scopes) throws InvalidClaimException {
        JwtAuthorizationRequest requestObject = authorizationGrant.getJwtAuthorizationRequest();
        if (requestObject == null || requestObject.getIdTokenMember() == null) {
            return;
        }
        for (Claim claim : requestObject.getIdTokenMember().getClaims()) {
            Client client;
            boolean optional = true;
            GluuAttribute gluuAttribute = this.attributeService.getByClaimName(claim.getName());
            if (gluuAttribute == null || !this.validateRequesteClaim(gluuAttribute, (client = authorizationGrant.getClient()).getClaims(), scopes)) continue;
            String ldapClaimName = gluuAttribute.getName();
            Object attribute = authorizationGrant.getUser().getAttribute(ldapClaimName, optional, gluuAttribute.getOxMultiValuedAttribute().booleanValue());
            jwr.getClaims().setClaimFromJsonObject(claim.getName(), attribute);
        }
    }

    public JsonWebResponse createJwr(IAuthorizationGrant grant, String nonce, AuthorizationCode authorizationCode, AccessToken accessToken, RefreshToken refreshToken, String state, Set<String> scopes, boolean includeIdTokenClaims, Function<JsonWebResponse, Void> preProcessing) throws Exception {
        Client client = grant.getClient();
        JsonWebResponse jwr = this.jwrService.createJwr(client);
        this.fillClaims(jwr, grant, nonce, authorizationCode, accessToken, refreshToken, state, scopes, includeIdTokenClaims, preProcessing);
        return this.jwrService.encode(jwr, client);
    }

    private boolean validateRequesteClaim(GluuAttribute gluuAttribute, String[] clientAllowedClaims, Collection<String> scopes) {
        if (gluuAttribute == null) {
            return false;
        }
        if (clientAllowedClaims != null) {
            for (String clientAllowedClaim : clientAllowedClaims) {
                if (!gluuAttribute.getDn().equals(clientAllowedClaim)) continue;
                return true;
            }
        }
        for (String scopeName : scopes) {
            Scope scope = this.scopeService.getScopeById(scopeName);
            if (scope == null || scope.getOxAuthClaims() == null) continue;
            for (String claimDn : scope.getOxAuthClaims()) {
                if (!gluuAttribute.getDisplayName().equals(this.attributeService.getAttributeByDn(claimDn).getDisplayName())) continue;
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getClaims(User user, Scope scope) throws InvalidClaimException, ParseException {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        if (scope == null || scope.getOxAuthClaims() == null) {
            return claims;
        }
        for (String claimDn : scope.getOxAuthClaims()) {
            GluuAttribute gluuAttribute = this.attributeService.getAttributeByDn(claimDn);
            String claimName = gluuAttribute.getOxAuthClaimName();
            String ldapName = gluuAttribute.getName();
            Object attribute = null;
            if (!StringUtils.isNotBlank((String)claimName) || !StringUtils.isNotBlank((String)ldapName)) continue;
            if (ldapName.equals("uid")) {
                attribute = user.getUserId();
            } else if (AttributeDataType.BOOLEAN.equals((Object)gluuAttribute.getDataType())) {
                attribute = Boolean.parseBoolean(String.valueOf(user.getAttribute(gluuAttribute.getName(), true, gluuAttribute.getOxMultiValuedAttribute().booleanValue())));
            } else if (AttributeDataType.DATE.equals((Object)gluuAttribute.getDataType())) {
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'");
                Object attributeValue = user.getAttribute(gluuAttribute.getName(), true, gluuAttribute.getOxMultiValuedAttribute().booleanValue());
                if (attributeValue != null) {
                    attribute = format.parse(attributeValue.toString());
                }
            } else {
                attribute = user.getAttribute(gluuAttribute.getName(), true, gluuAttribute.getOxMultiValuedAttribute().booleanValue());
            }
            if (attribute == null) continue;
            if (attribute instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)attribute;
                ArrayList<String> values = new ArrayList<String>();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    String value = jsonArray.optString(i);
                    if (value == null) continue;
                    values.add(value);
                }
                claims.put(claimName, values);
                continue;
            }
            claims.put(claimName, attribute);
        }
        return claims;
    }
}

