/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.config;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.apache.commons.lang.StringUtils;
import org.gluu.exception.ConfigurationException;
import org.gluu.oxauth.model.config.BaseDnConfiguration;
import org.gluu.oxauth.model.config.Conf;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.oxauth.model.config.WebKeysConfiguration;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.configuration.Configuration;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.crypto.CryptoProviderFactory;
import org.gluu.oxauth.model.error.ErrorMessages;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.event.CryptoProviderEvent;
import org.gluu.oxauth.model.jwk.JSONWebKey;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.exception.BasePersistenceException;
import org.gluu.persist.model.PersistenceConfiguration;
import org.gluu.persist.service.PersistanceFactoryService;
import org.gluu.service.cdi.async.Asynchronous;
import org.gluu.service.cdi.event.BaseConfigurationReload;
import org.gluu.service.cdi.event.ConfigurationEvent;
import org.gluu.service.cdi.event.ConfigurationUpdate;
import org.gluu.service.cdi.event.LdapConfigurationReload;
import org.gluu.service.cdi.event.Scheduled;
import org.gluu.service.timer.event.TimerEvent;
import org.gluu.service.timer.schedule.TimerSchedule;
import org.gluu.util.StringHelper;
import org.gluu.util.properties.FileConfiguration;
import org.json.JSONObject;
import org.slf4j.Logger;

@ApplicationScoped
public class ConfigurationFactory {
    @Inject
    private Logger log;
    @Inject
    private Event<TimerEvent> timerEvent;
    @Inject
    private Event<AppConfiguration> configurationUpdateEvent;
    @Inject
    private Event<AbstractCryptoProvider> cryptoProviderEvent;
    @Inject
    private Event<String> event;
    @Inject
    @Named(value="persistenceEntryManager")
    private Instance<PersistenceEntryManager> persistenceEntryManagerInstance;
    @Inject
    private PersistanceFactoryService persistanceFactoryService;
    @Inject
    private Instance<Configuration> configurationInstance;
    @Inject
    private Instance<AbstractCryptoProvider> abstractCryptoProviderInstance;
    public static final String PERSISTENCE_CONFIGUARION_RELOAD_EVENT_TYPE = "persistenceConfigurationReloadEvent";
    public static final String BASE_CONFIGUARION_RELOAD_EVENT_TYPE = "baseConfigurationReloadEvent";
    private static final int DEFAULT_INTERVAL = 30;
    private static final String BASE_DIR = System.getProperty("gluu.base") != null ? System.getProperty("gluu.base") : (System.getProperty("catalina.base") != null && System.getProperty("catalina.base.ignore") == null ? System.getProperty("catalina.base") : (System.getProperty("catalina.home") != null ? System.getProperty("catalina.home") : (System.getProperty("jboss.home.dir") != null ? System.getProperty("jboss.home.dir") : null)));
    private static final String DIR = BASE_DIR + File.separator + "conf" + File.separator;
    private static final String BASE_PROPERTIES_FILE = DIR + "gluu.properties";
    private static final String LDAP_PROPERTIES_FILE = DIR + "oxauth.properties";
    private final String CONFIG_FILE_NAME = "oxauth-config.json";
    private final String ERRORS_FILE_NAME = "oxauth-errors.json";
    private final String STATIC_CONF_FILE_NAME = "oxauth-static-conf.json";
    private final String WEB_KEYS_FILE_NAME = "oxauth-web-keys.json";
    private final String SALT_FILE_NAME = "salt";
    private String confDir;
    private String configFilePath;
    private String errorsFilePath;
    private String staticConfFilePath;
    private String webKeysFilePath;
    private String saltFilePath;
    private boolean loaded = false;
    private FileConfiguration baseConfiguration;
    private PersistenceConfiguration persistenceConfiguration;
    private AppConfiguration conf;
    private StaticConfiguration staticConf;
    private WebKeysConfiguration jwks;
    private ErrorResponseFactory errorResponseFactory;
    private String cryptoConfigurationSalt;
    private String contextPath;
    private String facesMapping;
    private AtomicBoolean isActive;
    private long baseConfigurationFileLastModifiedTime;
    private long loadedRevision = -1L;
    private boolean loadedFromLdap = true;

    @PostConstruct
    public void init() {
        this.isActive = new AtomicBoolean(true);
        try {
            this.persistenceConfiguration = this.persistanceFactoryService.loadPersistenceConfiguration(LDAP_PROPERTIES_FILE);
            this.loadBaseConfiguration();
            this.confDir = this.confDir();
            this.configFilePath = this.confDir + "oxauth-config.json";
            this.errorsFilePath = this.confDir + "oxauth-errors.json";
            this.staticConfFilePath = this.confDir + "oxauth-static-conf.json";
            String certsDir = this.baseConfiguration.getString("certsDir");
            if (StringHelper.isEmpty((String)certsDir)) {
                certsDir = this.confDir;
            }
            this.webKeysFilePath = certsDir + File.separator + "oxauth-web-keys.json";
            this.saltFilePath = this.confDir + "salt";
            this.loadCryptoConfigurationSalt();
        }
        finally {
            this.isActive.set(false);
        }
    }

    public void onServletContextActivation(@Observes ServletContext context) {
        this.contextPath = context.getContextPath();
        this.facesMapping = "";
        ServletRegistration servletRegistration = context.getServletRegistration("Faces Servlet");
        if (servletRegistration == null) {
            return;
        }
        String[] mappings = servletRegistration.getMappings().toArray(new String[0]);
        if (mappings.length == 0) {
            return;
        }
        this.facesMapping = mappings[0].replaceAll("\\*", "");
    }

    public void create() {
        if (!this.createFromLdap(true)) {
            this.log.error("Failed to load configuration from LDAP. Please fix it!!!.");
            throw new ConfigurationException("Failed to load configuration from LDAP.");
        }
        this.log.info("Configuration loaded successfully.");
    }

    public void initTimer() {
        this.log.debug("Initializing Configuration Timer");
        int delay = 30;
        int interval = 30;
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(30, 30), (Object)new ConfigurationEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
    }

    @Asynchronous
    public void reloadConfigurationTimerEvent(@Observes @Scheduled ConfigurationEvent configurationEvent) {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.reloadConfiguration();
        }
        catch (Throwable ex) {
            this.log.error("Exception happened while reloading application configuration", ex);
        }
        finally {
            this.isActive.set(false);
        }
    }

    private void reloadConfiguration() {
        long lastModified;
        File baseConfiguration;
        PersistenceConfiguration newPersistenceConfiguration = this.persistanceFactoryService.loadPersistenceConfiguration(LDAP_PROPERTIES_FILE);
        if (!(newPersistenceConfiguration == null || StringHelper.equalsIgnoreCase((String)this.persistenceConfiguration.getFileName(), (String)newPersistenceConfiguration.getFileName()) && newPersistenceConfiguration.getLastModifiedTime() <= this.persistenceConfiguration.getLastModifiedTime())) {
            this.persistenceConfiguration = newPersistenceConfiguration;
            this.event.select(new Annotation[]{LdapConfigurationReload.Literal.INSTANCE}).fire((Object)PERSISTENCE_CONFIGUARION_RELOAD_EVENT_TYPE);
        }
        if ((baseConfiguration = new File(BASE_PROPERTIES_FILE)).exists() && (lastModified = baseConfiguration.lastModified()) > this.baseConfigurationFileLastModifiedTime) {
            this.loadBaseConfiguration();
            this.event.select(new Annotation[]{BaseConfigurationReload.Literal.INSTANCE}).fire((Object)BASE_CONFIGUARION_RELOAD_EVENT_TYPE);
        }
        if (!this.loadedFromLdap) {
            return;
        }
        if (!this.isRevisionIncreased()) {
            return;
        }
        this.createFromLdap(false);
    }

    private boolean isRevisionIncreased() {
        Conf conf = this.loadConfigurationFromLdap("oxRevision");
        if (conf == null) {
            return false;
        }
        this.log.trace("LDAP revision: " + conf.getRevision() + ", server revision:" + this.loadedRevision);
        return conf.getRevision() > this.loadedRevision;
    }

    private String confDir() {
        String confDir = this.baseConfiguration.getString("confDir", null);
        if (StringUtils.isNotBlank((String)confDir)) {
            return confDir;
        }
        return DIR;
    }

    public FileConfiguration getBaseConfiguration() {
        return this.baseConfiguration;
    }

    @Produces
    @ApplicationScoped
    public PersistenceConfiguration getPersistenceConfiguration() {
        return this.persistenceConfiguration;
    }

    @Produces
    @ApplicationScoped
    public AppConfiguration getAppConfiguration() {
        return this.conf;
    }

    @Produces
    @ApplicationScoped
    public StaticConfiguration getStaticConfiguration() {
        return this.staticConf;
    }

    @Produces
    @ApplicationScoped
    public WebKeysConfiguration getWebKeysConfiguration() {
        return this.jwks;
    }

    @Produces
    @ApplicationScoped
    public ErrorResponseFactory getErrorResponseFactory() {
        return this.errorResponseFactory;
    }

    public BaseDnConfiguration getBaseDn() {
        return this.getStaticConfiguration().getBaseDn();
    }

    public String getCryptoConfigurationSalt() {
        return this.cryptoConfigurationSalt;
    }

    private boolean createFromFile() {
        boolean result = this.reloadConfFromFile() && this.reloadErrorsFromFile() && this.reloadStaticConfFromFile() && this.reloadWebkeyFromFile();
        return result;
    }

    private boolean reloadWebkeyFromFile() {
        WebKeysConfiguration webKeysFromFile = this.loadWebKeysFromFile();
        if (webKeysFromFile != null) {
            this.log.info("Reloaded web keys from file: " + this.webKeysFilePath);
            this.jwks = webKeysFromFile;
            return true;
        }
        this.log.error("Failed to load web keys configuration from file: " + this.webKeysFilePath);
        return false;
    }

    private boolean reloadStaticConfFromFile() {
        StaticConfiguration staticConfFromFile = this.loadStaticConfFromFile();
        if (staticConfFromFile != null) {
            this.log.info("Reloaded static conf from file: " + this.staticConfFilePath);
            this.staticConf = staticConfFromFile;
            return true;
        }
        this.log.error("Failed to load static configuration from file: " + this.staticConfFilePath);
        return false;
    }

    private boolean reloadErrorsFromFile() {
        ErrorMessages errorsFromFile = this.loadErrorsFromFile();
        if (errorsFromFile != null) {
            this.log.info("Reloaded errors from file: " + this.errorsFilePath);
            this.errorResponseFactory = new ErrorResponseFactory(errorsFromFile, this.conf);
            return true;
        }
        this.log.error("Failed to load errors from file: " + this.errorsFilePath);
        return false;
    }

    private boolean reloadConfFromFile() {
        AppConfiguration configFromFile = this.loadConfFromFile();
        if (configFromFile != null) {
            this.log.info("Reloaded configuration from file: " + this.configFilePath);
            this.conf = configFromFile;
            return true;
        }
        this.log.error("Failed to load configuration from file: " + this.configFilePath);
        return false;
    }

    public boolean reloadConfFromLdap() {
        if (!this.isRevisionIncreased()) {
            return false;
        }
        return this.createFromLdap(false);
    }

    private boolean createFromLdap(boolean recoverFromFiles) {
        this.log.info("Loading configuration from '{}' DB...", (Object)this.baseConfiguration.getString("persistence.type"));
        try {
            Conf c = this.loadConfigurationFromLdap(new String[0]);
            if (c != null) {
                this.init(c);
                if (this.loaded) {
                    this.destroy(AppConfiguration.class);
                    this.destroy(StaticConfiguration.class);
                    this.destroy(WebKeysConfiguration.class);
                    this.destroy(ErrorResponseFactory.class);
                }
                this.loaded = true;
                this.configurationUpdateEvent.select(new Annotation[]{ConfigurationUpdate.Literal.INSTANCE}).fire((Object)this.conf);
                this.destroyCryptoProviderInstance();
                AbstractCryptoProvider newAbstractCryptoProvider = (AbstractCryptoProvider)this.abstractCryptoProviderInstance.get();
                this.cryptoProviderEvent.select(new Annotation[]{CryptoProviderEvent.Literal.INSTANCE}).fire((Object)newAbstractCryptoProvider);
                return true;
            }
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
        if (recoverFromFiles) {
            this.log.info("Unable to find configuration in LDAP, try to load configuration from file system... ");
            if (this.createFromFile()) {
                this.loadedFromLdap = false;
                return true;
            }
        }
        return false;
    }

    public void destroy(Class<? extends Configuration> clazz) {
        Instance confInstance = this.configurationInstance.select(clazz, new Annotation[0]);
        this.configurationInstance.destroy(confInstance.get());
    }

    private void destroyCryptoProviderInstance() {
        this.log.trace("Destroyed crypto provider instance.");
        AbstractCryptoProvider abstractCryptoProvider = (AbstractCryptoProvider)this.abstractCryptoProviderInstance.get();
        this.abstractCryptoProviderInstance.destroy((Object)abstractCryptoProvider);
        CryptoProviderFactory.reset();
    }

    private Conf loadConfigurationFromLdap(String ... returnAttributes) {
        PersistenceEntryManager ldapManager = (PersistenceEntryManager)this.persistenceEntryManagerInstance.get();
        String dn = this.baseConfiguration.getString("oxauth_ConfigurationEntryDN");
        try {
            Conf conf = (Conf)ldapManager.find((Object)dn, Conf.class, returnAttributes);
            return conf;
        }
        catch (BasePersistenceException ex) {
            ex.printStackTrace();
            this.log.error(ex.getMessage());
            return null;
        }
    }

    private void init(Conf p_conf) {
        this.initConfigurationConf(p_conf);
        this.loadedRevision = p_conf.getRevision();
    }

    private void initConfigurationConf(Conf p_conf) {
        if (p_conf.getDynamic() != null) {
            this.conf = p_conf.getDynamic();
        }
        if (p_conf.getStatics() != null) {
            this.staticConf = p_conf.getStatics();
        }
        if (p_conf.getWebKeys() != null) {
            this.jwks = p_conf.getWebKeys();
        } else {
            this.generateWebKeys();
        }
        if (p_conf.getErrors() != null) {
            this.errorResponseFactory = new ErrorResponseFactory(p_conf.getErrors(), p_conf.getDynamic());
        }
    }

    private void generateWebKeys() {
        this.log.info("Failed to load JWKS. Attempting to generate new JWKS...");
        String newWebKeys = null;
        try {
            AbstractCryptoProvider cryptoProvider = CryptoProviderFactory.getCryptoProvider((AppConfiguration)this.getAppConfiguration());
            JSONObject jsonObject = AbstractCryptoProvider.generateJwks((AbstractCryptoProvider)cryptoProvider, (int)this.getAppConfiguration().getKeyRegenerationInterval(), (int)this.getAppConfiguration().getIdTokenLifetime(), (AppConfiguration)this.getAppConfiguration());
            newWebKeys = jsonObject.toString();
            this.jwks = (WebKeysConfiguration)((Object)ServerUtil.createJsonMapper().readValue(newWebKeys, WebKeysConfiguration.class));
            Conf conf = this.loadConfigurationFromLdap(new String[0]);
            conf.setWebKeys(this.jwks);
            long nextRevision = conf.getRevision() + 1L;
            conf.setRevision(nextRevision);
            PersistenceEntryManager ldapManager = (PersistenceEntryManager)this.persistenceEntryManagerInstance.get();
            ldapManager.merge((Object)conf);
            this.log.info("Generated new JWKS successfully.");
            this.log.trace("JWKS keys: " + conf.getWebKeys().getKeys().stream().map(JSONWebKey::getKid).collect(Collectors.toList()));
            this.log.trace("KeyStore keys: " + cryptoProvider.getKeys());
        }
        catch (Exception ex2) {
            this.log.error("Failed to re-generate JWKS keys", (Throwable)ex2);
        }
    }

    private AppConfiguration loadConfFromFile() {
        try {
            return (AppConfiguration)ServerUtil.createJsonMapper().readValue(new File(this.configFilePath), AppConfiguration.class);
        }
        catch (Exception e) {
            this.log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private ErrorMessages loadErrorsFromFile() {
        try {
            return (ErrorMessages)ServerUtil.createJsonMapper().readValue(new File(this.errorsFilePath), ErrorMessages.class);
        }
        catch (Exception e) {
            this.log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private StaticConfiguration loadStaticConfFromFile() {
        try {
            return (StaticConfiguration)ServerUtil.createJsonMapper().readValue(new File(this.staticConfFilePath), StaticConfiguration.class);
        }
        catch (Exception e) {
            this.log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private WebKeysConfiguration loadWebKeysFromFile() {
        try {
            return (WebKeysConfiguration)((Object)ServerUtil.createJsonMapper().readValue(new File(this.webKeysFilePath), WebKeysConfiguration.class));
        }
        catch (Exception e) {
            this.log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void loadBaseConfiguration() {
        this.baseConfiguration = this.createFileConfiguration(BASE_PROPERTIES_FILE, true);
        File baseConfiguration = new File(BASE_PROPERTIES_FILE);
        this.baseConfigurationFileLastModifiedTime = baseConfiguration.lastModified();
    }

    public void loadCryptoConfigurationSalt() {
        try {
            FileConfiguration cryptoConfiguration = this.createFileConfiguration(this.saltFilePath, true);
            this.cryptoConfigurationSalt = cryptoConfiguration.getString("encodeSalt");
        }
        catch (Exception ex) {
            this.log.error("Failed to load configuration from {}", (Object)this.saltFilePath, (Object)ex);
            throw new ConfigurationException("Failed to load configuration from " + this.saltFilePath, (Throwable)ex);
        }
    }

    private FileConfiguration createFileConfiguration(String fileName, boolean isMandatory) {
        try {
            FileConfiguration fileConfiguration = new FileConfiguration(fileName);
            return fileConfiguration;
        }
        catch (Exception ex) {
            if (isMandatory) {
                this.log.error("Failed to load configuration from {}", (Object)fileName, (Object)ex);
                throw new ConfigurationException("Failed to load configuration from " + fileName, (Throwable)ex);
            }
            return null;
        }
    }

    public String getFacesMapping() {
        return this.facesMapping;
    }

    public String getContextPath() {
        return this.contextPath;
    }
}

