/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.common;

import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.common.AuthorizationGrant;
import org.gluu.oxauth.model.common.AuthorizationGrantType;
import org.gluu.oxauth.model.common.CacheGrant;
import org.gluu.oxauth.model.common.DeviceAuthorizationCacheControl;
import org.gluu.oxauth.model.common.User;
import org.gluu.service.CacheService;

public class DeviceCodeGrant
extends AuthorizationGrant {
    private String deviceCode;
    @Inject
    private CacheService cacheService;

    public void init(DeviceAuthorizationCacheControl cacheData, User user) {
        super.init(user, AuthorizationGrantType.DEVICE_CODE, cacheData.getClient(), null);
        this.setDeviceCode(cacheData.getDeviceCode());
        this.setIsCachedWithNoPersistence(true);
        this.setScopes(cacheData.getScopes());
    }

    @Override
    public void save() {
        CacheGrant cachedGrant = new CacheGrant(this, this.appConfiguration);
        String cacheKey = StringUtils.isNotBlank((String)cachedGrant.getDeviceCode()) ? cachedGrant.getDeviceCode() : cachedGrant.getGrantId();
        this.cacheService.put(cachedGrant.getExpiresIn(), cacheKey, (Object)cachedGrant);
    }

    public String getDeviceCode() {
        return this.deviceCode;
    }

    public void setDeviceCode(String deviceCode) {
        this.deviceCode = deviceCode;
    }
}

