/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.common;

import java.io.Serializable;
import java.util.List;
import org.gluu.oxauth.model.common.CibaRequestStatus;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.util.StringUtils;

public class CibaRequestCacheControl
implements Serializable {
    private String authReqId;
    private User user;
    private Client client;
    private List<String> scopes;
    private int expiresIn = 1;
    private String clientNotificationToken;
    private String bindingMessage;
    private Long lastAccessControl;
    private CibaRequestStatus status;
    private boolean tokensDelivered;
    private String acrValues;

    public CibaRequestCacheControl() {
    }

    public CibaRequestCacheControl(User user, Client client, int expiresIn, List<String> scopeList, String clientNotificationToken, String bindingMessage, Long lastAccessControl, String acrValues) {
        this.authReqId = StringUtils.generateRandomCode((byte)24);
        this.user = user;
        this.client = client;
        this.scopes = scopeList;
        this.status = CibaRequestStatus.PENDING;
        this.expiresIn = expiresIn;
        this.clientNotificationToken = clientNotificationToken;
        this.bindingMessage = bindingMessage;
        this.lastAccessControl = lastAccessControl;
        this.tokensDelivered = false;
        this.acrValues = acrValues;
    }

    public String cacheKey() {
        return this.authReqId;
    }

    public String getScopesAsString() {
        StringBuilder scopes = new StringBuilder();
        for (String s : this.getScopes()) {
            scopes.append(s).append(" ");
        }
        return scopes.toString().trim();
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }

    public String getAuthReqId() {
        return this.authReqId;
    }

    public void setAuthReqId(String authReqId) {
        this.authReqId = authReqId;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public void setExpiresIn(int expiresIn) {
        this.expiresIn = expiresIn;
    }

    public String getClientNotificationToken() {
        return this.clientNotificationToken;
    }

    public void setClientNotificationToken(String clientNotificationToken) {
        this.clientNotificationToken = clientNotificationToken;
    }

    public String getBindingMessage() {
        return this.bindingMessage;
    }

    public void setBindingMessage(String bindingMessage) {
        this.bindingMessage = bindingMessage;
    }

    public Long getLastAccessControl() {
        return this.lastAccessControl;
    }

    public void setLastAccessControl(Long lastAccessControl) {
        this.lastAccessControl = lastAccessControl;
    }

    public CibaRequestStatus getStatus() {
        return this.status;
    }

    public void setStatus(CibaRequestStatus status) {
        this.status = status;
    }

    public boolean isTokensDelivered() {
        return this.tokensDelivered;
    }

    public void setTokensDelivered(boolean tokensDelivered) {
        this.tokensDelivered = tokensDelivered;
    }

    public String getAcrValues() {
        return this.acrValues;
    }

    public void setAcrValues(String acrValues) {
        this.acrValues = acrValues;
    }

    public String toString() {
        return "CibaRequestCacheControl{, authReqId='" + this.authReqId + '\'' + ", user=" + this.user + ", client=" + this.client + ", scopes=" + this.scopes + ", expiresIn=" + this.expiresIn + ", clientNotificationToken='" + this.clientNotificationToken + '\'' + ", bindingMessage='" + this.bindingMessage + '\'' + ", lastAccessControl=" + this.lastAccessControl + ", userAuthorization=" + (Object)((Object)this.status) + ", tokensDelivered=" + this.tokensDelivered + ", acrValues='" + this.acrValues + '\'' + '}';
    }
}

