/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.common;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gluu.model.metric.MetricType;
import org.gluu.oxauth.model.authorize.JwtAuthorizationRequest;
import org.gluu.oxauth.model.common.AbstractAuthorizationGrant;
import org.gluu.oxauth.model.common.AccessToken;
import org.gluu.oxauth.model.common.AuthorizationCode;
import org.gluu.oxauth.model.common.AuthorizationCodeGrant;
import org.gluu.oxauth.model.common.AuthorizationGrant;
import org.gluu.oxauth.model.common.AuthorizationGrantType;
import org.gluu.oxauth.model.common.CIBAGrant;
import org.gluu.oxauth.model.common.CacheGrant;
import org.gluu.oxauth.model.common.CibaRequestCacheControl;
import org.gluu.oxauth.model.common.ClientCredentialsGrant;
import org.gluu.oxauth.model.common.DeviceAuthorizationCacheControl;
import org.gluu.oxauth.model.common.DeviceCodeGrant;
import org.gluu.oxauth.model.common.IAuthorizationGrantList;
import org.gluu.oxauth.model.common.IdToken;
import org.gluu.oxauth.model.common.ImplicitGrant;
import org.gluu.oxauth.model.common.RefreshToken;
import org.gluu.oxauth.model.common.ResourceOwnerPasswordCredentialsGrant;
import org.gluu.oxauth.model.common.SimpleAuthorizationGrant;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.ldap.TokenLdap;
import org.gluu.oxauth.model.ldap.TokenType;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.util.Util;
import org.gluu.oxauth.service.ClientService;
import org.gluu.oxauth.service.GrantService;
import org.gluu.oxauth.service.MetricService;
import org.gluu.oxauth.service.common.UserService;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.oxauth.util.TokenHashUtil;
import org.gluu.service.CacheService;
import org.slf4j.Logger;

@Dependent
public class AuthorizationGrantList
implements IAuthorizationGrantList {
    @Inject
    private Logger log;
    @Inject
    private Instance<AbstractAuthorizationGrant> grantInstance;
    @Inject
    private GrantService grantService;
    @Inject
    private UserService userService;
    @Inject
    private ClientService clientService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private CacheService cacheService;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    @Inject
    private MetricService metricService;

    @Override
    public void removeAuthorizationGrants(List<AuthorizationGrant> authorizationGrants) {
        if (authorizationGrants != null && !authorizationGrants.isEmpty()) {
            for (AuthorizationGrant r : authorizationGrants) {
                this.grantService.remove(r);
            }
        }
    }

    @Override
    public AuthorizationGrant createAuthorizationGrant(User user, Client client, Date authenticationTime) {
        AuthorizationGrant grant = (AuthorizationGrant)this.grantInstance.select(SimpleAuthorizationGrant.class, new Annotation[0]).get();
        grant.init(user, null, client, authenticationTime);
        return grant;
    }

    @Override
    public AuthorizationCodeGrant createAuthorizationCodeGrant(User user, Client client, Date authenticationTime) {
        AuthorizationCodeGrant grant = (AuthorizationCodeGrant)this.grantInstance.select(AuthorizationCodeGrant.class, new Annotation[0]).get();
        grant.init(user, client, authenticationTime);
        CacheGrant memcachedGrant = new CacheGrant(grant, this.appConfiguration);
        this.cacheService.put(grant.getAuthorizationCode().getExpiresIn(), memcachedGrant.cacheKey(), (Object)memcachedGrant);
        this.log.trace("Put authorization grant in cache, code: " + grant.getAuthorizationCode().getCode() + ", clientId: " + grant.getClientId());
        this.metricService.incCounter(MetricType.OXAUTH_TOKEN_AUTHORIZATION_CODE_COUNT);
        return grant;
    }

    @Override
    public ImplicitGrant createImplicitGrant(User user, Client client, Date authenticationTime) {
        ImplicitGrant grant = (ImplicitGrant)this.grantInstance.select(ImplicitGrant.class, new Annotation[0]).get();
        grant.init(user, client, authenticationTime);
        return grant;
    }

    @Override
    public ClientCredentialsGrant createClientCredentialsGrant(User user, Client client) {
        ClientCredentialsGrant grant = (ClientCredentialsGrant)this.grantInstance.select(ClientCredentialsGrant.class, new Annotation[0]).get();
        grant.init(user, client);
        return grant;
    }

    @Override
    public ResourceOwnerPasswordCredentialsGrant createResourceOwnerPasswordCredentialsGrant(User user, Client client) {
        ResourceOwnerPasswordCredentialsGrant grant = (ResourceOwnerPasswordCredentialsGrant)this.grantInstance.select(ResourceOwnerPasswordCredentialsGrant.class, new Annotation[0]).get();
        grant.init(user, client);
        return grant;
    }

    @Override
    public CIBAGrant createCIBAGrant(CibaRequestCacheControl request) {
        CIBAGrant grant = (CIBAGrant)this.grantInstance.select(CIBAGrant.class, new Annotation[0]).get();
        grant.init(request);
        CacheGrant memcachedGrant = new CacheGrant(grant, this.appConfiguration);
        this.cacheService.put(request.getExpiresIn(), memcachedGrant.getAuthReqId(), (Object)memcachedGrant);
        this.log.trace("Ciba grant saved in cache, authReqId: {}, grantId: {}", (Object)grant.getAuthReqId(), (Object)grant.getGrantId());
        return grant;
    }

    @Override
    public CIBAGrant getCIBAGrant(String authReqId) {
        Object cachedGrant = this.cacheService.get(authReqId);
        if (cachedGrant == null) {
            cachedGrant = this.cacheService.get(authReqId);
            this.log.trace("Failed to fetch CIBA grant from cache, authReqId: {}", (Object)authReqId);
        }
        return cachedGrant instanceof CacheGrant ? ((CacheGrant)cachedGrant).asCibaGrant(this.grantInstance) : null;
    }

    @Override
    public DeviceCodeGrant createDeviceGrant(DeviceAuthorizationCacheControl data, User user) {
        DeviceCodeGrant grant = (DeviceCodeGrant)this.grantInstance.select(DeviceCodeGrant.class, new Annotation[0]).get();
        grant.init(data, user);
        CacheGrant memcachedGrant = new CacheGrant(grant, this.appConfiguration);
        this.cacheService.put(data.getExpiresIn(), memcachedGrant.getDeviceCode(), (Object)memcachedGrant);
        this.log.trace("Device code grant saved in cache, deviceCode: {}, grantId: {}", (Object)grant.getDeviceCode(), (Object)grant.getGrantId());
        return grant;
    }

    @Override
    public DeviceCodeGrant getDeviceCodeGrant(String deviceCode) {
        Object cachedGrant = this.cacheService.get(deviceCode);
        if (cachedGrant == null) {
            cachedGrant = this.cacheService.get(deviceCode);
            this.log.trace("Failed to fetch Device code grant from cache, deviceCode: {}", (Object)deviceCode);
        }
        return cachedGrant instanceof CacheGrant ? ((CacheGrant)cachedGrant).asDeviceCodeGrant(this.grantInstance) : null;
    }

    @Override
    public AuthorizationCodeGrant getAuthorizationCodeGrant(String authorizationCode) {
        Object cachedGrant = this.cacheService.get(CacheGrant.cacheKey(authorizationCode, null));
        if (cachedGrant == null) {
            cachedGrant = this.cacheService.get(CacheGrant.cacheKey(authorizationCode, null));
            this.log.trace("Failed to fetch authorization grant from cache, code: " + authorizationCode);
        }
        return cachedGrant instanceof CacheGrant ? ((CacheGrant)cachedGrant).asCodeGrant(this.grantInstance) : null;
    }

    @Override
    public AuthorizationGrant getAuthorizationGrantByRefreshToken(String clientId, String refreshTokenCode) {
        if (!ServerUtil.isTrue(this.appConfiguration.getPersistRefreshTokenInLdap())) {
            return this.assertTokenType((TokenLdap)this.cacheService.get(TokenHashUtil.hash(refreshTokenCode)), TokenType.REFRESH_TOKEN, clientId);
        }
        return this.assertTokenType(this.grantService.getGrantByCode(refreshTokenCode), TokenType.REFRESH_TOKEN, clientId);
    }

    public AuthorizationGrant assertTokenType(TokenLdap tokenLdap, TokenType tokenType, String clientId) {
        if (tokenLdap == null || tokenLdap.getTokenTypeEnum() != tokenType) {
            return null;
        }
        AuthorizationGrant grant = this.asGrant(tokenLdap);
        if (grant == null || !grant.getClientId().equals(clientId)) {
            return null;
        }
        return grant;
    }

    @Override
    public List<AuthorizationGrant> getAuthorizationGrant(String clientId) {
        ArrayList<AuthorizationGrant> result = new ArrayList<AuthorizationGrant>();
        try {
            ArrayList<TokenLdap> entries = new ArrayList<TokenLdap>();
            entries.addAll(this.grantService.getGrantsOfClient(clientId));
            entries.addAll(this.grantService.getCacheClientTokensEntries(clientId));
            for (TokenLdap t : entries) {
                AuthorizationGrant grant = this.asGrant(t);
                if (grant == null) continue;
                result.add(grant);
            }
        }
        catch (Exception e) {
            this.log.trace(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public AuthorizationGrant getAuthorizationGrantByAccessToken(String accessToken) {
        return this.getAuthorizationGrantByAccessToken(accessToken, false);
    }

    public AuthorizationGrant getAuthorizationGrantByAccessToken(String accessToken, boolean onlyFromCache) {
        TokenLdap tokenLdap = this.grantService.getGrantByCode(accessToken, onlyFromCache);
        if (tokenLdap != null && (tokenLdap.getTokenTypeEnum() == TokenType.ACCESS_TOKEN || tokenLdap.getTokenTypeEnum() == TokenType.LONG_LIVED_ACCESS_TOKEN)) {
            return this.asGrant(tokenLdap);
        }
        return null;
    }

    @Override
    public AuthorizationGrant getAuthorizationGrantByIdToken(String idToken) {
        if (StringUtils.isBlank((String)idToken)) {
            return null;
        }
        TokenLdap tokenLdap = this.grantService.getGrantByCode(idToken);
        if (tokenLdap != null && tokenLdap.getTokenTypeEnum() == TokenType.ID_TOKEN) {
            return this.asGrant(tokenLdap);
        }
        return null;
    }

    public AuthorizationGrant asGrant(TokenLdap tokenLdap) {
        AuthorizationGrantType grantType;
        if (tokenLdap != null && (grantType = AuthorizationGrantType.fromString(tokenLdap.getGrantType())) != null) {
            AuthorizationGrant result;
            User user = this.userService.getUser(tokenLdap.getUserId(), new String[0]);
            Client client = this.clientService.getClient(tokenLdap.getClientId());
            Date authenticationTime = tokenLdap.getAuthenticationTime();
            String nonce = tokenLdap.getNonce();
            switch (grantType) {
                case AUTHORIZATION_CODE: {
                    AuthorizationCodeGrant authorizationCodeGrant = (AuthorizationCodeGrant)this.grantInstance.select(AuthorizationCodeGrant.class, new Annotation[0]).get();
                    authorizationCodeGrant.init(user, client, authenticationTime);
                    result = authorizationCodeGrant;
                    break;
                }
                case CLIENT_CREDENTIALS: {
                    ClientCredentialsGrant clientCredentialsGrant = (ClientCredentialsGrant)this.grantInstance.select(ClientCredentialsGrant.class, new Annotation[0]).get();
                    clientCredentialsGrant.init(user, client);
                    result = clientCredentialsGrant;
                    break;
                }
                case IMPLICIT: {
                    ImplicitGrant implicitGrant = (ImplicitGrant)this.grantInstance.select(ImplicitGrant.class, new Annotation[0]).get();
                    implicitGrant.init(user, client, authenticationTime);
                    result = implicitGrant;
                    break;
                }
                case RESOURCE_OWNER_PASSWORD_CREDENTIALS: {
                    ResourceOwnerPasswordCredentialsGrant resourceOwnerPasswordCredentialsGrant = (ResourceOwnerPasswordCredentialsGrant)this.grantInstance.select(ResourceOwnerPasswordCredentialsGrant.class, new Annotation[0]).get();
                    resourceOwnerPasswordCredentialsGrant.init(user, client);
                    result = resourceOwnerPasswordCredentialsGrant;
                    break;
                }
                case CIBA: {
                    CIBAGrant cibaGrant = (CIBAGrant)this.grantInstance.select(CIBAGrant.class, new Annotation[0]).get();
                    cibaGrant.init(user, AuthorizationGrantType.CIBA, client, tokenLdap.getCreationDate());
                    result = cibaGrant;
                    break;
                }
                case DEVICE_CODE: {
                    DeviceCodeGrant deviceCodeGrant = (DeviceCodeGrant)this.grantInstance.select(DeviceCodeGrant.class, new Annotation[0]).get();
                    deviceCodeGrant.init(user, AuthorizationGrantType.DEVICE_CODE, client, tokenLdap.getCreationDate());
                    result = deviceCodeGrant;
                    break;
                }
                default: {
                    return null;
                }
            }
            String grantId = tokenLdap.getGrantId();
            String jwtRequest = tokenLdap.getJwtRequest();
            String authMode = tokenLdap.getAuthMode();
            String sessionDn = tokenLdap.getSessionDn();
            String claims = tokenLdap.getClaims();
            result.setTokenBindingHash(tokenLdap.getTokenBindingHash());
            result.setNonce(nonce);
            result.setX5cs256(tokenLdap.getAttributes().getX5cs256());
            result.setTokenLdap(tokenLdap);
            if (StringUtils.isNotBlank((String)grantId)) {
                result.setGrantId(grantId);
            }
            result.setScopes(Util.splittedStringAsList((String)tokenLdap.getScope(), (String)" "));
            result.setCodeChallenge(tokenLdap.getCodeChallenge());
            result.setCodeChallengeMethod(tokenLdap.getCodeChallengeMethod());
            if (StringUtils.isNotBlank((String)jwtRequest)) {
                try {
                    result.setJwtAuthorizationRequest(new JwtAuthorizationRequest(this.appConfiguration, this.cryptoProvider, jwtRequest, client));
                }
                catch (Exception e) {
                    this.log.trace(e.getMessage(), (Throwable)e);
                }
            }
            result.setAcrValues(authMode);
            result.setSessionDn(sessionDn);
            result.setClaims(claims);
            if (tokenLdap.getTokenTypeEnum() != null) {
                switch (tokenLdap.getTokenTypeEnum()) {
                    case AUTHORIZATION_CODE: {
                        if (!(result instanceof AuthorizationCodeGrant)) break;
                        AuthorizationCode code = new AuthorizationCode(tokenLdap.getTokenCode(), tokenLdap.getCreationDate(), tokenLdap.getExpirationDate());
                        AuthorizationCodeGrant g = (AuthorizationCodeGrant)result;
                        g.setAuthorizationCode(code);
                        break;
                    }
                    case REFRESH_TOKEN: {
                        RefreshToken refreshToken = new RefreshToken(tokenLdap.getTokenCode(), tokenLdap.getCreationDate(), tokenLdap.getExpirationDate());
                        result.setRefreshTokens(Arrays.asList(refreshToken));
                        break;
                    }
                    case ACCESS_TOKEN: {
                        AccessToken accessToken = new AccessToken(tokenLdap.getTokenCode(), tokenLdap.getCreationDate(), tokenLdap.getExpirationDate());
                        result.setAccessTokens(Arrays.asList(accessToken));
                        break;
                    }
                    case ID_TOKEN: {
                        IdToken idToken = new IdToken(tokenLdap.getTokenCode(), tokenLdap.getCreationDate(), tokenLdap.getExpirationDate());
                        result.setIdToken(idToken);
                        break;
                    }
                    case LONG_LIVED_ACCESS_TOKEN: {
                        AccessToken longLivedAccessToken = new AccessToken(tokenLdap.getTokenCode(), tokenLdap.getCreationDate(), tokenLdap.getExpirationDate());
                        result.setLongLivedAccessToken(longLivedAccessToken);
                    }
                }
            }
            return result;
        }
        return null;
    }
}

