/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.authorize.ws.rs;

import java.net.URI;
import java.util.ArrayList;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import org.gluu.oxauth.audit.ApplicationAuditLogger;
import org.gluu.oxauth.authorize.ws.rs.DeviceAuthorizationRestWebService;
import org.gluu.oxauth.model.audit.Action;
import org.gluu.oxauth.model.audit.OAuth2AuditLog;
import org.gluu.oxauth.model.authorize.ScopeChecker;
import org.gluu.oxauth.model.common.DeviceAuthorizationCacheControl;
import org.gluu.oxauth.model.common.DeviceAuthorizationStatus;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.session.SessionClient;
import org.gluu.oxauth.model.token.TokenErrorResponseType;
import org.gluu.oxauth.model.util.StringUtils;
import org.gluu.oxauth.security.Identity;
import org.gluu.oxauth.service.ClientService;
import org.gluu.oxauth.service.DeviceAuthorizationService;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.util.StringHelper;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

@Path(value="/")
public class DeviceAuthorizationRestWebServiceImpl
implements DeviceAuthorizationRestWebService {
    @Inject
    private Logger log;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private Identity identity;
    @Inject
    private ScopeChecker scopeChecker;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private DeviceAuthorizationService deviceAuthorizationService;
    @Inject
    private ClientService clientService;
    @Context
    private HttpServletRequest servletRequest;

    @Override
    public Response deviceAuthorization(String clientId, String scope, HttpServletRequest httpRequest, HttpServletResponse httpResponse, SecurityContext securityContext) {
        scope = ServerUtil.urlDecode(scope);
        OAuth2AuditLog oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(httpRequest), Action.DEVICE_CODE_AUTHORIZATION);
        oAuth2AuditLog.setClientId(clientId);
        oAuth2AuditLog.setScope(scope);
        try {
            Client client;
            this.log.debug("Attempting to request device codes: clientId = {}, scope = {}", (Object)clientId, (Object)scope);
            SessionClient sessionClient = this.identity.getSessionClient();
            Client client2 = client = sessionClient != null ? sessionClient.getClient() : null;
            if (client == null && !this.clientService.isPublic(client = this.clientService.getClient(clientId))) {
                this.log.trace("Client is not public and not authenticated. Skip device authorization, clientId: {}", (Object)clientId);
                throw this.errorResponseFactory.createWebApplicationException(Response.Status.UNAUTHORIZED, (IErrorType)TokenErrorResponseType.INVALID_CLIENT, "");
            }
            if (client == null) {
                this.log.trace("Client is not unknown. Skip revoking.");
                throw this.errorResponseFactory.createWebApplicationException(Response.Status.UNAUTHORIZED, (IErrorType)TokenErrorResponseType.INVALID_CLIENT, "");
            }
            if (!this.deviceAuthorizationService.hasDeviceCodeCompatibility(client)) {
                throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)TokenErrorResponseType.INVALID_GRANT, "");
            }
            ArrayList<String> scopes = new ArrayList<String>();
            if (StringHelper.isNotEmpty((String)scope)) {
                Set<String> grantedScopes = this.scopeChecker.checkScopesPolicy(client, scope);
                scopes.addAll(grantedScopes);
            }
            String userCode = StringUtils.generateRandomReadableCode((byte)8);
            String deviceCode = StringUtils.generateRandomCode((byte)24);
            URI verificationUri = UriBuilder.fromUri((String)this.appConfiguration.getIssuer()).path("device-code").build(new Object[0]);
            int expiresIn = this.appConfiguration.getDeviceAuthzRequestExpiresIn();
            int interval = this.appConfiguration.getDeviceAuthzTokenPollInterval();
            long lastAccess = System.currentTimeMillis();
            DeviceAuthorizationStatus status = DeviceAuthorizationStatus.PENDING;
            DeviceAuthorizationCacheControl deviceAuthorizationCacheControl = new DeviceAuthorizationCacheControl(userCode, deviceCode, client, scopes, verificationUri, expiresIn, interval, lastAccess, status);
            this.deviceAuthorizationService.saveInCache(deviceAuthorizationCacheControl, true, true);
            this.log.info("Device authorization flow initiated, userCode: {}, deviceCode: {}, clientId: {}, verificationUri: {}, expiresIn: {}, interval: {}", new Object[]{userCode, deviceCode, clientId, verificationUri, expiresIn, interval});
            this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
            return Response.ok().entity((Object)this.getResponseJSONObject(deviceAuthorizationCacheControl).toString(4).replace("\\/", "/")).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (Exception e) {
            this.log.error("Problems processing device authorization init flow, clientId: {}, scope: {}", new Object[]{clientId, scope, e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private JSONObject getResponseJSONObject(DeviceAuthorizationCacheControl deviceAuthorizationCacheControl) throws JSONException {
        URI verificationUriComplete = UriBuilder.fromUri((URI)deviceAuthorizationCacheControl.getVerificationUri()).queryParam("user_code", new Object[]{deviceAuthorizationCacheControl.getUserCode()}).build(new Object[0]);
        JSONObject responseJsonObject = new JSONObject();
        responseJsonObject.put("device_code", (Object)deviceAuthorizationCacheControl.getDeviceCode());
        responseJsonObject.put("user_code", (Object)deviceAuthorizationCacheControl.getUserCode());
        responseJsonObject.put("verification_uri", (Object)deviceAuthorizationCacheControl.getVerificationUri());
        responseJsonObject.put("verification_uri_complete", (Object)verificationUriComplete.toString());
        responseJsonObject.put("expires_in", deviceAuthorizationCacheControl.getExpiresIn());
        responseJsonObject.put("interval", deviceAuthorizationCacheControl.getInterval());
        return responseJsonObject;
    }
}

