/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.uma.ws.rs;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.model.common.GrantType;
import org.gluu.oxauth.model.common.ResponseType;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.uma.UmaErrorResponseType;
import org.gluu.oxauth.model.uma.UmaMetadata;
import org.gluu.oxauth.util.ServerUtil;
import org.slf4j.Logger;

@Path(value="/uma2-configuration")
public class UmaMetadataWS {
    public static final String UMA_SCOPES_SUFFIX = "/uma/scopes";
    public static final String UMA_CLAIMS_GATHERING_PATH = "/uma/gather_claims";
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AppConfiguration appConfiguration;

    @GET
    @Produces(value={"application/json"})
    public Response getConfiguration() {
        try {
            String baseEndpointUri = this.appConfiguration.getBaseEndpoint();
            UmaMetadata c = new UmaMetadata();
            c.setIssuer(this.appConfiguration.getIssuer());
            c.setGrantTypesSupported(new String[]{GrantType.AUTHORIZATION_CODE.getValue(), GrantType.IMPLICIT.getValue(), GrantType.CLIENT_CREDENTIALS.getValue(), GrantType.OXAUTH_UMA_TICKET.getValue()});
            c.setResponseTypesSupported(new String[]{ResponseType.CODE.getValue(), ResponseType.ID_TOKEN.getValue(), ResponseType.TOKEN.getValue()});
            c.setTokenEndpointAuthMethodsSupported(this.appConfiguration.getTokenEndpointAuthMethodsSupported().toArray(new String[this.appConfiguration.getTokenEndpointAuthMethodsSupported().size()]));
            c.setTokenEndpointAuthSigningAlgValuesSupported(this.appConfiguration.getTokenEndpointAuthSigningAlgValuesSupported().toArray(new String[this.appConfiguration.getTokenEndpointAuthSigningAlgValuesSupported().size()]));
            c.setUiLocalesSupported(this.appConfiguration.getUiLocalesSupported().toArray(new String[this.appConfiguration.getUiLocalesSupported().size()]));
            c.setOpTosUri(this.appConfiguration.getOpTosUri());
            c.setOpPolicyUri(this.appConfiguration.getOpPolicyUri());
            c.setJwksUri(this.appConfiguration.getJwksUri());
            c.setServiceDocumentation(this.appConfiguration.getServiceDocumentation());
            c.setUmaProfilesSupported(new String[0]);
            c.setRegistrationEndpoint(this.appConfiguration.getRegistrationEndpoint());
            c.setTokenEndpoint(this.appConfiguration.getTokenEndpoint());
            c.setAuthorizationEndpoint(this.appConfiguration.getAuthorizationEndpoint());
            c.setIntrospectionEndpoint(baseEndpointUri + "/rpt/status");
            c.setResourceRegistrationEndpoint(baseEndpointUri + "/host/rsrc/resource_set");
            c.setPermissionEndpoint(baseEndpointUri + "/host/rsrc_pr");
            c.setScopeEndpoint(baseEndpointUri + UMA_SCOPES_SUFFIX);
            c.setClaimsInteractionEndpoint(baseEndpointUri + UMA_CLAIMS_GATHERING_PATH);
            String entity = ServerUtil.asPrettyJson(c);
            this.log.trace("Uma metadata: {}", (Object)entity);
            return Response.ok((Object)entity).build();
        }
        catch (Throwable ex) {
            this.log.error(ex.getMessage(), ex);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)UmaErrorResponseType.SERVER_ERROR, "Internal error.");
        }
    }
}

