/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.uma.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.uma.JsonLogic;
import org.gluu.oxauth.model.uma.JsonLogicNode;
import org.gluu.oxauth.model.uma.JsonLogicNodeParser;
import org.gluu.oxauth.model.uma.UmaErrorResponseType;
import org.gluu.oxauth.model.uma.persistence.UmaPermission;
import org.gluu.oxauth.model.uma.persistence.UmaResource;
import org.gluu.oxauth.model.util.Util;
import org.gluu.oxauth.service.external.ExternalUmaRptPolicyService;
import org.gluu.oxauth.uma.authorization.UmaAuthorizationContext;
import org.gluu.oxauth.uma.authorization.UmaScriptByScope;
import org.gluu.oxauth.uma.service.UmaPermissionService;
import org.gluu.oxauth.uma.service.UmaResourceService;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@Stateless
@Named
public class UmaExpressionService {
    @Inject
    private Logger log;
    @Inject
    private ExternalUmaRptPolicyService policyService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private UmaResourceService resourceService;
    @Inject
    private UmaPermissionService permissionService;

    public boolean isExpressionValid(String expression) {
        return JsonLogicNodeParser.isNodeValid((String)expression);
    }

    public void evaluate(Map<UmaScriptByScope, UmaAuthorizationContext> scriptMap, List<UmaPermission> permissions) {
        for (UmaPermission permission : permissions) {
            UmaResource resource = this.resourceService.getResourceById(permission.getResourceId());
            if (StringHelper.isNotEmpty((String)resource.getScopeExpression())) {
                this.evaluateScopeExpression(scriptMap, permission, resource);
                continue;
            }
            if (this.evaluateByScopes(UmaExpressionService.filterByScopeDns(scriptMap, permission.getScopeDns()))) continue;
            this.log.trace("Regular evaluation returns false, access FORBIDDEN.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.FORBIDDEN, (IErrorType)UmaErrorResponseType.FORBIDDEN_BY_POLICY, "Regular evaluation returns false, access FORBIDDEN.");
        }
    }

    private boolean evaluateByScopes(Map<UmaScriptByScope, UmaAuthorizationContext> scriptMap) {
        for (Map.Entry<UmaScriptByScope, UmaAuthorizationContext> entry : scriptMap.entrySet()) {
            boolean result = this.policyService.authorize(entry.getKey().getScript(), entry.getValue());
            this.log.trace("Policy script inum: '{}' result: '{}'", (Object)entry.getKey().getScript().getInum(), (Object)result);
            if (result) continue;
            this.log.trace("Stop authorization scriptMap execution, current script returns false, script inum: " + entry.getKey().getScript().getInum() + ", scope: " + entry.getKey().getScope());
            return false;
        }
        return true;
    }

    private void evaluateScopeExpression(Map<UmaScriptByScope, UmaAuthorizationContext> scriptMap, UmaPermission permission, UmaResource resource) {
        block6: {
            String scopeExpression = resource.getScopeExpression();
            JsonLogicNode node = JsonLogicNodeParser.parseNode((String)scopeExpression);
            if (node != null) {
                this.log.trace("Evaluating scope expression ...");
                List dataScopes = node.getDataCopy();
                Map<String, String> scopeIdToDnMap = UmaExpressionService.scopeIdToDnMap(scriptMap, permission.getScopeDns());
                if (dataScopes.size() == scopeIdToDnMap.size()) {
                    try {
                        ArrayList<Boolean> evaluatedResults = new ArrayList<Boolean>();
                        for (String scopeId : dataScopes) {
                            this.log.trace("Evaluating scope result for scope: " + scopeId + " ...");
                            boolean b = this.evaluateByScopes(UmaExpressionService.filterByScopeDns(scriptMap, Lists.newArrayList((Object[])new String[]{scopeIdToDnMap.get(scopeId)})));
                            this.log.trace("Evaluated scope result: " + b + ", scope: " + scopeId);
                            evaluatedResults.add(b);
                        }
                        String rule = node.getRule().toString();
                        boolean result = evaluatedResults.isEmpty() ? JsonLogic.apply((String)rule) : JsonLogic.apply((String)rule, (String)Util.asJsonSilently(evaluatedResults));
                        this.log.trace("JsonLogic evaluation result: " + result + ", rule: " + rule + ", data:" + Util.asJsonSilently(evaluatedResults));
                        if (result) {
                            this.removeFalseScopesFromPermission(permission, dataScopes, scopeIdToDnMap, evaluatedResults);
                            return;
                        }
                        break block6;
                    }
                    catch (Exception e) {
                        this.log.error("Failed to evaluate jsonlogic expression. Expression: " + scopeExpression + ", resourceDn: " + resource.getDn(), (Throwable)e);
                        throw this.errorResponseFactory.createWebApplicationException(Response.Status.FORBIDDEN, (IErrorType)UmaErrorResponseType.FORBIDDEN_BY_POLICY, "Failed to evaluate jsonlogic expression.");
                    }
                }
                this.log.error("Scope size in JsonLogic object 'data' and in permission differs which is forbidden. Node data: " + node + ", permissionDns: " + permission.getScopeDns() + ", result scopeIds: " + scopeIdToDnMap);
                throw this.errorResponseFactory.createWebApplicationException(Response.Status.FORBIDDEN, (IErrorType)UmaErrorResponseType.FORBIDDEN_BY_POLICY, "Scope size in JsonLogic object 'data' and in permission differs which is forbidden.");
            }
            this.log.error("Failed to parse JsonLogic object, invalid expression: " + scopeExpression);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.FORBIDDEN, (IErrorType)UmaErrorResponseType.FORBIDDEN_BY_POLICY, "Failed to parse JsonLogic object, invalid expression: " + scopeExpression);
        }
        throw this.errorResponseFactory.createWebApplicationException(Response.Status.FORBIDDEN, (IErrorType)UmaErrorResponseType.FORBIDDEN_BY_POLICY, "Unknown");
    }

    private void removeFalseScopesFromPermission(UmaPermission permission, List<String> dataScopes, Map<String, String> scopeIdToDnMap, List<Boolean> evaluatedResults) {
        if (!evaluatedResults.isEmpty() && permission.getScopeDns() != null) {
            ArrayList newPermissionScopes = new ArrayList(permission.getScopeDns());
            for (int i = 0; i < evaluatedResults.size(); ++i) {
                if (evaluatedResults.get(i).booleanValue()) continue;
                String dnToRemove = scopeIdToDnMap.get(dataScopes.get(i));
                newPermissionScopes.remove(dnToRemove);
            }
            if (newPermissionScopes.size() < permission.getScopeDns().size()) {
                permission.setScopeDns(newPermissionScopes);
                this.permissionService.mergeSilently(permission);
            }
        }
    }

    private static Map<String, String> scopeIdToDnMap(Map<UmaScriptByScope, UmaAuthorizationContext> scriptMap, List<String> scriptDNs) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<UmaScriptByScope, UmaAuthorizationContext> entry : scriptMap.entrySet()) {
            if (!scriptDNs.contains(entry.getKey().getScope().getDn())) continue;
            result.put(entry.getKey().getScope().getId(), entry.getKey().getScope().getDn());
        }
        return result;
    }

    private static Map<UmaScriptByScope, UmaAuthorizationContext> filterByScopeDns(Map<UmaScriptByScope, UmaAuthorizationContext> scriptMap, List<String> scopeDNs) {
        HashMap<UmaScriptByScope, UmaAuthorizationContext> result = new HashMap<UmaScriptByScope, UmaAuthorizationContext>();
        for (Map.Entry<UmaScriptByScope, UmaAuthorizationContext> entry : scriptMap.entrySet()) {
            if (!scopeDNs.contains(entry.getKey().getScope().getDn())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private static Map<UmaScriptByScope, UmaAuthorizationContext> filterByScopeId(Map<UmaScriptByScope, UmaAuthorizationContext> scriptMap, String scopeId) {
        HashMap<UmaScriptByScope, UmaAuthorizationContext> result = new HashMap<UmaScriptByScope, UmaAuthorizationContext>();
        for (Map.Entry<UmaScriptByScope, UmaAuthorizationContext> entry : scriptMap.entrySet()) {
            if (!entry.getKey().getScope().getId().equals(scopeId)) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

