/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.uma.authorization;

import java.net.URI;
import java.net.URLEncoder;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.error.DefaultErrorResponse;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.uma.UmaErrorResponseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UmaWebException
extends WebApplicationException {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmaWebException.class);

    private UmaWebException() {
    }

    public UmaWebException(String redirectUri, ErrorResponseFactory factory, UmaErrorResponseType error, String state) {
        super(UmaWebException.createRedirectErrorResponse(redirectUri, factory, error, state));
    }

    public static Response createRedirectErrorResponse(String redirectUri, ErrorResponseFactory factory, UmaErrorResponseType errorType, String state) {
        return Response.status((Response.Status)Response.Status.FOUND).location(UmaWebException.createErrorUri(redirectUri, factory, errorType, state)).build();
    }

    public static URI createErrorUri(String redirectUri, ErrorResponseFactory factory, UmaErrorResponseType errorType, String state) {
        try {
            DefaultErrorResponse error = factory.getErrorResponse((IErrorType)errorType);
            redirectUri = redirectUri.contains("?") ? redirectUri + "&" : redirectUri + "?";
            redirectUri = redirectUri + "error=" + error.getErrorCode();
            redirectUri = redirectUri + "&error_description=" + URLEncoder.encode(error.getErrorDescription(), "UTF-8");
            if (StringUtils.isNotBlank((String)error.getErrorUri())) {
                redirectUri = redirectUri + "&error_uri=" + URLEncoder.encode(error.getErrorUri(), "UTF-8");
            }
            if (StringUtils.isNotBlank((String)state)) {
                redirectUri = redirectUri + "&state=" + state;
            }
            return new URI(redirectUri);
        }
        catch (Exception e) {
            LOGGER.error("Failed to construct uri: " + redirectUri, (Throwable)e);
            throw factory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)UmaErrorResponseType.SERVER_ERROR, "Failed to construct uri");
        }
    }
}

