/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.session.ws.rs;

import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.client.service.ClientFactory;
import org.gluu.oxauth.model.util.Util;
import org.gluu.oxauth.util.ServerUtil;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndSessionUtils {
    private static final Logger log = LoggerFactory.getLogger(EndSessionUtils.class);

    private EndSessionUtils() {
    }

    public static ExecutorService getExecutorService() {
        return Executors.newCachedThreadPool(ServerUtil.daemonThreadFactory());
    }

    public static void callRpWithBackchannelUri(String backchannelLogoutUri, String logoutToken) {
        ResteasyClient client = new ResteasyClientBuilder().httpEngine((ClientHttpEngine)ClientFactory.instance().createEngine(true)).build();
        WebTarget target = client.target(backchannelLogoutUri);
        log.debug("Calling RP with backchannel, backchannel_logout_uri: " + backchannelLogoutUri);
        try (Response response = target.request().post(Entity.form((Form)new Form("logout_token", logoutToken)));){
            log.debug("Backchannel RP response, status: " + response.getStatus() + ", backchannel_logout_uri" + backchannelLogoutUri);
        }
        catch (Exception e) {
            log.error("Failed to call backchannel_logout_uri" + backchannelLogoutUri + ", message: " + e.getMessage(), (Throwable)e);
        }
    }

    public static String appendSid(String logoutUri, String sid, boolean appendSid) {
        if (!appendSid) {
            return logoutUri;
        }
        if (logoutUri.contains("?")) {
            return logoutUri + "&sid=" + sid;
        }
        return logoutUri + "?sid=" + sid;
    }

    public static String createFronthannelHtml(Set<String> logoutUris, String postLogoutUrl, String state) {
        String iframes = "";
        for (String logoutUri : logoutUris) {
            iframes = iframes + String.format("<iframe height=\"0\" width=\"0\" src=\"%s\" sandbox=\"allow-same-origin allow-scripts allow-popups allow-forms\"></iframe>", logoutUri);
        }
        String html = "<!DOCTYPE html><html><head>";
        if (!Util.isNullOrEmpty((String)postLogoutUrl)) {
            if (!Util.isNullOrEmpty((String)state)) {
                postLogoutUrl = postLogoutUrl.contains("?") ? postLogoutUrl + "&state=" + state : postLogoutUrl + "?state=" + state;
            }
            html = html + "<script>window.onload=function() {window.location='" + postLogoutUrl + "'}</script>";
        }
        html = html + "<title>Your logout was successful</title></head><body>Your logout was successful.<br/>" + iframes + "</body></html>";
        return html;
    }
}

