/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.session.ws.rs;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang.StringUtils;
import org.gluu.model.security.Identity;
import org.gluu.oxauth.audit.ApplicationAuditLogger;
import org.gluu.oxauth.model.audit.Action;
import org.gluu.oxauth.model.audit.OAuth2AuditLog;
import org.gluu.oxauth.model.common.AuthorizationGrant;
import org.gluu.oxauth.model.common.AuthorizationGrantList;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.error.ErrorHandlingMethod;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.gluu.GluuErrorResponseType;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.session.EndSessionErrorResponseType;
import org.gluu.oxauth.model.token.JsonWebResponse;
import org.gluu.oxauth.model.util.URLPatternList;
import org.gluu.oxauth.model.util.Util;
import org.gluu.oxauth.service.ClientService;
import org.gluu.oxauth.service.CookieService;
import org.gluu.oxauth.service.GrantService;
import org.gluu.oxauth.service.RedirectionUriService;
import org.gluu.oxauth.service.SessionIdService;
import org.gluu.oxauth.service.external.ExternalApplicationSessionService;
import org.gluu.oxauth.service.external.ExternalEndSessionService;
import org.gluu.oxauth.service.external.context.EndSessionContext;
import org.gluu.oxauth.session.ws.rs.EndSessionRestWebService;
import org.gluu.oxauth.session.ws.rs.EndSessionUtils;
import org.gluu.oxauth.session.ws.rs.LogoutTokenFactory;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.util.Pair;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@Path(value="/")
public class EndSessionRestWebServiceImpl
implements EndSessionRestWebService {
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private RedirectionUriService redirectionUriService;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private ExternalApplicationSessionService externalApplicationSessionService;
    @Inject
    private ExternalEndSessionService externalEndSessionService;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private CookieService cookieService;
    @Inject
    private ClientService clientService;
    @Inject
    private GrantService grantService;
    @Inject
    private Identity identity;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private LogoutTokenFactory logoutTokenFactory;

    @Override
    public Response requestEndSession(String idTokenHint, String postLogoutRedirectUri, String state, String sessionId, HttpServletRequest httpRequest, HttpServletResponse httpResponse, SecurityContext sec) {
        try {
            this.log.debug("Attempting to end session, idTokenHint: {}, postLogoutRedirectUri: {}, sessionId: {}, Is Secure = {}", new Object[]{idTokenHint, postLogoutRedirectUri, sessionId, sec.isSecure()});
            this.validateIdTokenHint(idTokenHint, postLogoutRedirectUri);
            this.validateSessionIdRequestParameter(sessionId, postLogoutRedirectUri);
            Pair<SessionId, AuthorizationGrant> pair = this.getPair(idTokenHint, sessionId, httpRequest);
            if (pair.getFirst() == null) {
                String reason = "Failed to identify session by session_id query parameter or by session_id cookie.";
                throw new WebApplicationException(this.createErrorResponse(postLogoutRedirectUri, EndSessionErrorResponseType.INVALID_GRANT_AND_SESSION, "Failed to identify session by session_id query parameter or by session_id cookie."));
            }
            postLogoutRedirectUri = this.validatePostLogoutRedirectUri(postLogoutRedirectUri, pair);
            this.endSession(pair, httpRequest, httpResponse);
            this.auditLogging(httpRequest, pair);
            Set<Client> clients = this.getSsoClients(pair);
            HashSet frontchannelUris = Sets.newHashSet();
            HashMap backchannelUris = Maps.newHashMap();
            for (Client client : clients) {
                boolean hasBackchannel = false;
                for (String logoutUri : client.getAttributes().getBackchannelLogoutUri()) {
                    if (Util.isNullOrEmpty((String)logoutUri)) continue;
                    backchannelUris.put(logoutUri, client);
                    hasBackchannel = true;
                }
                if (hasBackchannel) continue;
                for (String logoutUri : client.getFrontChannelLogoutUri()) {
                    if (Util.isNullOrEmpty((String)logoutUri)) continue;
                    frontchannelUris.add(EndSessionUtils.appendSid(logoutUri, ((SessionId)pair.getFirst()).getId(), client.getFrontChannelLogoutSessionRequired()));
                }
            }
            this.backChannel(backchannelUris, (AuthorizationGrant)pair.getSecond(), ((SessionId)pair.getFirst()).getId());
            if (frontchannelUris.isEmpty() && StringUtils.isNotBlank((String)postLogoutRedirectUri)) {
                this.log.trace("No frontchannel_redirect_uri's found in clients involved in SSO.");
                try {
                    this.log.trace("Redirect to postlogout_redirect_uri: " + postLogoutRedirectUri);
                    return Response.status((Response.Status)Response.Status.FOUND).location(new URI(postLogoutRedirectUri)).build();
                }
                catch (URISyntaxException e) {
                    String message = "Failed to create URI for " + postLogoutRedirectUri + " postlogout_redirect_uri.";
                    this.log.error(message);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)EndSessionErrorResponseType.INVALID_REQUEST, message)).build();
                }
            }
            return this.httpBased(frontchannelUris, postLogoutRedirectUri, state, pair, httpRequest);
        }
        catch (WebApplicationException e) {
            if (e.getResponse() != null) {
                return e.getResponse();
            }
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getJsonErrorResponse((IErrorType)GluuErrorResponseType.SERVER_ERROR)).build());
        }
    }

    private void backChannel(Map<String, Client> backchannelUris, AuthorizationGrant grant, String sessionId) throws InterruptedException {
        if (backchannelUris.isEmpty()) {
            return;
        }
        this.log.trace("backchannel_redirect_uri's: " + backchannelUris);
        ExecutorService executorService = EndSessionUtils.getExecutorService();
        for (Map.Entry<String, Client> entry : backchannelUris.entrySet()) {
            JsonWebResponse logoutToken = this.logoutTokenFactory.createLogoutToken(grant, sessionId);
            if (logoutToken == null) {
                this.log.error("Failed to create logout_token for client: " + entry.getValue().getClientId());
                return;
            }
            executorService.execute(() -> EndSessionUtils.callRpWithBackchannelUri((String)entry.getKey(), logoutToken.toString()));
        }
        executorService.shutdown();
        executorService.awaitTermination(30L, TimeUnit.SECONDS);
        this.log.trace("Finished backchannel calls.");
    }

    private Response createErrorResponse(String postLogoutRedirectUri, EndSessionErrorResponseType error, String reason) {
        this.log.debug(reason);
        try {
            if (this.allowPostLogoutRedirect(postLogoutRedirectUri)) {
                if (ErrorHandlingMethod.REMOTE == this.appConfiguration.getErrorHandlingMethod()) {
                    String separator = postLogoutRedirectUri.contains("?") ? "&" : "?";
                    postLogoutRedirectUri = postLogoutRedirectUri + separator + this.errorResponseFactory.getErrorAsQueryString((IErrorType)error, "", reason);
                }
                return Response.status((Response.Status)Response.Status.FOUND).location(new URI(postLogoutRedirectUri)).build();
            }
        }
        catch (URISyntaxException e) {
            this.log.error("Can't perform redirect", (Throwable)e);
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)error, reason)).build();
    }

    private boolean allowPostLogoutRedirect(String postLogoutRedirectUri) {
        if (StringUtils.isBlank((String)postLogoutRedirectUri)) {
            return false;
        }
        Boolean allowPostLogoutRedirectWithoutValidation = this.appConfiguration.getAllowPostLogoutRedirectWithoutValidation();
        return allowPostLogoutRedirectWithoutValidation != null && allowPostLogoutRedirectWithoutValidation != false && new URLPatternList(this.appConfiguration.getClientWhiteList()).isUrlListed(postLogoutRedirectUri);
    }

    private void validateSessionIdRequestParameter(String sessionId, String postLogoutRedirectUri) {
        SessionId sessionIdObject;
        if (StringUtils.isNotBlank((String)sessionId) && (sessionIdObject = this.sessionIdService.getSessionId(sessionId)) == null) {
            String reason = "session_id parameter in request is not valid. Logout is rejected. session_id parameter in request can be skipped or otherwise valid value must be provided.";
            this.log.error("session_id parameter in request is not valid. Logout is rejected. session_id parameter in request can be skipped or otherwise valid value must be provided.");
            throw new WebApplicationException(this.createErrorResponse(postLogoutRedirectUri, EndSessionErrorResponseType.INVALID_GRANT_AND_SESSION, "session_id parameter in request is not valid. Logout is rejected. session_id parameter in request can be skipped or otherwise valid value must be provided."));
        }
    }

    private void validateIdTokenHint(String idTokenHint, String postLogoutRedirectUri) {
        if (this.appConfiguration.getForceIdTokenHintPrecense().booleanValue() && StringUtils.isBlank((String)idTokenHint)) {
            String reason = "id_token_hint is not set";
            this.log.trace("id_token_hint is not set");
            throw new WebApplicationException(this.createErrorResponse(postLogoutRedirectUri, EndSessionErrorResponseType.INVALID_REQUEST, "id_token_hint is not set"));
        }
        AuthorizationGrant tokenHintGrant = this.getTokenHintGrant(idTokenHint);
        if (this.appConfiguration.getForceIdTokenHintPrecense().booleanValue() && tokenHintGrant == null) {
            String reason = "id_token_hint is not set";
            this.log.trace("id_token_hint is not set");
            throw new WebApplicationException(this.createErrorResponse(postLogoutRedirectUri, EndSessionErrorResponseType.INVALID_REQUEST, "id_token_hint is not set"));
        }
        if (StringUtils.isNotBlank((String)idTokenHint) && tokenHintGrant == null) {
            String reason = "id_token_hint is not valid. Logout is rejected. id_token_hint can be skipped or otherwise valid value must be provided.";
            throw new WebApplicationException(this.createErrorResponse(postLogoutRedirectUri, EndSessionErrorResponseType.INVALID_GRANT_AND_SESSION, "id_token_hint is not valid. Logout is rejected. id_token_hint can be skipped or otherwise valid value must be provided."));
        }
    }

    private AuthorizationGrant getTokenHintGrant(String idTokenHint) {
        if (StringUtils.isBlank((String)idTokenHint)) {
            return null;
        }
        AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByIdToken(idTokenHint);
        if (authorizationGrant != null) {
            return authorizationGrant;
        }
        Boolean endSessionWithAccessToken = this.appConfiguration.getEndSessionWithAccessToken();
        if (endSessionWithAccessToken != null && endSessionWithAccessToken.booleanValue()) {
            return this.authorizationGrantList.getAuthorizationGrantByAccessToken(idTokenHint);
        }
        return null;
    }

    private String validatePostLogoutRedirectUri(String postLogoutRedirectUri, Pair<SessionId, AuthorizationGrant> pair) {
        try {
            if (StringUtils.isBlank((String)postLogoutRedirectUri)) {
                return "";
            }
            if (this.appConfiguration.getAllowPostLogoutRedirectWithoutValidation().booleanValue()) {
                this.log.trace("Skipped post_logout_redirect_uri validation (because allowPostLogoutRedirectWithoutValidation=true)");
                return postLogoutRedirectUri;
            }
            String result = pair.getSecond() == null ? this.redirectionUriService.validatePostLogoutRedirectUri((SessionId)pair.getFirst(), postLogoutRedirectUri) : this.redirectionUriService.validatePostLogoutRedirectUri(((AuthorizationGrant)pair.getSecond()).getClient().getClientId(), postLogoutRedirectUri);
            if (StringUtils.isBlank((String)result)) {
                this.log.trace("Failed to validate post_logout_redirect_uri.");
                throw new WebApplicationException(this.createErrorResponse(postLogoutRedirectUri, EndSessionErrorResponseType.POST_LOGOUT_URI_NOT_ASSOCIATED_WITH_CLIENT, ""));
            }
            if (StringUtils.isNotBlank((String)result)) {
                return result;
            }
            this.log.trace("Unable to validate post_logout_redirect_uri.");
            throw new WebApplicationException(this.createErrorResponse(postLogoutRedirectUri, EndSessionErrorResponseType.POST_LOGOUT_URI_NOT_ASSOCIATED_WITH_CLIENT, ""));
        }
        catch (WebApplicationException e) {
            if (pair.getFirst() != null) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new WebApplicationException(this.createErrorResponse(postLogoutRedirectUri, EndSessionErrorResponseType.POST_LOGOUT_URI_NOT_ASSOCIATED_WITH_CLIENT, ""));
            }
            throw e;
        }
    }

    private Response httpBased(Set<String> frontchannelUris, String postLogoutRedirectUri, String state, Pair<SessionId, AuthorizationGrant> pair, HttpServletRequest httpRequest) {
        try {
            EndSessionContext context = new EndSessionContext(httpRequest, frontchannelUris, postLogoutRedirectUri, (SessionId)pair.getFirst());
            String htmlFromScript = this.externalEndSessionService.getFrontchannelHtml(context);
            if (StringUtils.isNotBlank((String)htmlFromScript)) {
                this.log.debug("HTML from `getFrontchannelHtml` external script: " + htmlFromScript);
                return this.okResponse(htmlFromScript);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        String html = EndSessionUtils.createFronthannelHtml(frontchannelUris, postLogoutRedirectUri, state);
        this.log.debug("Constructed html logout page: " + html);
        return this.okResponse(html);
    }

    private Response okResponse(String html) {
        return Response.ok().cacheControl(ServerUtil.cacheControl(true, true)).header("Pragma", (Object)"no-cache").type(MediaType.TEXT_HTML_TYPE).entity((Object)html).build();
    }

    private Pair<SessionId, AuthorizationGrant> getPair(String idTokenHint, String sessionId, HttpServletRequest httpRequest) {
        Boolean endSessionWithAccessToken;
        AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByIdToken(idTokenHint);
        if (authorizationGrant == null && (endSessionWithAccessToken = this.appConfiguration.getEndSessionWithAccessToken()) != null && endSessionWithAccessToken.booleanValue()) {
            authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(idTokenHint);
        }
        SessionId ldapSessionId = null;
        try {
            String id = sessionId;
            if (StringHelper.isEmpty((String)id)) {
                id = this.cookieService.getSessionIdFromCookie(httpRequest);
            }
            if (StringHelper.isNotEmpty((String)id)) {
                ldapSessionId = this.sessionIdService.getSessionId(id);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to current session id.", (Throwable)e);
        }
        return new Pair(ldapSessionId, (Object)authorizationGrant);
    }

    private void endSession(Pair<SessionId, AuthorizationGrant> pair, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        boolean isGrantAndExternalLogoutSuccessful;
        this.removeConsentSessionId(httpRequest, httpResponse);
        this.removeSessionId(pair, httpResponse);
        boolean externalLogoutResult = false;
        boolean isExternalLogoutPresent = this.externalApplicationSessionService.isEnabled();
        if (isExternalLogoutPresent) {
            String userName = ((SessionId)pair.getFirst()).getSessionAttributes().get("auth_user");
            externalLogoutResult = this.externalApplicationSessionService.executeExternalEndSessionMethods(httpRequest, (SessionId)pair.getFirst());
            this.log.info("End session result for '{}': '{}'", new Object[]{userName, "logout", externalLogoutResult});
        }
        boolean bl = isGrantAndExternalLogoutSuccessful = isExternalLogoutPresent && externalLogoutResult;
        if (isExternalLogoutPresent && !isGrantAndExternalLogoutSuccessful) {
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.UNAUTHORIZED, (IErrorType)EndSessionErrorResponseType.INVALID_GRANT, "External logout is present but executed external logout script returned failed result.");
        }
        this.grantService.logout(((SessionId)pair.getFirst()).getDn());
        if (this.identity != null) {
            this.identity.logout();
        }
    }

    private Set<Client> getSsoClients(Pair<SessionId, AuthorizationGrant> pair) {
        HashSet clients;
        SessionId sessionId = (SessionId)pair.getFirst();
        AuthorizationGrant authorizationGrant = (AuthorizationGrant)pair.getSecond();
        if (sessionId == null) {
            this.log.error("session_id is not passed to endpoint (as cookie or manually). Therefore unable to match clients for session_id.");
            return Sets.newHashSet();
        }
        Set<Object> set = clients = sessionId.getPermissionGrantedMap() != null ? this.clientService.getClient(sessionId.getPermissionGrantedMap().getClientIds(true), true) : Sets.newHashSet();
        if (authorizationGrant != null) {
            clients.add(authorizationGrant.getClient());
        }
        return clients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSessionId(Pair<SessionId, AuthorizationGrant> pair, HttpServletResponse httpResponse) {
        try {
            boolean result = this.sessionIdService.remove((SessionId)pair.getFirst());
            if (!result) {
                this.log.error("Failed to remove session_id '{}'", (Object)((SessionId)pair.getFirst()).getId());
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.cookieService.removeSessionIdCookie(httpResponse);
            this.cookieService.removeOPBrowserStateCookie(httpResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConsentSessionId(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            String id = this.cookieService.getConsentSessionIdFromCookie(httpRequest);
            if (StringHelper.isNotEmpty((String)id)) {
                SessionId ldapSessionId = this.sessionIdService.getSessionId(id);
                if (ldapSessionId != null) {
                    boolean result = this.sessionIdService.remove(ldapSessionId);
                    if (!result) {
                        this.log.error("Failed to remove consent_session_id '{}'", (Object)id);
                    }
                } else {
                    this.log.error("Failed to load session by consent_session_id: '{}'", (Object)id);
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.cookieService.removeConsentSessionIdCookie(httpResponse);
        }
    }

    private void auditLogging(HttpServletRequest request, Pair<SessionId, AuthorizationGrant> pair) {
        SessionId sessionId = (SessionId)pair.getFirst();
        AuthorizationGrant authorizationGrant = (AuthorizationGrant)pair.getSecond();
        OAuth2AuditLog oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(request), Action.SESSION_DESTROYED);
        oAuth2AuditLog.setSuccess(true);
        if (authorizationGrant != null) {
            oAuth2AuditLog.setClientId(authorizationGrant.getClientId());
            oAuth2AuditLog.setScope(StringUtils.join(authorizationGrant.getScopes(), (String)" "));
            oAuth2AuditLog.setUsername(authorizationGrant.getUserId());
        } else if (sessionId != null) {
            oAuth2AuditLog.setClientId(sessionId.getPermissionGrantedMap().getClientIds(true).toString());
            oAuth2AuditLog.setScope(sessionId.getSessionAttributes().get("scope"));
            oAuth2AuditLog.setUsername(sessionId.getUserDn());
        }
        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
    }
}

