/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service.token;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.common.AuthorizationGrant;
import org.gluu.oxauth.model.common.AuthorizationGrantList;
import org.gluu.oxauth.model.token.HttpAuthTokenType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
public class TokenService {
    @Inject
    private AuthorizationGrantList authorizationGrantList;

    public boolean isToken(@Nullable String authorizationParameter, @NotNull HttpAuthTokenType tokenType) {
        return StringUtils.startsWithIgnoreCase((String)authorizationParameter, (String)tokenType.getPrefix());
    }

    @Nullable
    public String extractToken(@Nullable String authorizationParameter, @NotNull HttpAuthTokenType tokenType) {
        if (this.isToken(authorizationParameter, tokenType) && authorizationParameter != null) {
            return authorizationParameter.substring(tokenType.getPrefix().length()).trim();
        }
        return null;
    }

    public boolean isBasicAuthToken(@Nullable String authorizationParameter) {
        return this.isToken(authorizationParameter, HttpAuthTokenType.Basic);
    }

    public boolean isBearerAuthToken(@Nullable String authorizationParameter) {
        return this.isToken(authorizationParameter, HttpAuthTokenType.Bearer);
    }

    @Nullable
    public String getBasicToken(@Nullable String authorizationParameter) {
        return this.extractToken(authorizationParameter, HttpAuthTokenType.Basic);
    }

    @Nullable
    public String getBearerToken(@Nullable String authorizationParameter) {
        return this.extractToken(authorizationParameter, HttpAuthTokenType.Bearer);
    }

    @Nullable
    public String getToken(@Nullable String authorization) {
        return this.getToken(authorization, HttpAuthTokenType.values());
    }

    @Nullable
    public String getToken(@Nullable String authorization, HttpAuthTokenType ... allowedTokenTypes) {
        if (StringUtils.isBlank((String)authorization) || allowedTokenTypes == null || allowedTokenTypes.length == 0) {
            return null;
        }
        for (HttpAuthTokenType tokenType : allowedTokenTypes) {
            if (tokenType == null || !this.isToken(authorization, tokenType)) continue;
            return this.extractToken(authorization, tokenType);
        }
        return null;
    }

    @Nullable
    public AuthorizationGrant getAuthorizationGrant(@Nullable String authorization) {
        String token = this.getToken(authorization);
        if (StringUtils.isNotBlank((String)token)) {
            return this.authorizationGrantList.getAuthorizationGrantByAccessToken(token);
        }
        return null;
    }

    @Nullable
    public AuthorizationGrant getBearerAuthorizationGrant(@Nullable String authorization) {
        return this.getAuthorizationGrant(authorization, HttpAuthTokenType.Bearer);
    }

    @Nullable
    public AuthorizationGrant getBasicAuthorizationGrant(@Nullable String authorization) {
        return this.getAuthorizationGrant(authorization, HttpAuthTokenType.Basic);
    }

    @Nullable
    public AuthorizationGrant getAuthorizationGrant(@Nullable String authorization, @Nullable HttpAuthTokenType tokenType) {
        String token = this.getToken(authorization, tokenType);
        if (StringUtils.isNotBlank((String)token)) {
            return this.authorizationGrantList.getAuthorizationGrantByAccessToken(token);
        }
        return null;
    }

    @NotNull
    public String getClientDn(@Nullable String p_authorization) {
        AuthorizationGrant grant = this.getAuthorizationGrant(p_authorization);
        if (grant != null) {
            return grant.getClientDn();
        }
        return "";
    }
}

