/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service.fido.u2f;

import java.util.Map;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.common.SessionIdState;
import org.gluu.oxauth.model.fido.u2f.DeviceRegistrationResult;
import org.gluu.oxauth.service.SessionIdService;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@Stateless
@Named
public class UserSessionIdService {
    @Inject
    private Logger log;
    @Inject
    private SessionIdService sessionIdService;

    public void updateUserSessionIdOnFinishRequest(String sessionId, String userInum, DeviceRegistrationResult deviceRegistrationResult, boolean enroll, boolean oneStep) {
        SessionId ldapSessionId = this.getLdapSessionId(sessionId);
        if (ldapSessionId == null) {
            return;
        }
        Map<String, String> sessionAttributes = ldapSessionId.getSessionAttributes();
        if (DeviceRegistrationResult.Status.APPROVED == deviceRegistrationResult.getStatus()) {
            sessionAttributes.put("session_custom_state", "approved");
        } else {
            sessionAttributes.put("session_custom_state", "declined");
        }
        sessionAttributes.put("oxpush2_u2f_device_id", deviceRegistrationResult.getDeviceRegistration().getId());
        sessionAttributes.put("oxpush2_u2f_device_user_inum", userInum);
        sessionAttributes.put("oxpush2_u2f_device_enroll", Boolean.toString(enroll));
        sessionAttributes.put("oxpush2_u2f_device_one_step", Boolean.toString(oneStep));
        this.sessionIdService.updateSessionId(ldapSessionId, true);
    }

    public void updateUserSessionIdOnError(String sessionId) {
        SessionId ldapSessionId = this.getLdapSessionId(sessionId);
        if (ldapSessionId == null) {
            return;
        }
        Map<String, String> sessionAttributes = ldapSessionId.getSessionAttributes();
        sessionAttributes.put("session_custom_state", "declined");
        this.sessionIdService.updateSessionId(ldapSessionId, true);
    }

    private SessionId getLdapSessionId(String sessionId) {
        if (StringHelper.isEmpty((String)sessionId)) {
            return null;
        }
        SessionId ldapSessionId = this.sessionIdService.getSessionId(sessionId);
        if (ldapSessionId == null) {
            this.log.warn("Failed to load session id '{}'", (Object)sessionId);
            return null;
        }
        if (SessionIdState.UNAUTHENTICATED != ldapSessionId.getState()) {
            this.log.warn("Unexpected session id '{}' state: '{}'", (Object)sessionId, (Object)ldapSessionId.getState());
            return null;
        }
        return ldapSessionId;
    }
}

