/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service.fido.u2f;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import javax.ejb.Stateless;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.oxauth.crypto.random.ChallengeGenerator;
import org.gluu.oxauth.crypto.signature.SHA256withECDSASignatureVerification;
import org.gluu.oxauth.exception.fido.u2f.DeviceCompromisedException;
import org.gluu.oxauth.exception.fido.u2f.InvalidKeyHandleDeviceException;
import org.gluu.oxauth.exception.fido.u2f.NoEligableDevicesException;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.oxauth.model.fido.u2f.AuthenticateRequestMessageLdap;
import org.gluu.oxauth.model.fido.u2f.DeviceRegistration;
import org.gluu.oxauth.model.fido.u2f.DeviceRegistrationResult;
import org.gluu.oxauth.model.fido.u2f.exception.BadInputException;
import org.gluu.oxauth.model.fido.u2f.message.RawAuthenticateResponse;
import org.gluu.oxauth.model.fido.u2f.protocol.AuthenticateRequest;
import org.gluu.oxauth.model.fido.u2f.protocol.AuthenticateRequestMessage;
import org.gluu.oxauth.model.fido.u2f.protocol.AuthenticateResponse;
import org.gluu.oxauth.model.fido.u2f.protocol.ClientData;
import org.gluu.oxauth.model.util.Base64Util;
import org.gluu.oxauth.service.common.UserService;
import org.gluu.oxauth.service.fido.u2f.ApplicationService;
import org.gluu.oxauth.service.fido.u2f.ClientDataValidationService;
import org.gluu.oxauth.service.fido.u2f.DeviceRegistrationService;
import org.gluu.oxauth.service.fido.u2f.RawAuthenticationService;
import org.gluu.oxauth.service.fido.u2f.RequestService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.search.filter.Filter;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@Stateless
@Named(value="u2fAuthenticationService")
public class AuthenticationService
extends RequestService {
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private ApplicationService applicationService;
    @Inject
    private RawAuthenticationService rawAuthenticationService;
    @Inject
    private ClientDataValidationService clientDataValidationService;
    @Inject
    private DeviceRegistrationService deviceRegistrationService;
    @Inject
    private UserService userService;
    @Inject
    @Named(value="randomChallengeGenerator")
    private ChallengeGenerator challengeGenerator;
    @Inject
    private StaticConfiguration staticConfiguration;

    @Produces
    @ApplicationScoped
    @Named(value="sha256withECDSASignatureVerification")
    public SHA256withECDSASignatureVerification getBouncyCastleSignatureVerification() {
        return new SHA256withECDSASignatureVerification();
    }

    public AuthenticateRequestMessage buildAuthenticateRequestMessage(String appId, String userInum) throws BadInputException, NoEligableDevicesException {
        if (this.applicationService.isValidateApplication()) {
            this.applicationService.checkIsValid(appId);
        }
        ArrayList<AuthenticateRequest> authenticateRequests = new ArrayList<AuthenticateRequest>();
        byte[] challenge = this.challengeGenerator.generateChallenge();
        List<DeviceRegistration> deviceRegistrations = this.deviceRegistrationService.findUserDeviceRegistrations(userInum, appId, new String[0]);
        for (DeviceRegistration deviceRegistration : deviceRegistrations) {
            if (deviceRegistration.isCompromised()) continue;
            try {
                AuthenticateRequest request = this.startAuthentication(appId, deviceRegistration, challenge);
                authenticateRequests.add(request);
            }
            catch (DeviceCompromisedException ex) {
                this.log.error("Faield to authenticate device", (Throwable)ex);
            }
        }
        if (authenticateRequests.isEmpty()) {
            if (deviceRegistrations.isEmpty()) {
                throw new NoEligableDevicesException(deviceRegistrations, "No devices registrered");
            }
            throw new NoEligableDevicesException(deviceRegistrations, "All devices compromised");
        }
        return new AuthenticateRequestMessage(authenticateRequests);
    }

    public AuthenticateRequest startAuthentication(String appId, DeviceRegistration device) throws DeviceCompromisedException {
        return this.startAuthentication(appId, device, this.challengeGenerator.generateChallenge());
    }

    public AuthenticateRequest startAuthentication(String appId, DeviceRegistration device, byte[] challenge) throws DeviceCompromisedException {
        if (device.isCompromised()) {
            throw new DeviceCompromisedException(device, "Device has been marked as compromised, cannot authenticate");
        }
        return new AuthenticateRequest(Base64Util.base64urlencode((byte[])challenge), appId, device.getKeyHandle());
    }

    public DeviceRegistrationResult finishAuthentication(AuthenticateRequestMessage requestMessage, AuthenticateResponse response, String userInum) throws BadInputException, DeviceCompromisedException {
        return this.finishAuthentication(requestMessage, response, userInum, null);
    }

    public DeviceRegistrationResult finishAuthentication(AuthenticateRequestMessage requestMessage, AuthenticateResponse response, String userInum, Set<String> facets) throws BadInputException, DeviceCompromisedException {
        List<DeviceRegistration> deviceRegistrations = this.deviceRegistrationService.findUserDeviceRegistrations(userInum, requestMessage.getAppId(), new String[0]);
        AuthenticateRequest request = this.getAuthenticateRequest(requestMessage, response);
        DeviceRegistration usedDeviceRegistration = null;
        for (DeviceRegistration deviceRegistration : deviceRegistrations) {
            if (!StringHelper.equals((String)request.getKeyHandle(), (String)deviceRegistration.getKeyHandle())) continue;
            usedDeviceRegistration = deviceRegistration;
            break;
        }
        if (usedDeviceRegistration == null) {
            throw new BadInputException("Failed to find DeviceRegistration for the given AuthenticateRequest");
        }
        if (usedDeviceRegistration.isCompromised()) {
            throw new DeviceCompromisedException(usedDeviceRegistration, "The device is marked as possibly compromised, and cannot be authenticated");
        }
        ClientData clientData = response.getClientData();
        this.clientDataValidationService.checkContent(clientData, RawAuthenticationService.SUPPORTED_AUTHENTICATE_TYPES, request.getChallenge(), facets);
        RawAuthenticateResponse rawAuthenticateResponse = this.rawAuthenticationService.parseRawAuthenticateResponse(response.getSignatureData());
        this.rawAuthenticationService.checkSignature(request.getAppId(), clientData, rawAuthenticateResponse, Base64Util.base64urldecode((String)usedDeviceRegistration.getDeviceRegistrationConfiguration().getPublicKey()));
        rawAuthenticateResponse.checkUserPresence();
        usedDeviceRegistration.checkAndUpdateCounter(rawAuthenticateResponse.getCounter());
        usedDeviceRegistration.setLastAccessTime(new Date());
        this.deviceRegistrationService.updateDeviceRegistration(userInum, usedDeviceRegistration);
        DeviceRegistrationResult.Status status = DeviceRegistrationResult.Status.APPROVED;
        boolean approved = StringHelper.equals((String)"navigator.id.getAssertion", (String)clientData.getTyp());
        if (!approved) {
            status = DeviceRegistrationResult.Status.CANCELED;
            this.log.debug("Authentication request with keyHandle '{}' was canceled", (Object)response.getKeyHandle());
        }
        return new DeviceRegistrationResult(usedDeviceRegistration, status);
    }

    public AuthenticateRequest getAuthenticateRequest(AuthenticateRequestMessage requestMessage, AuthenticateResponse response) throws BadInputException {
        if (!StringHelper.equals((String)requestMessage.getRequestId(), (String)response.getRequestId())) {
            throw new BadInputException("Wrong request for response data");
        }
        for (AuthenticateRequest request : requestMessage.getAuthenticateRequests()) {
            if (!StringHelper.equals((String)request.getKeyHandle(), (String)response.getKeyHandle())) continue;
            return request;
        }
        throw new BadInputException("Responses keyHandle does not match any contained request");
    }

    public void storeAuthenticationRequestMessage(AuthenticateRequestMessage requestMessage, String userInum, String sessionId) {
        Date now = new GregorianCalendar(TimeZone.getTimeZone("UTC")).getTime();
        String authenticateRequestMessageId = UUID.randomUUID().toString();
        AuthenticateRequestMessageLdap authenticateRequestMessageLdap = new AuthenticateRequestMessageLdap(this.getDnForAuthenticateRequestMessage(authenticateRequestMessageId), authenticateRequestMessageId, now, sessionId, userInum, requestMessage);
        this.ldapEntryManager.persist((Object)authenticateRequestMessageLdap);
    }

    public AuthenticateRequestMessage getAuthenticationRequestMessage(String oxId) {
        String requestDn = this.getDnForAuthenticateRequestMessage(oxId);
        AuthenticateRequestMessageLdap authenticateRequestMessageLdap = (AuthenticateRequestMessageLdap)this.ldapEntryManager.find(AuthenticateRequestMessageLdap.class, (Object)requestDn);
        if (authenticateRequestMessageLdap == null) {
            return null;
        }
        return authenticateRequestMessageLdap.getAuthenticateRequestMessage();
    }

    public AuthenticateRequestMessageLdap getAuthenticationRequestMessageByRequestId(String requestId) {
        Filter requestIdFilter;
        String baseDn = this.getDnForAuthenticateRequestMessage(null);
        List authenticateRequestMessagesLdap = this.ldapEntryManager.findEntries(baseDn, AuthenticateRequestMessageLdap.class, requestIdFilter = Filter.createEqualityFilter((String)"oxRequestId", (Object)requestId));
        if (authenticateRequestMessagesLdap == null || authenticateRequestMessagesLdap.isEmpty()) {
            return null;
        }
        return (AuthenticateRequestMessageLdap)authenticateRequestMessagesLdap.get(0);
    }

    public void removeAuthenticationRequestMessage(AuthenticateRequestMessageLdap authenticateRequestMessageLdap) {
        this.removeRequestMessage(authenticateRequestMessageLdap);
    }

    public String getUserInumByKeyHandle(String appId, String keyHandle) throws InvalidKeyHandleDeviceException {
        if (StringHelper.isEmpty((String)appId) || StringHelper.isEmpty((String)keyHandle)) {
            return null;
        }
        List<DeviceRegistration> deviceRegistrations = this.deviceRegistrationService.findDeviceRegistrationsByKeyHandle(appId, keyHandle, "oxId");
        if (deviceRegistrations.isEmpty()) {
            throw new InvalidKeyHandleDeviceException(String.format("Failed to find device by keyHandle '%s' in LDAP", keyHandle));
        }
        if (deviceRegistrations.size() != 1) {
            throw new BadInputException(String.format("There are '%d' devices with keyHandle '%s' in LDAP", deviceRegistrations.size(), keyHandle));
        }
        DeviceRegistration deviceRegistration = deviceRegistrations.get(0);
        return this.userService.getUserInumByDn(deviceRegistration.getDn());
    }

    public String getDnForAuthenticateRequestMessage(String oxId) {
        String u2fBaseDn = this.staticConfiguration.getBaseDn().getU2fBase();
        if (StringHelper.isEmpty((String)oxId)) {
            return String.format("ou=authentication_requests,%s", u2fBaseDn);
        }
        return String.format("oxid=%s,ou=authentication_requests,%s", oxId, u2fBaseDn);
    }
}

