/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import javax.ejb.DependsOn;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.model.ApplicationType;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.service.common.ConfigurationService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.service.metric.inject.ReportMetric;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named(value="metricService")
public class MetricService
extends org.gluu.service.metric.MetricService {
    public static final String METRIC_SERVICE_COMPONENT_NAME = "metricService";
    private static final long serialVersionUID = 7875838160379126796L;
    @Inject
    private Instance<MetricService> instance;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    @Named(value="persistenceMetricEntryManager")
    @ReportMetric
    private PersistenceEntryManager ldapEntryManager;

    public void initTimer() {
        this.initTimer(this.appConfiguration.getMetricReporterInterval(), this.appConfiguration.getMetricReporterKeepDataDays());
    }

    public String baseDn() {
        return this.staticConfiguration.getBaseDn().getMetric();
    }

    public org.gluu.service.metric.MetricService getMetricServiceInstance() {
        return (org.gluu.service.metric.MetricService)this.instance.get();
    }

    public boolean isMetricReporterEnabled() {
        if (this.appConfiguration.getMetricReporterEnabled() == null) {
            return false;
        }
        return this.appConfiguration.getMetricReporterEnabled();
    }

    public ApplicationType getApplicationType() {
        return ApplicationType.OX_AUTH;
    }

    public PersistenceEntryManager getEntryManager() {
        return this.ldapEntryManager;
    }
}

