/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import javax.enterprise.context.ApplicationScoped;
import javax.faces.application.FacesMessage;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.jsf2.message.FacesMessages;
import org.gluu.jsf2.service.FacesService;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.error.ErrorHandlingMethod;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.service.CookieService;
import org.gluu.oxauth.service.SessionIdService;
import org.gluu.oxauth.util.RedirectUri;
import org.gluu.util.StringHelper;
import org.python.jline.internal.Log;
import org.slf4j.Logger;

@ApplicationScoped
@Named
public class ErrorHandlerService {
    @Inject
    private Logger log;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private CookieService cookieService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private FacesService facesService;
    @Inject
    private FacesMessages facesMessages;

    public void handleError(String facesMessageId, IErrorType errorType, String hint) {
        if (ErrorHandlingMethod.REMOTE == this.appConfiguration.getErrorHandlingMethod()) {
            this.handleRemoteError(facesMessageId, errorType, hint);
        } else {
            this.handleLocalError(facesMessageId);
        }
    }

    private void addMessage(FacesMessage.Severity severity, String facesMessageId) {
        if (StringHelper.isNotEmpty((String)facesMessageId)) {
            this.facesMessages.add(FacesMessage.SEVERITY_ERROR, String.format("#{msg['%s']}", facesMessageId));
        }
    }

    private void handleLocalError(String facesMessageId) {
        this.addMessage(FacesMessage.SEVERITY_ERROR, facesMessageId);
        this.facesService.redirect("/error.xhtml");
    }

    private void handleRemoteError(String facesMessageId, IErrorType errorType, String hint) {
        String redirectUri = this.cookieService.getRpOriginIdCookie();
        if (StringHelper.isEmpty((String)redirectUri)) {
            Log.error((Object[])new Object[]{"Failed to get redirect_uri from cookie"});
            this.handleLocalError(facesMessageId);
            return;
        }
        RedirectUri redirectUriResponse = new RedirectUri(redirectUri, null, null);
        redirectUriResponse.parseQueryString(this.errorResponseFactory.getErrorAsQueryString(errorType, null));
        if (StringHelper.isNotEmpty((String)hint)) {
            redirectUriResponse.addResponseParameter("hint", "Create authorization request to start new authentication session.");
        }
        this.facesService.redirectToExternalURL(redirectUriResponse.toString());
    }
}

