/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.oxauth.model.common.AuthenticationMethod;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.exception.InvalidClaimException;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.service.ScopeService;
import org.gluu.oxauth.service.common.EncryptionService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.exception.EntryPersistenceException;
import org.gluu.persist.model.base.CustomAttribute;
import org.gluu.persist.model.base.CustomEntry;
import org.gluu.service.BaseCacheService;
import org.gluu.service.CacheService;
import org.gluu.service.LocalCacheService;
import org.gluu.util.StringHelper;
import org.gluu.util.security.StringEncrypter;
import org.json.JSONArray;
import org.oxauth.persistence.model.Scope;
import org.python.jline.internal.Preconditions;
import org.slf4j.Logger;

@Stateless
@Named
public class ClientService {
    public static final String[] CLIENT_OBJECT_CLASSES = new String[]{"oxAuthClient"};
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private CacheService cacheService;
    @Inject
    private LocalCacheService localCacheService;
    @Inject
    private ScopeService scopeService;
    @Inject
    private EncryptionService encryptionService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private StaticConfiguration staticConfiguration;

    public void persist(Client client) {
        this.ldapEntryManager.persist((Object)client);
    }

    public void merge(Client client) {
        this.ldapEntryManager.merge((Object)client);
        this.removeFromCache(client);
    }

    public boolean authenticate(String clientId, String password) {
        this.log.debug("Authenticating Client with LDAP: clientId = {}", (Object)clientId);
        boolean authenticated = false;
        try {
            Client client = this.getClient(clientId);
            if (client == null) {
                this.log.debug("Failed to find client = {}", (Object)clientId);
                return authenticated;
            }
            String decryptedClientSecret = this.decryptSecret(client.getClientSecret());
            authenticated = client != null && decryptedClientSecret != null && decryptedClientSecret.equals(password);
        }
        catch (StringEncrypter.EncryptionException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return authenticated;
    }

    public Set<Client> getClient(Collection<String> clientIds, boolean silent) {
        HashSet set = Sets.newHashSet();
        if (clientIds == null) {
            return set;
        }
        for (String clientId : clientIds) {
            try {
                Client client = this.getClient(clientId);
                if (client == null) continue;
                set.add(client);
            }
            catch (RuntimeException e) {
                if (silent) continue;
                throw e;
            }
        }
        return set;
    }

    public Client getClient(String clientId) {
        if (clientId != null && !clientId.isEmpty()) {
            Client result = this.getClientByDn(this.buildClientDn(clientId));
            this.log.debug("Found {} entries for client id = {}", (Object)(result != null ? 1 : 0), (Object)clientId);
            return result;
        }
        return null;
    }

    public boolean isPublic(String clientId) {
        return this.isPublic(this.getClient(clientId));
    }

    public boolean isPublic(Client client) {
        return client != null && client.getAuthenticationMethod() == AuthenticationMethod.NONE;
    }

    public Client getClient(String clientId, String registrationAccessToken) {
        Client client = this.getClient(clientId);
        if (client != null && registrationAccessToken != null && registrationAccessToken.equals(client.getRegistrationAccessToken())) {
            return client;
        }
        return null;
    }

    public Set<Client> getClientsByDns(Collection<String> dnList) {
        return this.getClientsByDns(dnList, true);
    }

    public Set<Client> getClientsByDns(Collection<String> dnList, boolean silently) {
        Preconditions.checkNotNull(dnList);
        HashSet result = Sets.newHashSet();
        for (String clientDn : dnList) {
            try {
                result.add(this.getClientByDn(clientDn));
            }
            catch (RuntimeException e) {
                if (silently) continue;
                throw e;
            }
        }
        return result;
    }

    public Client getClientByDn(String dn) {
        BaseCacheService usedCacheService = this.getCacheService();
        try {
            return (Client)usedCacheService.getWithPut(dn, () -> (Client)this.ldapEntryManager.find(Client.class, (Object)dn), 60);
        }
        catch (Exception e) {
            this.log.trace(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public CustomAttribute getCustomAttribute(Client client, String attributeName) {
        for (CustomAttribute customAttribute : client.getCustomAttributes()) {
            if (!StringHelper.equalsIgnoreCase((String)attributeName, (String)customAttribute.getName())) continue;
            return customAttribute;
        }
        return null;
    }

    public void setCustomAttribute(Client client, String attributeName, String attributeValue) {
        CustomAttribute customAttribute = this.getCustomAttribute(client, attributeName);
        if (customAttribute == null) {
            customAttribute = new CustomAttribute(attributeName);
            client.getCustomAttributes().add(customAttribute);
        }
        customAttribute.setValue(attributeValue);
    }

    public List<Client> getAllClients(String[] returnAttributes) {
        String baseDn = this.staticConfiguration.getBaseDn().getClients();
        List result = this.ldapEntryManager.findEntries(baseDn, Client.class, null, returnAttributes);
        return result;
    }

    public List<Client> getAllClients(String[] returnAttributes, int size) {
        String baseDn = this.staticConfiguration.getBaseDn().getClients();
        List result = this.ldapEntryManager.findEntries(baseDn, Client.class, null, returnAttributes, size);
        return result;
    }

    public String buildClientDn(String p_clientId) {
        StringBuilder dn = new StringBuilder();
        dn.append(String.format("inum=%s,", p_clientId));
        dn.append(this.staticConfiguration.getBaseDn().getClients());
        return dn.toString();
    }

    public void remove(Client client) {
        if (client != null) {
            this.removeFromCache(client);
            String clientDn = client.getDn();
            this.ldapEntryManager.removeRecursively(clientDn);
        }
    }

    private void removeFromCache(Client client) {
        BaseCacheService usedCacheService = this.getCacheService();
        try {
            usedCacheService.remove(client.getDn());
        }
        catch (Exception e) {
            this.log.error("Failed to remove client from cache." + client.getDn(), (Throwable)e);
        }
    }

    public void updateAccessTime(Client client, boolean isUpdateLogonTime) {
        if (!this.appConfiguration.getUpdateClientAccessTime().booleanValue()) {
            return;
        }
        String clientDn = client.getDn();
        CustomEntry customEntry = new CustomEntry();
        customEntry.setDn(clientDn);
        customEntry.setCustomObjectClasses(CLIENT_OBJECT_CLASSES);
        Date now = new GregorianCalendar(TimeZone.getTimeZone("UTC")).getTime();
        String nowDateString = this.ldapEntryManager.encodeTime(customEntry.getDn(), now);
        CustomAttribute customAttributeLastAccessTime = new CustomAttribute("oxLastAccessTime", nowDateString);
        customEntry.getCustomAttributes().add(customAttributeLastAccessTime);
        if (isUpdateLogonTime) {
            CustomAttribute customAttributeLastLogonTime = new CustomAttribute("oxLastLogonTime", nowDateString);
            customEntry.getCustomAttributes().add(customAttributeLastLogonTime);
        }
        try {
            this.ldapEntryManager.merge((Object)customEntry);
        }
        catch (EntryPersistenceException epe) {
            this.log.error("Failed to update oxLastAccessTime and oxLastLogonTime of client '{}'", (Object)clientDn);
        }
        this.removeFromCache(client);
    }

    public Object getAttribute(Client client, String clientAttribute) throws InvalidClaimException {
        String attribute = null;
        if (clientAttribute != null) {
            if (clientAttribute.equals("displayName")) {
                attribute = client.getClientName();
            } else if (clientAttribute.equals("inum")) {
                attribute = client.getClientId();
            } else if (clientAttribute.equals("oxAuthAppType")) {
                attribute = client.getApplicationType();
            } else if (clientAttribute.equals("oxAuthIdTokenSignedResponseAlg")) {
                attribute = client.getIdTokenSignedResponseAlg();
            } else if (clientAttribute.equals("oxAuthRedirectURI") && client.getRedirectUris() != null) {
                JSONArray array = new JSONArray();
                for (String redirectUri : client.getRedirectUris()) {
                    array.put((Object)redirectUri);
                }
                attribute = array;
            } else if (clientAttribute.equals("oxAuthScope") && client.getScopes() != null) {
                JSONArray array = new JSONArray();
                for (String scopeDN : client.getScopes()) {
                    Scope s = this.scopeService.getScopeByDn(scopeDN);
                    if (s == null) continue;
                    String scopeName = s.getId();
                    array.put((Object)scopeName);
                }
                attribute = array;
            } else {
                for (CustomAttribute customAttribute : client.getCustomAttributes()) {
                    if (!customAttribute.getName().equals(clientAttribute)) continue;
                    List values = customAttribute.getValues();
                    if (values == null) break;
                    if (values.size() == 1) {
                        attribute = values.get(0);
                        break;
                    }
                    JSONArray array = new JSONArray();
                    for (String v : values) {
                        array.put((Object)v);
                    }
                    attribute = array;
                    break;
                }
            }
        }
        return attribute;
    }

    public String decryptSecret(String encryptedClientSecret) throws StringEncrypter.EncryptionException {
        return this.encryptionService.decrypt(encryptedClientSecret);
    }

    public String encryptSecret(String clientSecret) throws StringEncrypter.EncryptionException {
        return this.encryptionService.encrypt(clientSecret);
    }

    private BaseCacheService getCacheService() {
        if (this.appConfiguration.getUseLocalCache().booleanValue()) {
            return this.localCacheService;
        }
        return this.cacheService;
    }
}

