/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.ldap.ClientAuthorization;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.service.ClientService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.model.base.SimpleBranch;
import org.gluu.search.filter.Filter;
import org.gluu.service.CacheService;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@Named
public class ClientAuthorizationsService {
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private CacheService cacheService;
    @Inject
    private ClientService clientService;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private AppConfiguration appConfiguration;

    public void addBranch() {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName("authorizations");
        branch.setDn(this.createDn(null));
        this.ldapEntryManager.persist((Object)branch);
    }

    public boolean containsBranch() {
        return this.ldapEntryManager.contains(this.createDn(null), SimpleBranch.class);
    }

    public void prepareBranch() {
        String baseDn = this.createDn(null);
        if (!this.ldapEntryManager.hasBranchesSupport(baseDn)) {
            return;
        }
        if (!this.containsBranch()) {
            this.addBranch();
        }
    }

    public ClientAuthorization find(String userInum, String clientId) {
        this.prepareBranch();
        Filter filter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"oxAuthClientId", (Object)clientId), Filter.createEqualityFilter((String)"oxAuthUserId", (Object)userInum)});
        List entries = this.ldapEntryManager.findEntries(this.staticConfiguration.getBaseDn().getAuthorizations(), ClientAuthorization.class, filter);
        if (entries != null && !entries.isEmpty()) {
            if (entries.size() > 1) {
                this.log.error("Found more then one client authorization entry by client Id: {}" + clientId);
                for (ClientAuthorization entry : entries) {
                    this.log.error(entry.toString());
                }
            }
            return (ClientAuthorization)entries.get(0);
        }
        return null;
    }

    public void clearAuthorizations(ClientAuthorization clientAuthorization, boolean persistInLdap) {
        if (clientAuthorization == null) {
            return;
        }
        if (persistInLdap) {
            this.ldapEntryManager.remove((Object)clientAuthorization);
        } else {
            String key = this.getCacheKey(clientAuthorization.getUserId(), clientAuthorization.getClientId());
            this.cacheService.remove(key);
        }
    }

    public void add(String userInum, String clientId, Set<String> scopes) {
        this.log.trace("Attempting to add client authorization, scopes:" + scopes + ", clientId: " + clientId + ", userInum: " + userInum);
        Client client = this.clientService.getClient(clientId);
        this.prepareBranch();
        ClientAuthorization clientAuthorization = this.find(userInum, clientId);
        if (clientAuthorization == null) {
            clientAuthorization = new ClientAuthorization();
            clientAuthorization.setId(UUID.randomUUID().toString());
            clientAuthorization.setClientId(clientId);
            clientAuthorization.setUserId(userInum);
            clientAuthorization.setScopes(scopes.toArray(new String[scopes.size()]));
            clientAuthorization.setDn(this.createDn(clientAuthorization.getId()));
            clientAuthorization.setDeletable(client.getAttributes().getKeepClientAuthorizationAfterExpiration() == false);
            clientAuthorization.setExpirationDate(client.getExpirationDate());
            clientAuthorization.setTtl(this.appConfiguration.getDynamicRegistrationExpirationTime());
            this.ldapEntryManager.persist((Object)clientAuthorization);
        } else if (clientAuthorization.getScopes() != null) {
            HashSet<String> set = new HashSet<String>(scopes);
            set.addAll(Arrays.asList(clientAuthorization.getScopes()));
            clientAuthorization.setScopes(set.toArray(new String[set.size()]));
            this.ldapEntryManager.merge((Object)clientAuthorization);
        }
    }

    public String createDn(String oxId) {
        String baseDn = this.staticConfiguration.getBaseDn().getAuthorizations();
        if (StringHelper.isEmpty((String)oxId)) {
            return baseDn;
        }
        return String.format("oxId=%s,%s", oxId, baseDn);
    }

    private String getCacheKey(String userInum, String clientId) {
        return userInum + "_" + clientId;
    }
}

