/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.registration;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.client.RegisterRequest;
import org.gluu.oxauth.model.common.GrantType;
import org.gluu.oxauth.model.common.ResponseType;
import org.gluu.oxauth.model.common.SubjectType;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.register.ApplicationType;
import org.gluu.oxauth.model.register.RegisterErrorResponseType;
import org.gluu.oxauth.model.util.Pair;
import org.gluu.oxauth.model.util.URLPatternList;
import org.gluu.oxauth.model.util.Util;
import org.gluu.oxauth.util.ServerUtil;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.json.JSONArray;
import org.slf4j.Logger;

@Stateless
@Named
public class RegisterParamsValidator {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String LOCALHOST = "localhost";
    private static final String LOOPBACK = "127.0.0.1";

    public Pair<Boolean, String> validateParamsClientRegister(ApplicationType applicationType, SubjectType subjectType, List<GrantType> grantTypes, List<ResponseType> responseTypes, List<String> redirectUris) {
        if (applicationType == null) {
            return new Pair((Object)false, (Object)"application_type is not valid.");
        }
        if (grantTypes != null && (grantTypes.contains(GrantType.AUTHORIZATION_CODE) || grantTypes.contains(GrantType.IMPLICIT) || responseTypes.contains(ResponseType.CODE) || responseTypes.contains(ResponseType.TOKEN) || responseTypes.contains(ResponseType.ID_TOKEN)) && (redirectUris == null || redirectUris.isEmpty())) {
            return new Pair((Object)false, (Object)"Redirect uris are empty.");
        }
        if (subjectType == null || !this.appConfiguration.getSubjectTypesSupported().contains(subjectType.toString())) {
            this.log.debug("Parameter subject_type is not valid.");
            return new Pair((Object)false, (Object)"Parameter subject_type is not valid.");
        }
        return new Pair((Object)true, (Object)"");
    }

    public void validateAlgorithms(RegisterRequest registerRequest) {
        if (registerRequest.getIdTokenSignedResponseAlg() != null && registerRequest.getIdTokenSignedResponseAlg() != SignatureAlgorithm.NONE && !this.appConfiguration.getIdTokenSigningAlgValuesSupported().contains(registerRequest.getIdTokenSignedResponseAlg().toString())) {
            this.log.debug("Parameter id_token_signed_response_alg is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter id_token_signed_response_alg is not valid.");
        }
        if (registerRequest.getIdTokenEncryptedResponseAlg() != null && !this.appConfiguration.getIdTokenEncryptionAlgValuesSupported().contains(registerRequest.getIdTokenEncryptedResponseAlg().toString())) {
            this.log.debug("Parameter id_token_encrypted_response_alg is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter id_token_encrypted_response_alg is not valid.");
        }
        if (registerRequest.getIdTokenEncryptedResponseEnc() != null && !this.appConfiguration.getIdTokenEncryptionEncValuesSupported().contains(registerRequest.getIdTokenEncryptedResponseEnc().toString())) {
            this.log.debug("Parameter id_token_encrypted_response_enc is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter id_token_encrypted_response_enc is not valid.");
        }
        if (registerRequest.getUserInfoSignedResponseAlg() != null && !this.appConfiguration.getUserInfoSigningAlgValuesSupported().contains(registerRequest.getUserInfoSignedResponseAlg().toString())) {
            this.log.debug("Parameter userinfo_signed_response_alg is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter userinfo_signed_response_alg is not valid.");
        }
        if (registerRequest.getUserInfoEncryptedResponseAlg() != null && !this.appConfiguration.getUserInfoEncryptionAlgValuesSupported().contains(registerRequest.getUserInfoEncryptedResponseAlg().toString())) {
            this.log.debug("Parameter userinfo_encrypted_response_alg is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter userinfo_encrypted_response_alg is not valid.");
        }
        if (registerRequest.getUserInfoEncryptedResponseEnc() != null && !this.appConfiguration.getUserInfoEncryptionEncValuesSupported().contains(registerRequest.getUserInfoEncryptedResponseEnc().toString())) {
            this.log.debug("Parameter userinfo_encrypted_response_enc is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter userinfo_encrypted_response_enc is not valid.");
        }
        if (registerRequest.getRequestObjectSigningAlg() != null && !this.appConfiguration.getRequestObjectSigningAlgValuesSupported().contains(registerRequest.getRequestObjectSigningAlg().toString())) {
            this.log.debug("Parameter request_object_signing_alg is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter request_object_signing_alg is not valid.");
        }
        if (registerRequest.getRequestObjectEncryptionAlg() != null && !this.appConfiguration.getRequestObjectEncryptionAlgValuesSupported().contains(registerRequest.getRequestObjectEncryptionAlg().toString())) {
            this.log.debug("Parameter request_object_encryption_alg is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter request_object_encryption_alg is not valid.");
        }
        if (registerRequest.getRequestObjectEncryptionEnc() != null && !this.appConfiguration.getRequestObjectEncryptionEncValuesSupported().contains(registerRequest.getRequestObjectEncryptionEnc().toString())) {
            this.log.debug("Parameter request_object_encryption_enc is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter request_object_encryption_enc is not valid.");
        }
        if (registerRequest.getTokenEndpointAuthMethod() != null && !this.appConfiguration.getTokenEndpointAuthMethodsSupported().contains(registerRequest.getTokenEndpointAuthMethod().toString())) {
            this.log.debug("Parameter token_endpoint_auth_method is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter token_endpoint_auth_method is not valid.");
        }
        if (registerRequest.getTokenEndpointAuthSigningAlg() != null && !this.appConfiguration.getTokenEndpointAuthSigningAlgValuesSupported().contains(registerRequest.getTokenEndpointAuthSigningAlg().toString())) {
            this.log.debug("Parameter token_endpoint_auth_signing_alg is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter token_endpoint_auth_signing_alg is not valid.");
        }
    }

    public boolean validateParamsClientRead(String clientId, String accessToken) {
        return StringUtils.isNotBlank((String)clientId) && StringUtils.isNotBlank((String)accessToken);
    }

    public boolean validateRedirectUris(List<GrantType> grantTypes, List<ResponseType> responseTypes, ApplicationType applicationType, SubjectType subjectType, List<String> redirectUris, String sectorIdentifierUrl) {
        boolean valid = true;
        HashSet<String> redirectUriHosts = new HashSet<String>();
        if (redirectUris != null && !redirectUris.isEmpty()) {
            for (String redirectUri : redirectUris) {
                if (redirectUri == null || redirectUri.contains("#")) {
                    valid = false;
                    continue;
                }
                URI uri = null;
                try {
                    uri = new URI(redirectUri);
                }
                catch (URISyntaxException e) {
                    this.log.debug("Failed to parse redirect_uri: {}, error: {}", (Object)redirectUri, (Object)e.getMessage());
                    valid = false;
                    continue;
                }
                redirectUriHosts.add(uri.getHost());
                switch (applicationType) {
                    case WEB: {
                        if (!HTTP.equalsIgnoreCase(uri.getScheme()) || LOCALHOST.equalsIgnoreCase(uri.getHost()) || LOOPBACK.equalsIgnoreCase(uri.getHost())) break;
                        this.log.debug("Invalid protocol for redirect_uri: " + redirectUri + " (only https protocol is allowed for application_type=web or localhost/127.0.0.1 for http)");
                        valid = false;
                        break;
                    }
                }
            }
        } else {
            valid = !grantTypes.contains(GrantType.AUTHORIZATION_CODE) && !grantTypes.contains(GrantType.IMPLICIT) && !responseTypes.contains(ResponseType.CODE) && !responseTypes.contains(ResponseType.TOKEN) && !responseTypes.contains(ResponseType.ID_TOKEN);
        }
        if (subjectType != null && subjectType.equals((Object)SubjectType.PAIRWISE) && StringUtils.isBlank((String)sectorIdentifierUrl) && redirectUriHosts.size() > 1) {
            valid = false;
        }
        if (valid && StringUtils.isNotBlank((String)sectorIdentifierUrl)) {
            try {
                URI uri = new URI(sectorIdentifierUrl);
                if (!HTTPS.equalsIgnoreCase(uri.getScheme())) {
                    valid = false;
                }
                ClientRequest clientRequest = new ClientRequest(sectorIdentifierUrl);
                clientRequest.setHttpMethod("GET");
                ClientResponse clientResponse = clientRequest.get(String.class);
                int status = clientResponse.getStatus();
                if (status == 200) {
                    String entity = (String)clientResponse.getEntity(String.class);
                    JSONArray sectorIdentifierJsonArray = new JSONArray(entity);
                    valid = Util.asList((JSONArray)sectorIdentifierJsonArray).containsAll(redirectUris);
                }
            }
            catch (Exception e) {
                this.log.debug(e.getMessage(), (Throwable)e);
                valid = false;
            }
        }
        if (valid) {
            valid = this.checkWhiteListRedirectUris(redirectUris) && this.checkBlackListRedirectUris(redirectUris);
        }
        return valid;
    }

    public boolean validateInitiateLoginUri(String initiateLoginUri) {
        boolean valid = false;
        try {
            URI uri = new URI(initiateLoginUri);
            if (HTTPS.equalsIgnoreCase(uri.getScheme())) {
                valid = true;
            }
        }
        catch (URISyntaxException e) {
            this.log.debug(e.getMessage(), (Throwable)e);
            valid = false;
        }
        return valid;
    }

    private boolean checkWhiteListRedirectUris(List<String> redirectUris) {
        boolean valid = true;
        List whiteList = this.appConfiguration.getClientWhiteList();
        URLPatternList urlPatternList = new URLPatternList(whiteList);
        for (String redirectUri : redirectUris) {
            valid &= urlPatternList.isUrlListed(redirectUri);
        }
        return valid;
    }

    private boolean checkBlackListRedirectUris(List<String> redirectUris) {
        boolean valid = true;
        List blackList = this.appConfiguration.getClientBlackList();
        URLPatternList urlPatternList = new URLPatternList(blackList);
        for (String redirectUri : redirectUris) {
            valid &= !urlPatternList.isUrlListed(redirectUri);
        }
        return valid;
    }

    public void validateLogoutUri(List<String> logoutUris, List<String> redirectUris, ErrorResponseFactory errorResponseFactory) {
        if (logoutUris == null || logoutUris.isEmpty()) {
            return;
        }
        for (String logoutUri : logoutUris) {
            this.validateLogoutUri(logoutUri, redirectUris, errorResponseFactory);
        }
    }

    public void validateLogoutUri(String logoutUri, List<String> redirectUris, ErrorResponseFactory errorResponseFactory) {
        if (Util.isNullOrEmpty((String)logoutUri)) {
            return;
        }
        if (redirectUris == null || redirectUris.isEmpty()) {
            this.log.debug("Preconditions of logout uri validation are failed.");
            this.throwInvalidLogoutUri(errorResponseFactory);
            return;
        }
        try {
            Set<String> redirectUriHosts = RegisterParamsValidator.collectUriHosts(redirectUris);
            URI uri = new URI(logoutUri);
            if (!redirectUriHosts.contains(uri.getHost())) {
                this.log.debug("logout uri host is not within redirect_uris, logout_uri: {}, redirect_uris: {}", (Object)logoutUri, redirectUris);
                this.throwInvalidLogoutUri(errorResponseFactory);
                return;
            }
            if (!HTTPS.equalsIgnoreCase(uri.getScheme())) {
                this.log.debug("logout uri schema is not https, logout_uri: {}", (Object)logoutUri);
                this.throwInvalidLogoutUri(errorResponseFactory);
            }
        }
        catch (Exception e) {
            this.log.debug(e.getMessage(), (Throwable)e);
            this.throwInvalidLogoutUri(errorResponseFactory);
        }
    }

    private void throwInvalidLogoutUri(ErrorResponseFactory errorResponseFactory) throws WebApplicationException {
        throw new WebApplicationException(Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)errorResponseFactory.errorAsJson((IErrorType)RegisterErrorResponseType.INVALID_LOGOUT_URI, "Failed to valide logout uri.")).cacheControl(ServerUtil.cacheControl(true, false)).header("Pragma", (Object)"no-cache").build());
    }

    private static Set<String> collectUriHosts(List<String> uriList) throws URISyntaxException {
        HashSet<String> hosts = new HashSet<String>();
        for (String redirectUri : uriList) {
            URI uri = new URI(redirectUri);
            hosts.add(uri.getHost());
        }
        return hosts;
    }

    public boolean checkIfThereIsPasswordGrantType(List<GrantType> grantTypes) {
        if (grantTypes != null) {
            return grantTypes.stream().anyMatch(grantType -> grantType == GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        }
        return false;
    }
}

