/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.error;

import java.io.IOException;
import java.util.List;
import javax.enterprise.inject.Vetoed;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.model.authorize.AuthorizeErrorResponseType;
import org.gluu.oxauth.model.ciba.BackchannelAuthenticationErrorResponseType;
import org.gluu.oxauth.model.clientinfo.ClientInfoErrorResponseType;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.configuration.Configuration;
import org.gluu.oxauth.model.error.DefaultErrorResponse;
import org.gluu.oxauth.model.error.ErrorMessage;
import org.gluu.oxauth.model.error.ErrorMessages;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.error.JsonErrorResponse;
import org.gluu.oxauth.model.fido.u2f.U2fErrorResponseType;
import org.gluu.oxauth.model.register.RegisterErrorResponseType;
import org.gluu.oxauth.model.session.EndSessionErrorResponseType;
import org.gluu.oxauth.model.token.TokenErrorResponseType;
import org.gluu.oxauth.model.token.TokenRevocationErrorResponseType;
import org.gluu.oxauth.model.uma.UmaErrorResponseType;
import org.gluu.oxauth.model.userinfo.UserInfoErrorResponseType;
import org.gluu.oxauth.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Vetoed
public class ErrorResponseFactory
implements Configuration {
    private static Logger log = LoggerFactory.getLogger(ErrorResponseFactory.class);
    private ErrorMessages messages;
    private AppConfiguration appConfiguration;

    public ErrorResponseFactory() {
    }

    public ErrorResponseFactory(ErrorMessages messages, AppConfiguration appConfiguration) {
        this.messages = messages;
        this.appConfiguration = appConfiguration;
    }

    public ErrorMessages getMessages() {
        return this.messages;
    }

    public void setMessages(ErrorMessages p_messages) {
        this.messages = p_messages;
    }

    private ErrorMessage getError(List<ErrorMessage> p_list, IErrorType type) {
        log.debug("Looking for the error with id: {}", (Object)type);
        if (p_list != null) {
            for (ErrorMessage error : p_list) {
                if (!error.getId().equals(type.getParameter())) continue;
                log.debug("Found error, id: {}", (Object)type);
                return error;
            }
        }
        log.error("Error not found, id: {}", (Object)type);
        return new ErrorMessage(type.getParameter(), type.getParameter(), null);
    }

    public String getErrorAsJson(IErrorType p_type) {
        return this.getErrorResponse(p_type).toJSonString();
    }

    public String errorAsJson(IErrorType p_type, String reason) {
        DefaultErrorResponse error = this.getErrorResponse(p_type);
        error.setReason(this.appConfiguration.getErrorReasonEnabled() != false ? reason : "");
        return error.toJSonString();
    }

    public WebApplicationException createWebApplicationException(Response.Status status, IErrorType type, String reason) throws WebApplicationException {
        return new WebApplicationException(Response.status((Response.Status)status).entity((Object)this.errorAsJson(type, reason)).type(MediaType.APPLICATION_JSON_TYPE).build());
    }

    public String getErrorAsJson(IErrorType p_type, String p_state, String reason) {
        return this.getErrorResponse(p_type, p_state, reason).toJSonString();
    }

    public String getErrorAsQueryString(IErrorType p_type, String p_state) {
        return this.getErrorAsQueryString(p_type, p_state, "");
    }

    public String getErrorAsQueryString(IErrorType p_type, String p_state, String reason) {
        return this.getErrorResponse(p_type, p_state, reason).toQueryString();
    }

    public DefaultErrorResponse getErrorResponse(IErrorType type, String p_state, String reason) {
        DefaultErrorResponse response = this.getErrorResponse(type);
        response.setState(p_state);
        response.setReason(reason);
        return response;
    }

    public DefaultErrorResponse getErrorResponse(IErrorType type) {
        DefaultErrorResponse response = new DefaultErrorResponse();
        response.setType(type);
        if (type != null && this.messages != null) {
            List<ErrorMessage> list = null;
            if (type instanceof AuthorizeErrorResponseType) {
                list = this.messages.getAuthorize();
            } else if (type instanceof ClientInfoErrorResponseType) {
                list = this.messages.getClientInfo();
            } else if (type instanceof EndSessionErrorResponseType) {
                list = this.messages.getEndSession();
            } else if (type instanceof RegisterErrorResponseType) {
                list = this.messages.getRegister();
            } else if (type instanceof TokenErrorResponseType) {
                list = this.messages.getToken();
            } else if (type instanceof TokenRevocationErrorResponseType) {
                list = this.messages.getRevoke();
            } else if (type instanceof UmaErrorResponseType) {
                list = this.messages.getUma();
            } else if (type instanceof UserInfoErrorResponseType) {
                list = this.messages.getUserInfo();
            } else if (type instanceof U2fErrorResponseType) {
                list = this.messages.getFido();
            } else if (type instanceof BackchannelAuthenticationErrorResponseType) {
                list = this.messages.getBackchannelAuthentication();
            }
            if (list != null) {
                ErrorMessage m = this.getError(list, type);
                response.setErrorDescription(m.getDescription());
                response.setErrorUri(m.getUri());
            }
        }
        return response;
    }

    public String getJsonErrorResponse(IErrorType type) {
        DefaultErrorResponse response = this.getErrorResponse(type);
        JsonErrorResponse jsonErrorResponse = new JsonErrorResponse(response);
        try {
            return ServerUtil.asJson(jsonErrorResponse);
        }
        catch (IOException ex) {
            log.error("Failed to generate error response", (Throwable)ex);
            return null;
        }
    }
}

